/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.grammar;

import javax.annotation.Nonnull;
import org.raml.v2.internal.framework.grammar.rule.AnyOfRule;
import org.raml.v2.internal.framework.grammar.rule.KeyValueRule;
import org.raml.v2.internal.framework.grammar.rule.NodeReferenceFactory;
import org.raml.v2.internal.framework.grammar.rule.ObjectRule;
import org.raml.v2.internal.framework.grammar.rule.RegexValueRule;
import org.raml.v2.internal.framework.grammar.rule.Rule;
import org.raml.v2.internal.framework.grammar.rule.StringValueRule;
import org.raml.v2.internal.framework.grammar.rule.TypeNodeReferenceRule;
import org.raml.v2.internal.framework.grammar.rule.TypesFactory;
import org.raml.v2.internal.framework.nodes.StringNodeImpl;
import org.raml.v2.internal.impl.commons.grammar.BaseRamlGrammar;
import org.raml.v2.internal.impl.commons.nodes.AnnotationNode;
import org.raml.v2.internal.impl.commons.nodes.AnnotationReferenceNode;
import org.raml.v2.internal.impl.commons.nodes.AnnotationTypeNode;
import org.raml.v2.internal.impl.commons.nodes.ExampleTypeNode;
import org.raml.v2.internal.impl.commons.nodes.ExtendsNode;
import org.raml.v2.internal.impl.commons.nodes.MultipleExampleTypeNode;
import org.raml.v2.internal.impl.commons.nodes.PropertyNode;
import org.raml.v2.internal.impl.v10.nodes.LibraryNode;
import org.raml.v2.internal.impl.v10.nodes.types.factories.TypeNodeFactory;

public class Raml10Grammar
extends BaseRamlGrammar {
    public static final String ANNOTATION_TYPES_KEY_NAME = "annotationTypes";

    @Override
    public ObjectRule raml() {
        return super.raml().with(this.annotationTypesField()).with(this.annotationField()).with(this.typesField()).with(this.usesField());
    }

    @Override
    protected ObjectRule resourceValue() {
        return super.resourceValue().with(this.annotationField());
    }

    @Override
    protected ObjectRule methodValue() {
        return super.methodValue().with(this.field(this.queryStringKey(), this.anyOf(this.scalarType(), this.type()))).with(this.annotationField());
    }

    @Override
    protected ObjectRule securitySchemePart() {
        return super.securitySchemePart().with(this.annotationField());
    }

    @Override
    protected ObjectRule response() {
        return super.response().with(this.annotationField());
    }

    protected KeyValueRule typesField() {
        return this.field(this.typesKey(), this.types());
    }

    protected StringValueRule typesKey() {
        return this.string("types").description("Declarations of (data) types for use within this API.");
    }

    protected KeyValueRule annotationField() {
        return this.field(this.annotationKey().then(new NodeReferenceFactory(AnnotationReferenceNode.class)), this.any()).then(AnnotationNode.class);
    }

    protected RegexValueRule annotationKey() {
        return this.regex("\\((.+)\\)").label("(Annotation)").suggest("(<cursor>)").description("Annotations to be applied to this API. Annotations are any property whose key begins with \"(\" and ends with \")\" and whose name (the part between the beginning and ending parentheses) is a declared annotation name..");
    }

    protected KeyValueRule usesField() {
        return this.field(this.usesKey(), this.library());
    }

    public Rule extension() {
        return this.untitledRaml().with((KeyValueRule)this.requiredField(this.extendsKey(), this.scalarType()).then(ExtendsNode.class)).with(this.usageField()).with(this.optionalTitleField());
    }

    protected StringValueRule extendsKey() {
        return this.string("extends").description("The path to the base RAML document to be extended.");
    }

    protected KeyValueRule optionalTitleField() {
        return this.field(this.titleKey(), this.scalarType());
    }

    public Rule library() {
        return this.objectType("library").with((KeyValueRule)this.field(this.scalarType(), this.libraryValue()).then(LibraryNode.class));
    }

    public Rule libraryValue() {
        return this.objectType().with(this.typesField()).with(this.schemasField()).with(this.resourceTypesField()).with(this.traitsField()).with(this.securitySchemesField()).with(this.annotationTypesField()).with(this.annotationField()).with(this.field(this.usesKey(), this.ref("library"))).with(this.usageField());
    }

    protected KeyValueRule annotationTypesField() {
        return this.field(this.annotationTypesKey(), this.annotationTypes());
    }

    protected StringValueRule annotationTypesKey() {
        return this.string(ANNOTATION_TYPES_KEY_NAME).description("Declarations of annotation types for use by annotations.");
    }

    protected Rule annotationTypes() {
        return this.objectType().with((KeyValueRule)this.field(this.scalarType(), this.annotationType()).then(AnnotationTypeNode.class));
    }

    private Rule annotationType() {
        return this.anyOf("type", this.stringType().then(new TypesFactory()), this.explicitType().with(this.field(this.string("allowedTargets"), this.anyOf(this.scalarType(), this.array(this.scalarType())))));
    }

    protected Rule types() {
        return this.objectType().with(this.field(this.scalarType(), this.type()));
    }

    @Override
    protected Rule parameter() {
        return this.type();
    }

    public Rule type() {
        return this.anyOf("type", this.stringType().then(new TypesFactory()), this.explicitType());
    }

    private ObjectRule explicitType() {
        return this.objectType().with(this.field(this.anyOf(this.typeKey(), this.string("schema")), this.typeReference())).with(this.xmlFacetField()).with(this.displayNameField()).with(this.descriptionField()).with(this.usageField()).with(this.annotationField()).with(this.defaultField()).with(this.field(this.string("required"), this.booleanType())).with(this.exampleFieldRule()).with(this.multipleExampleFieldRule()).with(this.when("type", this.is(this.stringTypeLiteral()).add(this.field(this.string("pattern"), this.scalarType())).add(this.field(this.string("minLength"), this.integerType())).add(this.field(this.string("maxLength"), this.integerType())).add(this.field(this.string("enum"), this.array(this.scalarType()))), this.is(this.dateTypeLiteral()).add(this.field(this.string("format"), this.stringType())), this.is(this.arrayTypeLiteral()).add(this.field(this.string("uniqueItems"), this.booleanType())).add(this.field(this.string("items"), this.ref("type"))).add(this.field(this.string("minItems"), this.integerType())).add(this.field(this.string("maxItems"), this.integerType())), this.is(this.numericTypeLiteral()).add(this.field(this.string("minimum"), this.integerType())).add(this.field(this.string("maximum"), this.integerType())).add(this.field(this.string("format"), this.scalarType())).add(this.field(this.string("multipleOf"), this.integerType())).add(this.field(this.string("enum"), this.array(this.integerType()))), this.is(this.fileTypeLiteral()).add(this.field(this.string("fileTypes"), this.any())).add(this.field(this.string("minLength"), this.integerType())).add(this.field(this.string("maxLength"), this.integerType())), this.is(this.objectTypeLiteral()).add(this.field(this.string("properties"), this.properties())).add(this.field(this.string("minProperties"), this.integerType())).add(this.field(this.string("maxProperties"), this.integerType())).add(this.field(this.string("additionalProperties"), this.anyOf(this.scalarType(), this.ref("type")))).add(this.field(this.string("patternProperties"), this.properties())).add(this.field(this.string("discriminator"), this.anyOf(this.scalarType(), this.booleanType()))).add(this.field(this.string("discriminatorValue"), this.scalarType()))).defaultValue(new StringNodeImpl("string"))).then(new TypeNodeFactory());
    }

    private KeyValueRule xmlFacetField() {
        return this.field(this.string("xml"), this.any());
    }

    private KeyValueRule defaultField() {
        return this.field(this.string("default"), this.any());
    }

    private AnyOfRule typeReference() {
        return this.anyOf(this.objectTypeLiteral(), this.arrayTypeLiteral(), this.stringTypeLiteral(), this.numericTypeLiteral(), this.booleanTypeLiteral(), this.dateTypeLiteral(), this.fileTypeLiteral(), new TypeNodeReferenceRule("types"));
    }

    @Override
    protected Rule mimeType() {
        return this.type();
    }

    protected KeyValueRule exampleFieldRule() {
        return this.field(this.stringExcluding("example", "examples"), this.any().then(ExampleTypeNode.class));
    }

    protected KeyValueRule multipleExampleFieldRule() {
        return this.field(this.stringExcluding("examples", "example"), this.any().then(MultipleExampleTypeNode.class));
    }

    protected StringValueRule fileTypeLiteral() {
        return this.string("file");
    }

    protected Rule numericTypeLiteral() {
        return this.anyOf(this.numberTypeLiteral(), this.integerTypeLiteral());
    }

    protected Rule numberTypeLiteral() {
        return this.string("number");
    }

    protected Rule integerTypeLiteral() {
        return this.string("integer");
    }

    protected Rule booleanTypeLiteral() {
        return this.string("boolean");
    }

    protected StringValueRule stringTypeLiteral() {
        return this.string("string");
    }

    protected AnyOfRule dateTypeLiteral() {
        return new AnyOfRule(this.string("date-only"), this.string("time-only"), this.string("datetime-only"), this.string("datetime"));
    }

    protected AnyOfRule arrayTypeLiteral() {
        return new AnyOfRule(this.regex(".+\\[\\]"), this.string("array"));
    }

    protected ObjectRule properties() {
        return this.objectType().with((KeyValueRule)this.field(this.scalarType(), this.ref("type")).then(PropertyNode.class));
    }

    protected Rule objectTypeLiteral() {
        return this.not(this.anyBuiltinType());
    }

    @Override
    protected KeyValueRule mediaTypeField() {
        return this.field(this.mediaTypeKey(), this.anyOf(this.scalarType(), this.array(this.scalarType())));
    }

    @Override
    protected Rule schemasValue() {
        return this.types();
    }

    @Override
    @Nonnull
    protected String schemasDescription() {
        return "Alias for the equivalent \"types\" property, for compatibility with RAML 0.8. Deprecated - API definitions should use the \"types\" property, as the \"schemas\" alias for that property name may be removed in a future RAML version. The \"types\" property allows for XML and JSON schemas.";
    }

    @Override
    protected Rule traitsValue() {
        return this.trait();
    }

    @Override
    protected Rule resourceTypesValue() {
        return this.resourceTypes();
    }

    @Override
    protected Rule securitySchemesValue() {
        return this.securitySchemes();
    }
}

