/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.phase;

import java.util.List;
import org.raml.v2.internal.framework.grammar.rule.ErrorNodeFactory;
import org.raml.v2.internal.framework.grammar.rule.Rule;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.phase.Phase;
import org.raml.v2.internal.impl.commons.nodes.AnnotationNode;
import org.raml.v2.internal.impl.commons.nodes.AnnotationTypeNode;
import org.raml.v2.internal.impl.commons.phase.TypeToRuleVisitor;
import org.raml.v2.internal.impl.v10.nodes.types.builtin.TypeNode;

public class AnnotationValidationPhase
implements Phase {
    @Override
    public Node apply(Node tree) {
        List<AnnotationNode> annotations = tree.findDescendantsWith(AnnotationNode.class);
        for (AnnotationNode annotation : annotations) {
            String annotationName = annotation.getName();
            AnnotationTypeNode annotationTypeNode = annotation.getAnnotationTypeNode();
            if (annotationTypeNode == null) {
                annotation.replaceWith(ErrorNodeFactory.createMissingAnnotationType(annotationName));
                continue;
            }
            TypeNode typeNode = annotationTypeNode.getTypeNode();
            Rule rule = typeNode.visit(new TypeToRuleVisitor());
            Node value = annotation.getValue();
            Node transform = rule.apply(value);
            value.replaceWith(transform);
        }
        return tree;
    }
}

