/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.framework.grammar.rule;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.framework.grammar.rule.ErrorNodeFactory;
import org.raml.v2.internal.framework.grammar.rule.Rule;
import org.raml.v2.internal.framework.nodes.KeyValueNode;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.ObjectNode;
import org.raml.v2.internal.framework.nodes.SchemaNodeImpl;
import org.raml.v2.internal.framework.nodes.StringNode;
import org.raml.v2.internal.framework.suggester.RamlParsingContext;
import org.raml.v2.internal.framework.suggester.Suggestion;
import org.raml.v2.internal.utils.SchemaGenerator;
import org.xml.sax.SAXException;

public class XmlSchemaValidationRule
extends Rule {
    private Schema schema;
    private String type;

    public XmlSchemaValidationRule(Node schemaNode, ResourceLoader resourceLoader) {
        try {
            this.schema = new SchemaGenerator(resourceLoader).generateXmlSchema(schemaNode);
            this.type = ((SchemaNodeImpl)schemaNode).getTypeReference();
        }
        catch (SAXException e) {
            this.schema = null;
        }
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, RamlParsingContext context) {
        return Lists.newArrayList();
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        return false;
    }

    @Override
    @Nonnull
    public Node apply(@Nonnull Node node) {
        if (this.schema == null) {
            return ErrorNodeFactory.createInvalidXmlExampleNode("Invalid XmlSchema");
        }
        Node source = node.getSource();
        if (source == null) {
            if (node instanceof StringNode) {
                source = node;
            } else {
                if (!(node instanceof ObjectNode)) {
                    return ErrorNodeFactory.createInvalidXmlExampleNode("Source was null");
                }
                if (node.getChildren().size() == 1 && node.getChildren().get(0) instanceof KeyValueNode && ((KeyValueNode)node.getChildren().get(0)).getValue() instanceof StringNode) {
                    source = ((KeyValueNode)node.getChildren().get(0)).getValue();
                }
            }
        }
        if (source instanceof StringNode) {
            this.internalValidateExample(node, (StringNode)source);
        }
        return node;
    }

    private void internalValidateExample(@Nonnull Node node, StringNode source) {
        String value = source.getValue();
        try {
            if (this.type != null && !value.startsWith("<" + this.type)) {
                node.replaceWith(ErrorNodeFactory.createInvalidXmlExampleNode("provided object is not of type " + this.type));
            } else {
                this.schema.newValidator().validate(new StreamSource(new StringReader(value)));
            }
        }
        catch (IOException | SAXException e) {
            node.replaceWith(ErrorNodeFactory.createInvalidXmlExampleNode(e.getMessage()));
        }
    }

    @Override
    public String getDescription() {
        return null;
    }
}

