/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.framework.grammar.rule;

import com.google.common.collect.Range;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.v2.internal.framework.grammar.rule.AbstractTypeRule;
import org.raml.v2.internal.framework.nodes.IntegerNode;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.NodeType;
import org.raml.v2.internal.framework.nodes.StringNode;
import org.raml.v2.internal.framework.suggester.RamlParsingContext;
import org.raml.v2.internal.framework.suggester.Suggestion;

public class IntegerTypeRule
extends AbstractTypeRule {
    @Nullable
    private Range<Integer> range;

    public IntegerTypeRule(@Nullable Range<Integer> range) {
        this.range = range;
    }

    public IntegerTypeRule() {
        this(null);
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, RamlParsingContext context) {
        return Collections.emptyList();
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        if (node instanceof IntegerNode) {
            return this.range == null || this.range.contains((Comparable)((IntegerNode)node).getValue());
        }
        if (node instanceof StringNode) {
            try {
                Integer value = Integer.parseInt(((StringNode)node).getValue());
                return this.range == null || this.range.contains((Comparable)value);
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        return "Integer";
    }

    @Override
    @Nonnull
    NodeType getType() {
        return NodeType.Integer;
    }
}

