/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.phase;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.framework.nodes.IncludeErrorNode;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.StringNodeImpl;
import org.raml.v2.internal.framework.nodes.snakeyaml.RamlNodeParser;
import org.raml.v2.internal.framework.nodes.snakeyaml.SYIncludeNode;
import org.raml.v2.internal.framework.phase.Transformer;
import org.raml.v2.internal.impl.commons.RamlHeader;
import org.raml.v2.internal.utils.StreamUtils;

public class IncludeResolver
implements Transformer {
    private final ResourceLoader resourceLoader;
    private final String resourceLocation;

    public IncludeResolver(ResourceLoader resourceLoader, String resourceLocation) {
        this.resourceLoader = resourceLoader;
        this.resourceLocation = resourceLocation;
    }

    @Override
    public boolean matches(Node tree) {
        return tree instanceof SYIncludeNode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Node transform(Node tree) {
        SYIncludeNode includeNode = (SYIncludeNode)tree;
        String resourcePath = this.applyResourceLocation(includeNode.getIncludePath());
        try (InputStream inputStream = this.resourceLoader.fetchResource(resourcePath);){
            Node result;
            if (inputStream == null) {
                String msg = "Include cannot be resolved: " + resourcePath;
                IncludeErrorNode includeErrorNode = new IncludeErrorNode(msg);
                return includeErrorNode;
            }
            String includeContent = StreamUtils.toString(inputStream);
            if (resourcePath.endsWith(".raml") || resourcePath.endsWith(".yaml") || resourcePath.endsWith(".yml")) {
                boolean supportUses = false;
                try {
                    RamlHeader ramlHeader = RamlHeader.parse(includeContent);
                    supportUses = ramlHeader.getFragment() != null;
                }
                catch (RamlHeader.InvalidHeaderException e) {
                    // empty catch block
                }
                result = RamlNodeParser.parse(includeContent, supportUses);
            } else {
                result = new StringNodeImpl(includeContent);
            }
            if (result == null) {
                String msg = "Include file is empty: " + resourcePath;
                result = new IncludeErrorNode(msg);
            }
            Node node = result;
            return node;
        }
        catch (IOException e) {
            String msg = String.format("Include cannot be resolved: %s. (%s)", resourcePath, e.getMessage());
            return new IncludeErrorNode(msg);
        }
    }

    private String applyResourceLocation(String includePath) {
        int lastSlash;
        String result = includePath;
        if (!this.isAbsolute(includePath) && (lastSlash = this.resourceLocation.lastIndexOf("/")) != -1) {
            result = this.resourceLocation.substring(0, lastSlash + 1) + includePath;
        }
        if (result.contains("#")) {
            return result.split("#")[0];
        }
        return result;
    }

    private boolean isAbsolute(String includePath) {
        if (includePath.startsWith("http:") || includePath.startsWith("https:") || includePath.startsWith("file:")) {
            return true;
        }
        return new File(includePath).isAbsolute();
    }
}

