/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.model;

import java.util.ArrayList;
import java.util.List;
import org.raml.v2.internal.framework.nodes.KeyValueNode;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.impl.commons.model.CommonAttributes;
import org.raml.v2.internal.impl.commons.model.Method;
import org.raml.v2.internal.impl.commons.model.ResourceTypeRef;
import org.raml.v2.internal.impl.commons.model.SecuritySchemeRef;
import org.raml.v2.internal.impl.commons.model.StringType;
import org.raml.v2.internal.impl.commons.model.TraitRef;
import org.raml.v2.internal.impl.commons.model.TypeDeclaration;
import org.raml.v2.internal.impl.commons.nodes.MethodNode;
import org.raml.v2.internal.impl.commons.nodes.ResourceNode;
import org.raml.v2.internal.utils.NodeSelector;

public class Resource
extends CommonAttributes {
    private ResourceNode node;

    public Resource(ResourceNode node) {
        this.node = node;
    }

    @Override
    protected Node getNode() {
        return this.node.getValue();
    }

    public StringType relativeUri() {
        return new StringType(this.node.getRelativeUri());
    }

    public String resourcePath() {
        return this.node.getResourcePath();
    }

    public List<Resource> resources() {
        ArrayList<Resource> resultList = new ArrayList<Resource>();
        for (Node item : this.node.getValue().getChildren()) {
            if (!(item instanceof ResourceNode)) continue;
            resultList.add(new Resource((ResourceNode)item));
        }
        return resultList;
    }

    public List<Method> methods() {
        ArrayList<Method> resultList = new ArrayList<Method>();
        for (Node item : this.node.getValue().getChildren()) {
            if (!(item instanceof MethodNode)) continue;
            resultList.add(new Method((MethodNode)item));
        }
        return resultList;
    }

    public ResourceTypeRef type() {
        Node type = NodeSelector.selectFrom("type", this.getNode());
        if (type == null) {
            return null;
        }
        return new ResourceTypeRef(type);
    }

    public List<TraitRef> is() {
        return this.getList("is", TraitRef.class);
    }

    public List<SecuritySchemeRef> securedBy() {
        return this.getList("securedBy", SecuritySchemeRef.class);
    }

    public List<TypeDeclaration> uriParameters() {
        ArrayList<TypeDeclaration> result = new ArrayList<TypeDeclaration>();
        Node uriParamsNode = NodeSelector.selectFrom("uriParameters", this.node.getValue());
        if (uriParamsNode != null) {
            for (Node child : uriParamsNode.getChildren()) {
                result.add(new TypeDeclaration((KeyValueNode)child));
            }
        }
        return result;
    }

    public Resource parentResource() {
        ResourceNode parent = this.node.getParentResourceNode();
        return parent != null ? new Resource(parent) : null;
    }
}

