/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.codegen.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.jsonschema2pojo.AnnotationStyle;
import org.raml.jaxrs.codegen.core.Configuration;
import org.raml.jaxrs.codegen.core.GeneratorProxy;
import org.raml.jaxrs.codegen.core.ext.GeneratorExtension;

@Mojo(name="generate", requiresProject=true, threadSafe=false, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class RamlJaxrsCodegenMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/generated-sources/raml-jaxrs")
    private File outputDirectory;
    @Parameter(property="sourcePaths")
    private File[] sourcePaths;
    @Parameter(property="sourceDirectory", defaultValue="${basedir}/src/main/raml")
    private File sourceDirectory;
    @Parameter(property="jaxrsVersion", defaultValue="1.1")
    private String jaxrsVersion;
    @Parameter(property="basePackageName", required=true)
    private String basePackageName;
    @Parameter(property="modelPackageName", defaultValue="model")
    private String modelPackageName;
    @Parameter(property="useJsr303Annotations", defaultValue="false")
    private boolean useJsr303Annotations;
    @Parameter(property="generateClientProxy", defaultValue="false")
    private boolean generateClientProxy;
    @Parameter(property="mapToVoid", defaultValue="false")
    private boolean mapToVoid;
    @Parameter(property="removeOldOutput", defaultValue="false")
    private boolean removeOldOutput;
    @Parameter(property="useTitlePropertyForSchemaNames", defaultValue="false")
    private boolean useTitlePropertyForSchemaNames = false;
    @Parameter(property="jsonMapper", defaultValue="jackson1")
    private String jsonMapper;
    @Parameter(property="asyncResourceTrait")
    private String asyncResourceTrait;
    @Parameter(property="jsonMapperConfiguration")
    private Map<String, String> jsonMapperConfiguration;
    @Parameter(property="extensions")
    private String[] extensions;
    @Parameter(property="ignoredParameters")
    private String[] ignoredParameters;
    @Parameter(property="customAnnotator", defaultValue="")
    private String customAnnotator;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution...");
            return;
        }
        if (this.sourceDirectory == null && this.sourcePaths == null) {
            throw new MojoExecutionException("One of sourceDirectory or sourcePaths must be provided");
        }
        try {
            FileUtils.forceMkdir((File)this.outputDirectory);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Failed to create directory: " + this.outputDirectory, (Exception)ioe);
        }
        if (this.removeOldOutput) {
            try {
                FileUtils.cleanDirectory((File)this.outputDirectory);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Failed to clean directory: " + this.outputDirectory, (Exception)ioe);
            }
        }
        Configuration configuration = new Configuration();
        try {
            configuration.setUseTitlePropertyWhenPossible(this.useTitlePropertyForSchemaNames);
            configuration.setBasePackageName(this.basePackageName);
            configuration.setModelPackageName(this.modelPackageName);
            configuration.setJaxrsVersion(Configuration.JaxrsVersion.fromAlias((String)this.jaxrsVersion));
            configuration.setOutputDirectory(this.outputDirectory);
            configuration.setUseJsr303Annotations(this.useJsr303Annotations);
            configuration.setAsyncResourceTrait(this.asyncResourceTrait);
            configuration.setGenerateClientInterface(this.generateClientProxy);
            configuration.setJsonMapper(AnnotationStyle.valueOf((String)this.jsonMapper.toUpperCase()));
            configuration.setSourceDirectory(this.sourceDirectory);
            configuration.setJsonMapperConfiguration(this.jsonMapperConfiguration);
            configuration.setEmptyResponseReturnVoid(this.mapToVoid);
            if (this.ignoredParameters != null) {
                for (String s : this.ignoredParameters) {
                    configuration.getIgnoredParameterNames().add(s);
                }
            }
            if (this.customAnnotator != null && StringUtils.isNotEmpty((String)this.customAnnotator)) {
                configuration.setCustomAnnotator(Class.forName(this.customAnnotator));
            }
            if (this.extensions != null) {
                for (String className : this.extensions) {
                    Class<?> c = Class.forName(className);
                    if (c == null) {
                        throw new MojoExecutionException("generatorExtensionClass " + className + " cannot be loaded." + "Have you installed the correct dependency in the plugin configuration?");
                    }
                    if (!(c.newInstance() instanceof GeneratorExtension)) {
                        throw new MojoExecutionException("generatorExtensionClass " + className + " does not implement" + GeneratorExtension.class.getPackage() + "." + GeneratorExtension.class.getName());
                    }
                    configuration.getExtensions().add((GeneratorExtension)c.newInstance());
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to configure plug-in", e);
        }
        this.project.addCompileSourceRoot(this.outputDirectory.getPath());
        File currentSourcePath = null;
        try {
            GeneratorProxy generator = new GeneratorProxy();
            Iterator<File> iterator = this.getRamlFiles().iterator();
            while (iterator.hasNext()) {
                File ramlFile;
                currentSourcePath = ramlFile = iterator.next();
                BufferedReader reader = new BufferedReader(new FileReader(ramlFile));
                String line = reader.readLine();
                reader.close();
                if (line.startsWith("#%RAML")) {
                    this.getLog().info((CharSequence)("Generating Java classes from: " + ramlFile));
                    generator.run((InputStreamReader)new FileReader(ramlFile), configuration, ramlFile.getAbsolutePath());
                    continue;
                }
                this.getLog().info((CharSequence)(ramlFile + " does not seem to be RAML root file -skipped(first line should start from #%RAML ${raml version number}"));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error generating Java classes from: " + currentSourcePath, e);
        }
    }

    private Collection<File> getRamlFiles() throws MojoExecutionException {
        if (this.sourcePaths != null && this.sourcePaths.length > 0) {
            List<File> sourceFiles = Arrays.asList(this.sourcePaths);
            this.getLog().info((CharSequence)("Using RAML files: " + sourceFiles));
            return sourceFiles;
        }
        if (!this.sourceDirectory.isDirectory()) {
            throw new MojoExecutionException("The provided path doesn't refer to a valid directory: " + this.sourceDirectory);
        }
        this.getLog().info((CharSequence)("Looking for RAML files in and below: " + this.sourceDirectory));
        return FileUtils.listFiles((File)this.sourceDirectory, (String[])new String[]{"raml", "yaml"}, (boolean)true);
    }
}

