/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.codegen.spoon;

import com.mulesoft.jaxrs.raml.annotation.model.IAnnotationModel;
import com.mulesoft.jaxrs.raml.annotation.model.IFieldModel;
import com.mulesoft.jaxrs.raml.annotation.model.IMethodModel;
import com.mulesoft.jaxrs.raml.annotation.model.IParameterModel;
import com.mulesoft.jaxrs.raml.annotation.model.ITypeModel;
import com.mulesoft.jaxrs.raml.annotation.model.ITypeParameter;
import com.mulesoft.jaxrs.raml.annotation.model.reflection.AnnotationModel;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.raml.jaxrs.codegen.maven.ProxyType;
import org.raml.jaxrs.codegen.maven.TypeModelRegistry;
import org.raml.jaxrs.codegen.model.BasicModel;
import org.raml.jaxrs.codegen.model.FieldModel;
import org.raml.jaxrs.codegen.model.GenericElementModel;
import org.raml.jaxrs.codegen.model.MethodModel;
import org.raml.jaxrs.codegen.model.ParameterModel;
import org.raml.jaxrs.codegen.model.TypeModel;
import org.raml.jaxrs.codegen.model.TypeParameterModel;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtGenericElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.eval.PartialEvaluator;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpoonProcessor {
    private static final String API_OPERATION = "ApiOperation";
    private static final String SWAGGER_API = "Api";
    private static final String JAVAX_XML_TYPE = "XmlType";
    private static final String JAVAX_CONSUMES = "Consumes";
    private TypeModelRegistry registry = new TypeModelRegistry();
    private Factory factory;
    private static HashSet<String> primitives = new HashSet<String>(Arrays.asList("byte", "java.lang.Byte", "short", "java.lang.Short", "int", "java.lang.Integer", "long", "java.lang.Long", "float", "java.lang.Float", "double", "java.lang.Double", "character", "java.lang.Character", "boolean", "java.lang.Boolean"));

    public SpoonProcessor(Factory factory) {
        this.factory = factory;
    }

    public void process(Collection<CtPackage> packages) {
        if (packages == null) {
            return;
        }
        for (CtPackage package_ : packages) {
            this.processPackage(package_);
        }
        for (ITypeModel type : this.registry.getTypes()) {
            boolean hasGlobalConsumes = this.hasGlobalConsumes(type);
            for (IMethodModel method : type.getMethods()) {
                this.adjustReturnedAndBodyType(method, hasGlobalConsumes);
            }
        }
    }

    private boolean hasGlobalConsumes(ITypeModel type) {
        if (type.hasAnnotation(JAVAX_CONSUMES)) {
            return true;
        }
        IAnnotationModel apiAnn = type.getAnnotation(SWAGGER_API);
        if (apiAnn == null) {
            return false;
        }
        String consumes = apiAnn.getValue(JAVAX_CONSUMES.toLowerCase());
        return consumes != null;
    }

    private void adjustReturnedAndBodyType(IMethodModel method_, boolean hasGlobalConsumes) {
        IParameterModel[] parameters;
        IAnnotationModel consumes;
        IAnnotationModel[] subAnn;
        if (!(method_ instanceof MethodModel)) {
            return;
        }
        MethodModel method = (MethodModel)method_;
        ITypeModel returnedType = method.getReturnedType();
        if (returnedType != null && returnedType instanceof ProxyType) {
            ITypeModel rt = this.registry.getType(returnedType.getFullyQualifiedName());
            method.setReturnedType(rt);
        }
        boolean hasConsumes = hasGlobalConsumes;
        IAnnotationModel apiOperation = method.getAnnotation(API_OPERATION);
        if (apiOperation != null && (subAnn = apiOperation.getSubAnnotations(JAVAX_CONSUMES.toLowerCase())) != null) {
            hasConsumes = true;
        }
        if ((consumes = method.getAnnotation(JAVAX_CONSUMES)) != null) {
            hasConsumes = true;
        }
        if (!hasConsumes) {
            return;
        }
        for (IParameterModel param_ : parameters = method.getParameters()) {
            ITypeModel type;
            String paramType = param_.getParameterType();
            if (this.isPrimitive(paramType) || param_.hasAnnotation("QueryParam") || param_.hasAnnotation("HeaderParam") || param_.hasAnnotation("PathParam") || param_.hasAnnotation("FormParam") || param_.hasAnnotation("Context") || (type = this.registry.getType(paramType)) == null) continue;
            method.setBodyType(type);
            if (this.registry.isTargetType(paramType)) break;
        }
    }

    private boolean isPrimitive(String qName) {
        return primitives.contains(qName);
    }

    private void processPackage(CtPackage package_) {
        Set subPackages = package_.getPackages();
        if (subPackages != null) {
            for (CtPackage subPackage : subPackages) {
                this.processPackage(subPackage);
            }
        }
        for (CtType type : package_.getTypes()) {
            this.process(type);
        }
    }

    public void process(CtType<?> classElement) {
        ITypeModel type = this.processType(classElement);
        this.registry.registerTargetType(type);
    }

    private ITypeModel processType(CtType<?> classElement) {
        String qualifiedName = classElement.getQualifiedName();
        TypeModel type = (TypeModel)this.registry.getType(qualifiedName);
        if (type == null) {
            type = new TypeModel(this.registry);
            type.setFullyQualifiedName(qualifiedName);
        }
        this.registry.registerType(type);
        this.fillBasic(type, (CtNamedElement)classElement);
        this.fillTypeParameters(type, (CtGenericElement)classElement);
        if (classElement instanceof CtType) {
            Set interfaces;
            CtTypeReference superClass = classElement.getSuperclass();
            if (superClass != null) {
                ITypeModel superType = this.processTypeReference(superClass);
                type.setSuperClass(superType);
            }
            if ((interfaces = classElement.getSuperInterfaces()) != null) {
                ArrayList<ITypeModel> list = new ArrayList<ITypeModel>();
                for (CtTypeReference ref : interfaces) {
                    ITypeModel tm = this.processTypeReference(ref);
                    if (tm == null) continue;
                    list.add(tm);
                }
                type.setImplementedInterfaces(list.toArray(new ITypeModel[list.size()]));
            }
            Set methods = classElement.getMethods();
            for (CtMethod m : methods) {
                IMethodModel methodModel = this.processMethod(m, type);
                type.addMethod(methodModel);
            }
            List fields = classElement.getFields();
            for (CtField m : fields) {
                IFieldModel methodModel = this.processField(m, type);
                type.addField(methodModel);
            }
        }
        return type;
    }

    private void fillTypeParameters(GenericElementModel model, CtGenericElement element) {
        List ftp = element.getFormalTypeParameters();
        if (ftp == null || ftp.isEmpty()) {
            return;
        }
        for (CtTypeReference param : ftp) {
            String name = param.getSimpleName();
            TypeParameterModel paramModel = new TypeParameterModel();
            paramModel.setName(name);
            model.getTypeParameters().add(paramModel);
        }
    }

    private IAnnotationModel processAnnotation(CtAnnotation<? extends Annotation> annotation) {
        String simpleName = annotation.getActualAnnotation().annotationType().getSimpleName();
        String qualifiedName = annotation.getActualAnnotation().annotationType().getCanonicalName();
        org.raml.jaxrs.codegen.model.AnnotationModel annotationModel = new org.raml.jaxrs.codegen.model.AnnotationModel();
        annotationModel.setName(simpleName);
        annotationModel.setFullyQualifiedName(qualifiedName);
        Map elementValues = annotation.getElementValues();
        for (Map.Entry entry : elementValues.entrySet()) {
            String key = (String)entry.getKey();
            if (key == null) continue;
            Object value = entry.getValue();
            ArrayList<CtAnnotation<?>> annotationList = this.toCtAnnotationList(value);
            if (annotationList != null) {
                int size = annotationList.size();
                IAnnotationModel[] annotationModels = new IAnnotationModel[size];
                for (int i = 0; i < size; ++i) {
                    IAnnotationModel subAnnotationModel;
                    CtAnnotation<?> subAnnotation = annotationList.get(i);
                    annotationModels[i] = subAnnotationModel = this.processAnnotation(subAnnotation);
                }
                annotationModel.addValue(key, annotationModels);
                continue;
            }
            if (value instanceof String[]) {
                annotationModel.addValue(key, value);
                continue;
            }
            if (value instanceof CtNewArray) {
                List elements = ((CtNewArray)value).getElements();
                int size = elements.size();
                Object[] arr = new Object[size];
                for (int i = 0; i < size; ++i) {
                    Object elem = elements.get(i);
                    if (elem instanceof CtCodeElement) {
                        PartialEvaluator eval = this.factory.Eval().createPartialEvaluator();
                        arr[i] = eval.evaluate(null, (CtCodeElement)elem);
                        continue;
                    }
                    arr[i] = elem;
                }
                value = arr;
            }
            if (value instanceof CtCodeElement) {
                PartialEvaluator eval = this.factory.Eval().createPartialEvaluator();
                value = eval.evaluate(null, (CtCodeElement)value);
            }
            if (value instanceof CtLiteral) {
                value = ((CtLiteral)value).getValue().toString();
            } else if (value instanceof CtFieldReference) {
                Member member = ((CtFieldReference)value).getActualField();
                if (member instanceof Field) {
                    Field field = (Field)member;
                    int mod = field.getModifiers();
                    if (Modifier.isStatic(mod) && Modifier.isFinal(mod)) {
                        field.setAccessible(true);
                        try {
                            value = field.get(null).toString();
                        }
                        catch (Throwable t) {
                            value = member.getName();
                        }
                    } else {
                        value = member.getName();
                    }
                }
            } else if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                String[] arr = new String[length];
                for (int i = 0; i < length; ++i) {
                    Object elem = Array.get(value, i);
                    String sVal = elem.toString();
                    if (elem instanceof CtLiteral) {
                        sVal = ((CtLiteral)elem).getValue().toString();
                    } else if (elem instanceof CtFieldReference) {
                        sVal = ((CtFieldReference)elem).getActualField().getName();
                    }
                    arr[i] = sVal;
                }
                value = arr;
            } else {
                value = value.toString();
            }
            if (value == null) {
                value = "null";
            }
            annotationModel.addValue(key, value);
        }
        return annotationModel;
    }

    private ArrayList<CtAnnotation<?>> toCtAnnotationList(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof CtNewArray) {
            value = ((CtNewArray)value).getElements();
        }
        ArrayList list = new ArrayList();
        if (value instanceof CtAnnotation) {
            list.add((CtAnnotation)value);
        } else if (value.getClass().isArray()) {
            Class<?> componentType = value.getClass().getComponentType();
            if (this.checkIfCtAnnotation(componentType)) {
                int l = Array.getLength(value);
                for (int i = 0; i < l; ++i) {
                    CtAnnotation subAnnotation = (CtAnnotation)Array.get(value, i);
                    list.add(subAnnotation);
                }
            }
        } else if (value instanceof Collection) {
            Collection col = (Collection)value;
            for (Object member : col) {
                if (!(member instanceof CtAnnotation)) continue;
                list.add((CtAnnotation)member);
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    private boolean checkIfCtAnnotation(Class<?> componentType) {
        for (Class<?> clazz = componentType; clazz != null; clazz = clazz.getSuperclass()) {
            Class<?>[] interfaces;
            for (Class<?> iClass : interfaces = clazz.getInterfaces()) {
                if (!iClass.equals(CtAnnotation.class)) continue;
                return true;
            }
        }
        return false;
    }

    private IAnnotationModel processJavaLangAnnotation(Annotation annotation) {
        return new AnnotationModel(annotation);
    }

    private IMethodModel processMethod(CtMethod<?> m, TypeModel ownerType) {
        String returnedTypeQualifiedname;
        MethodModel methodModel = new MethodModel();
        this.fillBasic(methodModel, (CtNamedElement)m);
        this.fillTypeParameters(methodModel, (CtGenericElement)m);
        CtTypeReference returnedType = m.getType();
        ITypeModel returnedTypeModel = this.processTypeReference(returnedType);
        methodModel.setReturnedType(returnedTypeModel);
        this.fillJAXBType(methodModel, returnedType);
        List parameters = m.getParameters();
        for (CtParameter p : parameters) {
            IParameterModel parameterModel = this.processParameter(p);
            methodModel.addParameter(parameterModel);
        }
        String returnedTypeSimpleName = returnedType.getSimpleName();
        if (returnedTypeSimpleName.equalsIgnoreCase(returnedTypeQualifiedname = returnedType.getQualifiedName())) {
            for (ITypeParameter tp : ownerType.getTypeParameters()) {
                if (!returnedType.getSimpleName().equals(tp.getName())) continue;
                methodModel.setHasGenericReturnType(true);
            }
            for (ITypeParameter tp : methodModel.getTypeParameters()) {
                if (!returnedType.getSimpleName().equals(tp.getName())) continue;
                methodModel.setHasGenericReturnType(true);
            }
        }
        return methodModel;
    }

    private IParameterModel processParameter(CtParameter<?> paramElement) {
        ParameterModel parameterModel = new ParameterModel();
        CtTypeReference paramType = paramElement.getType();
        String qualifiedName = paramType.getQualifiedName();
        parameterModel.setType(qualifiedName);
        parameterModel.setRequired(paramType.isPrimitive());
        this.fillBasic(parameterModel, (CtNamedElement)paramElement);
        this.fillJAXBType(parameterModel, paramType);
        this.processTypeReference(paramType);
        return parameterModel;
    }

    private void fillBasic(BasicModel model, CtNamedElement namedElement) {
        String simpleName = namedElement.getSimpleName();
        String docComment = namedElement.getDocComment();
        model.setName(simpleName);
        model.setDocumentation(docComment);
        if (namedElement instanceof CtModifiable) {
            CtModifiable ctModifiable = (CtModifiable)namedElement;
            Set modifiers = ctModifiable.getModifiers();
            for (ModifierKind mod : modifiers) {
                if (mod == ModifierKind.STATIC) {
                    model.setStatic(true);
                }
                if (mod != ModifierKind.PUBLIC) continue;
                model.setPublic(true);
            }
        }
        List annotations = namedElement.getAnnotations();
        for (CtAnnotation a : annotations) {
            IAnnotationModel annotationModel = this.processAnnotation((CtAnnotation<? extends Annotation>)a);
            model.addAnnotation(annotationModel);
        }
    }

    private ITypeModel processTypeReference(CtTypeReference<?> typeReference) {
        String qualifiedName = typeReference.getQualifiedName();
        ITypeModel existingType = this.registry.getType(qualifiedName);
        if (existingType != null) {
            return new ProxyType(this.registry, qualifiedName);
        }
        CtClass ctClass = this.factory.Class().get(qualifiedName);
        if (ctClass != null) {
            return this.processType((CtType<?>)ctClass);
        }
        CtType ctType = this.factory.Type().get(qualifiedName);
        if (ctType != null) {
            return this.processType(ctType);
        }
        TypeModel type = new TypeModel(this.registry);
        type.setFullyQualifiedName(qualifiedName);
        this.registry.registerType(type);
        this.fillReference(type, (CtReference)typeReference);
        Collection methods = typeReference.getDeclaredExecutables();
        for (CtExecutableReference m : methods) {
            IMethodModel methodModel = this.processMethodReference(m);
            type.addMethod(methodModel);
        }
        Collection fields = typeReference.getDeclaredFields();
        for (CtFieldReference m : fields) {
            IFieldModel methodModel = this.processFieldReference(m);
            type.addField(methodModel);
        }
        return new ProxyType(this.registry, qualifiedName);
    }

    private IFieldModel processFieldReference(CtFieldReference<?> m) {
        FieldModel fm = new FieldModel();
        this.fillReference(fm, (CtReference)m);
        Member actualField = m.getActualField();
        if (actualField != null) {
            this.adjustModifiers(fm, actualField);
        }
        return fm;
    }

    private IFieldModel processField(CtField<?> m, TypeModel ownerType) {
        FieldModel fm = new FieldModel();
        this.fillBasic(fm, (CtNamedElement)m);
        if (m.getType() != null) {
            CtTypeReference type = m.getType();
            this.fillJAXBType(fm, type);
            String typeSimpleName = type.getSimpleName();
            String typeQualifiedName = type.getQualifiedName();
            if (typeSimpleName.equalsIgnoreCase(typeQualifiedName)) {
                for (ITypeParameter tp : ownerType.getTypeParameters()) {
                    if (!typeSimpleName.equals(tp.getName())) continue;
                    fm.setGeneric(true);
                }
            }
        }
        return fm;
    }

    private void fillJAXBType(BasicModel fm, CtTypeReference<?> type) {
        List actualTypeArguments;
        if (type == null) {
            return;
        }
        List<Object> actualTypes = new ArrayList<Object>();
        Class actualClass = type.getActualClass();
        fm.setJavaClass(actualClass);
        if (actualClass != null && Collection.class.isAssignableFrom(actualClass)) {
            fm.setCollection(true);
            actualTypeArguments = type.getActualTypeArguments();
            if (actualTypeArguments.size() > 0) {
                actualTypes.add(actualTypeArguments.get(0));
            }
        } else if (actualClass != null && Map.class.isAssignableFrom(actualClass)) {
            fm.setMap(true);
            actualTypeArguments = type.getActualTypeArguments();
            if (actualTypeArguments.size() == 2) {
                actualTypes = actualTypeArguments;
            }
        } else {
            actualTypes.add(type);
        }
        for (CtTypeReference ctTypeReference : actualTypes) {
            ITypeModel processTypeReference = this.processTypeReference(ctTypeReference);
            fm.addJaxbType(processTypeReference);
        }
    }

    private IMethodModel processMethodReference(CtExecutableReference<?> methodElement) {
        MethodModel methodModel = new MethodModel();
        this.fillReference(methodModel, (CtReference)methodElement);
        List parameters = methodElement.getParameters();
        Method actualMethod = methodElement.getActualMethod();
        if (actualMethod != null) {
            String canonicalName = actualMethod.getReturnType().getCanonicalName();
            ITypeModel existingType = this.registry.getType(canonicalName);
            if (existingType != null) {
                methodModel.setReturnedType(existingType);
            }
            if (existingType != null) {
                methodModel.setReturnedType(new ProxyType(this.registry, canonicalName));
            }
            this.adjustModifiers(methodModel, actualMethod);
        }
        for (CtTypeReference p : parameters) {
            IParameterModel parameterModel = this.processParameterReference(p);
            methodModel.addParameter(parameterModel);
        }
        return methodModel;
    }

    private void adjustModifiers(BasicModel model, Member member) {
        int modifiers = member.getModifiers();
        if (Modifier.isPublic(modifiers)) {
            model.setPublic(true);
        }
        if (Modifier.isStatic(modifiers)) {
            model.setStatic(true);
        }
    }

    private IParameterModel processParameterReference(CtTypeReference<?> paramTypeReference) {
        ParameterModel parameterModel = new ParameterModel();
        parameterModel.setType(paramTypeReference.getQualifiedName());
        parameterModel.setName(paramTypeReference.getSimpleName());
        parameterModel.setRequired(paramTypeReference.isPrimitive());
        List annotations = paramTypeReference.getAnnotations();
        for (Annotation a : annotations) {
            IAnnotationModel annotationModel = this.processJavaLangAnnotation(a);
            parameterModel.addAnnotation(annotationModel);
        }
        return parameterModel;
    }

    private void fillReference(BasicModel model, CtReference ref) {
        String simpleName = ref.getSimpleName();
        model.setName(simpleName);
        List annotations = null;
        try {
            annotations = ref.getAnnotations();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (annotations != null) {
            for (Annotation a : annotations) {
                IAnnotationModel annotationModel = this.processJavaLangAnnotation(a);
                model.addAnnotation(annotationModel);
            }
        }
    }

    public TypeModelRegistry getRegistry() {
        return this.registry;
    }
}

