/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.codegen.model;

import com.mulesoft.jaxrs.raml.annotation.model.IFieldModel;
import com.mulesoft.jaxrs.raml.annotation.model.IMethodModel;
import com.mulesoft.jaxrs.raml.annotation.model.ITypeModel;
import java.util.LinkedHashMap;
import org.raml.jaxrs.codegen.maven.TypeModelRegistry;
import org.raml.jaxrs.codegen.model.GenericElementModel;

public class TypeModel
extends GenericElementModel
implements ITypeModel {
    private String qualifiedName;
    private LinkedHashMap<String, IMethodModel> methods = new LinkedHashMap();
    private LinkedHashMap<String, IFieldModel> fields = new LinkedHashMap();
    private ITypeModel superClass;
    private ITypeModel[] implementedIntefaces;
    private TypeModelRegistry registry;

    public TypeModel(TypeModelRegistry registry) {
        this.registry = registry;
    }

    public IMethodModel[] getMethods() {
        return this.methods.values().toArray(new IMethodModel[this.methods.size()]);
    }

    public void addMethod(IMethodModel method) {
        this.methods.put(method.getName(), method);
    }

    public String getFullyQualifiedName() {
        return this.qualifiedName;
    }

    public void setFullyQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.methods == null ? 0 : this.methods.hashCode());
        result = 31 * result + (this.qualifiedName == null ? 0 : this.qualifiedName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeModel other = (TypeModel)obj;
        if (this.methods == null ? other.methods != null : !this.methods.equals(other.methods)) {
            return false;
        }
        return !(this.qualifiedName == null ? other.qualifiedName != null : !this.qualifiedName.equals(other.qualifiedName));
    }

    public IFieldModel[] getFields() {
        return this.fields.values().toArray(new IFieldModel[this.fields.size()]);
    }

    public void addField(IFieldModel fieldModel) {
        this.fields.put(fieldModel.getName(), fieldModel);
    }

    public ITypeModel getSuperClass() {
        return this.superClass;
    }

    public ITypeModel[] getImplementedInterfaces() {
        return this.implementedIntefaces;
    }

    public void setSuperClass(ITypeModel superClass) {
        this.superClass = superClass;
    }

    public void setImplementedInterfaces(ITypeModel[] implementedIntefaces) {
        this.implementedIntefaces = implementedIntefaces;
    }

    public ITypeModel resolveClass(String qualifiedName) {
        ITypeModel result = this.registry.getType(qualifiedName);
        if (result == null) {
            return null;
        }
        return result;
    }
}

