/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.codegen.model;

import com.mulesoft.jaxrs.raml.annotation.model.IDocInfo;
import com.mulesoft.jaxrs.raml.annotation.model.IMethodModel;
import com.mulesoft.jaxrs.raml.annotation.model.IParameterModel;
import com.mulesoft.jaxrs.raml.annotation.model.ITypeModel;
import com.mulesoft.jaxrs.raml.annotation.model.reflection.Utils;
import java.util.ArrayList;
import org.raml.jaxrs.codegen.model.GenericElementModel;

public class MethodModel
extends GenericElementModel
implements IMethodModel {
    private ArrayList<IParameterModel> parameters = new ArrayList();
    private ITypeModel returnedType;
    private ITypeModel bodyType;
    protected boolean hasGenericReturnType;
    protected boolean hasGenericBodyType;

    public IParameterModel[] getParameters() {
        return this.parameters.toArray(new IParameterModel[this.parameters.size()]);
    }

    public void addParameter(IParameterModel param) {
        this.parameters.add(param);
    }

    public IDocInfo getBasicDocInfo() {
        return new IDocInfo(){

            public String getReturnInfo() {
                return Utils.extractReturnJavadoc((String)MethodModel.this.getDocumentation());
            }

            public String getDocumentation(String pName) {
                return Utils.extractParamJavadoc((String)MethodModel.this.getDocumentation(), (String)pName);
            }

            public String getDocumentation() {
                return Utils.extractMethodJavadoc((String)MethodModel.this.getDocumentation());
            }
        };
    }

    public ITypeModel getReturnedType() {
        return this.returnedType;
    }

    public void setReturnedType(ITypeModel returnType) {
        this.returnedType = returnType;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        if (this.parameters != null && !this.parameters.isEmpty()) {
            for (IParameterModel param : this.parameters) {
                result = 31 * result + param.getParameterType().hashCode();
                result = 31 * result + param.getName().hashCode();
            }
        }
        if (this.returnedType != null) {
            result = 31 * result + this.returnedType.getFullyQualifiedName().hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodModel other = (MethodModel)obj;
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        return !(this.returnedType == null ? other.returnedType != null : !this.returnedType.equals(other.returnedType));
    }

    public ITypeModel getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(ITypeModel bodyType) {
        this.bodyType = bodyType;
    }

    public boolean hasGenericReturnType() {
        return this.hasGenericReturnType;
    }

    public void setHasGenericReturnType(boolean isGeneric) {
        this.hasGenericReturnType = isGeneric;
    }

    public boolean hasGenericBodyType() {
        return this.hasGenericReturnType;
    }

    public void setHasGenericBodyType(boolean isGeneric) {
        this.hasGenericReturnType = isGeneric;
    }
}

