/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.codegen.model;

import com.mulesoft.jaxrs.raml.annotation.model.IAnnotationModel;
import com.mulesoft.jaxrs.raml.annotation.model.IBasicModel;
import com.mulesoft.jaxrs.raml.annotation.model.ITypeModel;
import com.mulesoft.jaxrs.raml.annotation.model.reflection.ReflectionType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicModel
implements IBasicModel {
    private static final String VALUE_METHOD_ID = "value";
    private LinkedHashMap<String, IAnnotationModel> annotations = new LinkedHashMap();
    private LinkedHashMap<String, IAnnotationModel> annotationsByCanonicalName = new LinkedHashMap();
    private String simpleName;
    private String documentation;
    private boolean publicM;
    private boolean staticM;
    private Class<?> actualClass;
    private List<ITypeModel> jaxbTypes;
    private boolean isCollection;
    private boolean isMap;

    public List<ITypeModel> getJAXBTypes() {
        return this.jaxbTypes;
    }

    public Class<?> getJavaType() {
        return this.actualClass;
    }

    public ITypeModel getType() {
        return new ReflectionType(this.actualClass);
    }

    public boolean isStatic() {
        return this.staticM;
    }

    public boolean isPublic() {
        return this.publicM;
    }

    public String getName() {
        return this.simpleName;
    }

    public void setName(String simpleName) {
        this.simpleName = simpleName;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public IAnnotationModel[] getAnnotations() {
        return this.annotations.values().toArray(new IAnnotationModel[this.annotations.size()]);
    }

    public void addAnnotation(IAnnotationModel annotation) {
        this.annotations.put(annotation.getName(), annotation);
        this.annotationsByCanonicalName.put(annotation.getCanonicalName(), annotation);
    }

    public String getAnnotationValue(String annotation) {
        IAnnotationModel annotationModel = this.annotations.get(annotation);
        if (annotationModel == null) {
            return null;
        }
        return annotationModel.getValue(VALUE_METHOD_ID);
    }

    public String[] getAnnotationValues(String annotation) {
        IAnnotationModel annotationModel = this.annotations.get(annotation);
        if (annotationModel == null) {
            return null;
        }
        return annotationModel.getValues(VALUE_METHOD_ID);
    }

    public boolean hasAnnotation(String annotationName) {
        return this.annotations.containsKey(annotationName);
    }

    public IAnnotationModel getAnnotation(String name) {
        return this.annotations.get(name);
    }

    public boolean hasAnnotationWithCanonicalName(String annotationName) {
        return this.annotationsByCanonicalName.containsKey(annotationName);
    }

    public IAnnotationModel getAnnotationByCanonicalName(String name) {
        return this.annotationsByCanonicalName.get(name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotations == null ? 0 : this.annotations.hashCode());
        result = 31 * result + (this.documentation == null ? 0 : this.documentation.hashCode());
        result = 31 * result + (this.simpleName == null ? 0 : this.simpleName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicModel other = (BasicModel)obj;
        if (this.annotations == null ? other.annotations != null : !this.annotations.equals(other.annotations)) {
            return false;
        }
        if (this.documentation == null ? other.documentation != null : !this.documentation.equals(other.documentation)) {
            return false;
        }
        return !(this.simpleName == null ? other.simpleName != null : !this.simpleName.equals(other.simpleName));
    }

    public void setStatic(boolean b) {
        this.staticM = true;
    }

    public void setPublic(boolean b) {
        this.publicM = true;
    }

    public void setJavaClass(Class<?> actualClass) {
        this.actualClass = actualClass;
    }

    public void addJaxbType(ITypeModel processTypeReference) {
        if (this.jaxbTypes == null) {
            this.jaxbTypes = new ArrayList<ITypeModel>();
        }
        this.jaxbTypes.add(processTypeReference);
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public void setCollection(boolean isCollection) {
        this.isCollection = isCollection;
    }

    public boolean isMap() {
        return this.isMap;
    }

    public void setMap(boolean isMap) {
        this.isMap = isMap;
    }
}

