/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.codegen.maven;

import com.mulesoft.jaxrs.raml.annotation.model.IRamlConfig;
import com.mulesoft.jaxrs.raml.annotation.model.IResourceVisitorExtension;
import com.mulesoft.jaxrs.raml.annotation.model.ITypeModel;
import com.mulesoft.jaxrs.raml.annotation.model.reflection.RuntimeResourceVisitor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.raml.jaxrs.codegen.maven.MavenRamlConfig;
import org.raml.jaxrs.codegen.spoon.SpoonProcessor;
import spoon.Launcher;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.PackageFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="generate-raml", requiresProject=true, threadSafe=false, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class JaxrsRamlCodegenMojo
extends AbstractMojo {
    private static final String DEFAULT_RAML_FILENAME = "api.raml";
    private static final String RAML_EXTENSION = ".raml";
    private static final String pathSeparator = System.getProperty("path.separator");
    @Parameter(property="sourceDirectory", defaultValue="${basedir}/src/main/java")
    private File sourceDirectory;
    @Parameter(property="sourcePaths")
    private File[] sourcePaths;
    @Parameter(property="outputFile", defaultValue="${project.build.directory}/generated-sources/jaxrs-raml/api.raml")
    private File outputFile;
    private File outputDirectory;
    @Parameter(property="removeOldOutput", defaultValue="false")
    private boolean removeOldOutput;
    @Parameter(property="title", defaultValue="${project.artifactId}")
    private String title;
    @Parameter(property="baseUrl")
    private String baseUrl;
    @Parameter(property="version")
    private String version;
    @Component
    private MavenProject project;
    @Parameter(property="extensions")
    private List<String> extensions;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkAndPrepareDirectories();
        String[] args = this.prepareArguments();
        Launcher launcher = null;
        try {
            launcher = new Launcher();
            launcher.setArgs(args);
            launcher.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (launcher == null) {
            return;
        }
        Factory factory = launcher.getFactory();
        PackageFactory packageFactory = factory.Package();
        Collection allRoots = packageFactory.getAllRoots();
        SpoonProcessor spoonProcessor = new SpoonProcessor(factory);
        spoonProcessor.process(allRoots);
        ClassLoader classLoader = launcher.getFactory().getEnvironment().getClassLoader();
        MavenRamlConfig config = new MavenRamlConfig(this.title, this.baseUrl, this.version);
        if (this.extensions != null) {
            for (String className : this.extensions) {
                try {
                    Class<?> c = Class.forName(className);
                    if (c == null) {
                        throw new MojoExecutionException("generatorExtensionClass " + className + " cannot be loaded." + "Have you installed the correct dependency in the plugin configuration?");
                    }
                    if (!(c.newInstance() instanceof IResourceVisitorExtension)) {
                        throw new MojoExecutionException("generatorExtensionClass " + className + " does not implement" + IResourceVisitorExtension.class.getCanonicalName());
                    }
                    config.getExtensions().add((IResourceVisitorExtension)c.newInstance());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        RuntimeResourceVisitor rv = new RuntimeResourceVisitor(this.outputFile, classLoader, (IRamlConfig)config);
        for (ITypeModel type : spoonProcessor.getRegistry().getTargetTypes()) {
            rv.visit(type);
        }
        this.saveRaml(rv.getRaml(), allRoots);
    }

    private void saveRaml(String raml, Collection<CtPackage> allRoots) {
        if (this.outputFile.isDirectory()) {
            String defaultFileName = DEFAULT_RAML_FILENAME;
            for (CtPackage pkg : allRoots) {
                Iterator iterator = pkg.getTypes().iterator();
                if (!iterator.hasNext()) continue;
                CtType type = (CtType)iterator.next();
                defaultFileName = type.getSimpleName() + RAML_EXTENSION;
                break;
            }
            this.outputFile = new File(this.outputFile, defaultFileName);
        } else if (!this.outputFile.getName().toLowerCase().endsWith(RAML_EXTENSION)) {
            this.outputFile = new File(this.outputFile.getAbsolutePath() + RAML_EXTENSION);
        }
        try {
            if (!this.outputFile.exists()) {
                this.outputFile.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.outputFile);
            fileOutputStream.write(raml.getBytes("UTF-8"));
            fileOutputStream.close();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void checkAndPrepareDirectories() throws MojoExecutionException {
        if (this.outputFile == null || this.outputFile.getAbsolutePath().isEmpty()) {
            throw new MojoExecutionException("The outputDirectory must not be empty.");
        }
        this.outputDirectory = this.outputFile.isDirectory() ? this.outputFile : this.outputFile.getParentFile();
        this.outputDirectory.mkdirs();
        if (this.removeOldOutput) {
            try {
                FileUtils.cleanDirectory((File)this.outputDirectory);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Failed to clean directory: " + this.outputFile, (Exception)ioe);
            }
        }
    }

    private String[] prepareArguments() throws MojoExecutionException {
        ArrayList<String> lst = new ArrayList<String>();
        String inputValue = this.getInputValue();
        if (this.isEmptyString(inputValue)) {
            throw new MojoExecutionException("One of sourceDirectory or sourcePaths parameters must not be empty.");
        }
        lst.add("--input");
        lst.add(inputValue);
        lst.add("--output-type");
        lst.add("nooutput");
        String sourceClasspath = this.getSourceClassPath();
        if (!this.isEmptyString(sourceClasspath)) {
            lst.add("--source-classpath");
            lst.add(sourceClasspath);
        }
        String[] arr = lst.toArray(new String[lst.size()]);
        return arr;
    }

    private String getInputValue() {
        if (this.sourcePaths != null && this.sourcePaths.length != 0) {
            StringBuilder bld = new StringBuilder();
            for (File f : this.sourcePaths) {
                bld.append(f.getAbsolutePath()).append(pathSeparator);
            }
            String result = bld.substring(0, bld.length() - pathSeparator.length());
            return result;
        }
        String result = this.sourceDirectory.getAbsolutePath();
        return result;
    }

    private String getSourceClassPath() {
        StringBuilder bld = new StringBuilder();
        List compileClasspathElements = null;
        try {
            compileClasspathElements = this.project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e1) {
            e1.printStackTrace();
        }
        if (compileClasspathElements == null || compileClasspathElements.isEmpty()) {
            return null;
        }
        for (Object obj : compileClasspathElements) {
            bld.append(obj.toString());
            bld.append(pathSeparator);
        }
        String result = bld.substring(0, bld.length() - pathSeparator.length());
        return result;
    }

    private boolean isEmptyString(String str) {
        return str == null || str.trim().length() == 0;
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public File[] getSourcePaths() {
        return this.sourcePaths;
    }

    public void setSourcePaths(File[] sourcePaths) {
        this.sourcePaths = sourcePaths;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public boolean isRemoveOldOutput() {
        return this.removeOldOutput;
    }

    public void setRemoveOldOutput(boolean removeOldOutput) {
        this.removeOldOutput = removeOldOutput;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }
}

