/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.codegen.spoon;

import com.mulesoft.jaxrs.raml.annotation.model.IAnnotationModel;
import com.mulesoft.jaxrs.raml.annotation.model.IMethodModel;
import com.mulesoft.jaxrs.raml.annotation.model.IParameterModel;
import com.mulesoft.jaxrs.raml.annotation.model.ITypeModel;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.raml.jaxrs.codegen.maven.ProxyType;
import org.raml.jaxrs.codegen.maven.TypeModelRegistry;
import org.raml.jaxrs.codegen.model.AnnotationModel;
import org.raml.jaxrs.codegen.model.BasicModel;
import org.raml.jaxrs.codegen.model.MethodModel;
import org.raml.jaxrs.codegen.model.ParameterModel;
import org.raml.jaxrs.codegen.model.TypeModel;
import spoon.reflect.code.CtCodeElement;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtSimpleType;
import spoon.reflect.declaration.CtType;
import spoon.reflect.eval.PartialEvaluator;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;

public class SpoonProcessor {
    private static final String JAVAX_XML_TYPE = "XmlType";
    private static final String JAVAX_CONSUMES = "Consumes";
    private TypeModelRegistry registry = new TypeModelRegistry();
    private Factory factory;

    public SpoonProcessor(Factory factory) {
        this.factory = factory;
    }

    public void process(Collection<CtPackage> packages) {
        if (packages == null) {
            return;
        }
        for (CtPackage package_ : packages) {
            this.processPackage(package_);
        }
        for (ITypeModel type : this.registry.getTypes()) {
            IMethodModel[] iMethodModelArray = type.getMethods();
            int n = iMethodModelArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodModel method = iMethodModelArray[n2];
                this.adjustReturnedAndBodyType(method);
                ++n2;
            }
        }
    }

    private void adjustReturnedAndBodyType(IMethodModel method_) {
        IParameterModel[] parameters;
        IAnnotationModel consumes;
        if (!(method_ instanceof MethodModel)) {
            return;
        }
        MethodModel method = (MethodModel)method_;
        ITypeModel returnedType = method.getReturnedType();
        if (returnedType != null && returnedType instanceof ProxyType) {
            ITypeModel rt = this.registry.getType(returnedType.getFullyQualifiedName());
            method.setReturnedType(rt);
        }
        if ((consumes = method.getAnnotation(JAVAX_CONSUMES)) == null) {
            return;
        }
        IParameterModel[] iParameterModelArray = parameters = method.getParameters();
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotationModel typeAnnotation;
            ITypeModel type;
            IParameterModel param_ = iParameterModelArray[n2];
            String paramType = param_.getType();
            if (!paramType.startsWith("java.") && (type = this.registry.getType(paramType)) != null && (typeAnnotation = type.getAnnotation(JAVAX_XML_TYPE)) != null) {
                method.setBodyType(type);
                if (this.registry.isTargetType(paramType)) break;
            }
            ++n2;
        }
    }

    private void processPackage(CtPackage package_) {
        Set subPackages = package_.getPackages();
        if (subPackages != null) {
            for (CtPackage subPackage : subPackages) {
                this.processPackage(subPackage);
            }
        }
        for (CtSimpleType type : package_.getTypes()) {
            this.process(type);
        }
    }

    public void process(CtSimpleType<?> classElement) {
        ITypeModel type = this.processType(classElement);
        this.registry.registerTargetType(type);
    }

    private ITypeModel processType(CtSimpleType<?> classElement) {
        TypeModel type = new TypeModel();
        String qualifiedName = classElement.getQualifiedName();
        type.setFullyQualifiedName(qualifiedName);
        this.registry.registerType(type);
        this.fillBasic(type, (CtNamedElement)classElement);
        if (classElement instanceof CtType) {
            Set methods = ((CtType)classElement).getMethods();
            for (CtMethod m : methods) {
                IMethodModel methodModel = this.processMethod(m);
                type.addMethod(methodModel);
            }
        }
        return type;
    }

    private IAnnotationModel processAnnotation(CtAnnotation<? extends Annotation> annotation) {
        String simpleName = annotation.getActualAnnotation().annotationType().getSimpleName();
        AnnotationModel annotationModel = new AnnotationModel();
        annotationModel.setName(simpleName);
        Map elementValues = annotation.getElementValues();
        for (Map.Entry entry : elementValues.entrySet()) {
            String key = (String)entry.getKey();
            if (key == null) continue;
            Object value = entry.getValue();
            ArrayList<CtAnnotation<?>> annotationList = this.toCtAnnotationList(value);
            if (annotationList != null) {
                int size = annotationList.size();
                IAnnotationModel[] annotationModels = new IAnnotationModel[size];
                int i = 0;
                while (i < size) {
                    IAnnotationModel subAnnotationModel;
                    CtAnnotation<?> subAnnotation = annotationList.get(i);
                    annotationModels[i] = subAnnotationModel = this.processAnnotation(subAnnotation);
                    ++i;
                }
                annotationModel.addValue(key, annotationModels);
                continue;
            }
            if (value instanceof String[]) {
                annotationModel.addValue(key, value);
                continue;
            }
            if (value instanceof CtNewArray) {
                List elements = ((CtNewArray)value).getElements();
                int size = elements.size();
                Object[] arr = new Object[size];
                int i = 0;
                while (i < size) {
                    Object elem = elements.get(i);
                    if (elem instanceof CtCodeElement) {
                        PartialEvaluator eval = this.factory.Eval().createPartialEvaluator();
                        arr[i] = eval.evaluate(null, (CtCodeElement)elem);
                    } else {
                        arr[i] = elem;
                    }
                    ++i;
                }
                value = arr;
            }
            if (value instanceof CtCodeElement) {
                PartialEvaluator eval = this.factory.Eval().createPartialEvaluator();
                value = eval.evaluate(null, (CtCodeElement)value);
            }
            if (value instanceof CtLiteral) {
                value = ((CtLiteral)value).getValue().toString();
            } else if (value instanceof CtFieldReference) {
                Field field;
                int mod;
                Member member = ((CtFieldReference)value).getActualField();
                if (member instanceof Field && Modifier.isStatic(mod = (field = (Field)member).getModifiers()) && Modifier.isFinal(mod) && field.getType().equals(String.class)) {
                    try {
                        value = field.get(null);
                    }
                    catch (Throwable i) {
                        // empty catch block
                    }
                }
                if (value == null) {
                    value = member.getName();
                }
            } else if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                String[] arr = new String[length];
                int i = 0;
                while (i < length) {
                    Object elem = Array.get(value, i);
                    String sVal = elem.toString();
                    if (elem instanceof CtLiteral) {
                        sVal = ((CtLiteral)elem).getValue().toString();
                    } else if (elem instanceof CtFieldReference) {
                        sVal = ((CtFieldReference)elem).getActualField().getName();
                    }
                    arr[i] = sVal;
                    ++i;
                }
                value = arr;
            } else {
                value = value.toString();
            }
            if (value == null) {
                value = "null";
            }
            annotationModel.addValue(key, value);
        }
        return annotationModel;
    }

    private ArrayList<CtAnnotation<?>> toCtAnnotationList(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof CtNewArray) {
            value = ((CtNewArray)value).getElements();
        }
        ArrayList list = new ArrayList();
        if (value instanceof CtAnnotation) {
            list.add((CtAnnotation)value);
        } else if (value.getClass().isArray()) {
            Class<?> componentType = value.getClass().getComponentType();
            if (this.checkIfCtAnnotation(componentType)) {
                int l = Array.getLength(value);
                int i = 0;
                while (i < l) {
                    CtAnnotation subAnnotation = (CtAnnotation)Array.get(value, i);
                    list.add(subAnnotation);
                    ++i;
                }
            }
        } else if (value instanceof Collection) {
            Collection col = (Collection)value;
            for (Object member : col) {
                if (!(member instanceof CtAnnotation)) continue;
                list.add((CtAnnotation)member);
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    private boolean checkIfCtAnnotation(Class<?> componentType) {
        Class<?> clazz = componentType;
        while (clazz != null) {
            Class<?>[] interfaces;
            Class<?>[] classArray = interfaces = clazz.getInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> iClass = classArray[n2];
                if (iClass.equals(CtAnnotation.class)) {
                    return true;
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    private IAnnotationModel processJavaLangAnnotation(Annotation annotation) {
        return new com.mulesoft.jaxrs.raml.annotation.model.reflection.AnnotationModel(annotation);
    }

    private IMethodModel processMethod(CtMethod<?> m) {
        MethodModel methodModel = new MethodModel();
        this.fillBasic(methodModel, (CtNamedElement)m);
        CtTypeReference returnedType = m.getType();
        ITypeModel returnedTypeModel = this.processTypeReference(returnedType);
        methodModel.setReturnedType(returnedTypeModel);
        List parameters = m.getParameters();
        for (CtParameter p : parameters) {
            IParameterModel parameterModel = this.processParameter(p);
            methodModel.addParameter(parameterModel);
        }
        return methodModel;
    }

    private IParameterModel processParameter(CtParameter<?> paramElement) {
        ParameterModel parameterModel = new ParameterModel();
        CtTypeReference paramType = paramElement.getType();
        String qualifiedName = paramType.getQualifiedName();
        parameterModel.setType(qualifiedName);
        parameterModel.setRequired(paramType.isPrimitive());
        this.fillBasic(parameterModel, (CtNamedElement)paramElement);
        return parameterModel;
    }

    private void fillBasic(BasicModel model, CtNamedElement namedElement) {
        String simpleName = namedElement.getSimpleName();
        String docComment = namedElement.getDocComment();
        model.setName(simpleName);
        model.setDocumentation(docComment);
        List annotations = namedElement.getAnnotations();
        for (CtAnnotation a : annotations) {
            IAnnotationModel annotationModel = this.processAnnotation((CtAnnotation<? extends Annotation>)a);
            model.addAnnotation(annotationModel);
        }
    }

    private ITypeModel processTypeReference(CtTypeReference<?> typeReference) {
        String qualifiedName = typeReference.getQualifiedName();
        ITypeModel existingType = this.registry.getType(qualifiedName);
        if (existingType != null) {
            return new ProxyType(this.registry, qualifiedName);
        }
        CtClass ctType = this.factory.Class().get(qualifiedName);
        if (ctType != null) {
            return this.processType((CtSimpleType<?>)ctType);
        }
        TypeModel type = new TypeModel();
        type.setFullyQualifiedName(qualifiedName);
        this.registry.registerType(type);
        this.fillReference(type, (CtReference)typeReference);
        Collection methods = typeReference.getDeclaredExecutables();
        for (CtExecutableReference m : methods) {
            IMethodModel methodModel = this.processMethodReference(m);
            type.addMethod(methodModel);
        }
        return new ProxyType(this.registry, qualifiedName);
    }

    private IMethodModel processMethodReference(CtExecutableReference<?> methodElement) {
        MethodModel methodModel = new MethodModel();
        this.fillReference(methodModel, (CtReference)methodElement);
        List parameters = methodElement.getParameterTypes();
        for (CtTypeReference p : parameters) {
            IParameterModel parameterModel = this.processParameterReference(p);
            methodModel.addParameter(parameterModel);
        }
        return methodModel;
    }

    private IParameterModel processParameterReference(CtTypeReference<?> paramTypeReference) {
        ParameterModel parameterModel = new ParameterModel();
        parameterModel.setType(paramTypeReference.getQualifiedName());
        parameterModel.setName(paramTypeReference.getSimpleName());
        parameterModel.setRequired(paramTypeReference.isPrimitive());
        List annotations = paramTypeReference.getAnnotations();
        for (Annotation a : annotations) {
            IAnnotationModel annotationModel = this.processJavaLangAnnotation(a);
            parameterModel.addAnnotation(annotationModel);
        }
        return parameterModel;
    }

    private void fillReference(BasicModel model, CtReference ref) {
        String simpleName = ref.getSimpleName();
        model.setName(simpleName);
        List annotations = ref.getAnnotations();
        for (Annotation a : annotations) {
            IAnnotationModel annotationModel = this.processJavaLangAnnotation(a);
            model.addAnnotation(annotationModel);
        }
    }

    public TypeModelRegistry getRegistry() {
        return this.registry;
    }
}

