/*
 * Decompiled with CFR 0.152.
 */
package org.raml.utilities.matchers;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

class ContentEqualsAnyOrderIterableMatcher<T>
extends TypeSafeMatcher<Iterable<T>> {
    private final Iterable<T> iterable;

    private ContentEqualsAnyOrderIterableMatcher(Iterable<T> iterable) {
        this.iterable = iterable;
    }

    public static <T> ContentEqualsAnyOrderIterableMatcher<T> create(Iterable<T> iterable) {
        Preconditions.checkNotNull(iterable);
        return new ContentEqualsAnyOrderIterableMatcher<T>(iterable);
    }

    protected boolean matchesSafely(Iterable<T> toMatch) {
        HashMap<T, Integer> itemsOcurrences = new HashMap<T, Integer>(Iterables.size(this.iterable));
        for (T item : this.iterable) {
            int itemOcurrences = 1;
            if (itemsOcurrences.containsKey(item)) {
                itemOcurrences = (Integer)itemsOcurrences.get(item) + 1;
            }
            itemsOcurrences.put(item, itemOcurrences);
        }
        for (T item : toMatch) {
            if (!itemsOcurrences.containsKey(item)) {
                return false;
            }
            int itemOccurrences = (Integer)itemsOcurrences.get(item) - 1;
            if (itemOccurrences == 0) {
                itemsOcurrences.remove(item);
                continue;
            }
            itemsOcurrences.put(item, itemOccurrences);
        }
        return itemsOcurrences.isEmpty();
    }

    public void describeTo(Description description) {
    }
}

