/*
 * Decompiled with CFR 0.152.
 */
package org.raml.utilities.builder;

import com.google.common.base.Preconditions;
import org.raml.utilities.builder.Field;

public class NonNullableField<T>
implements Field<T> {
    private final T payload;

    private NonNullableField(T payload) {
        this.payload = payload;
    }

    public static <T> NonNullableField<T> unset() {
        return new NonNullableField<Object>(null);
    }

    public static <T> NonNullableField<T> of(T value) {
        Preconditions.checkNotNull(value);
        return new NonNullableField<T>(value);
    }

    public static <T> NonNullableField<T> ofNullable(T value) {
        return value == null ? NonNullableField.unset() : NonNullableField.of(value);
    }

    @Override
    public T get() {
        Preconditions.checkState((boolean)this.isSet(), (Object)"value not set");
        return this.payload;
    }

    @Override
    public boolean isSet() {
        return this.payload != null;
    }
}

