
package example.references;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Message
 * <p>
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "uuid",
    "drs"
})
public class Msg {

    @JsonProperty("uuid")
    private UUID uuid;
    @JsonProperty("drs")
    private List<Dr> drs = new ArrayList<Dr>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * 
     * @return
     *     The uuid
     */
    @JsonProperty("uuid")
    public UUID getUuid() {
        return uuid;
    }

    /**
     * 
     * @param uuid
     *     The uuid
     */
    @JsonProperty("uuid")
    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public Msg withUuid(UUID uuid) {
        this.uuid = uuid;
        return this;
    }

    /**
     * 
     * @return
     *     The drs
     */
    @JsonProperty("drs")
    public List<Dr> getDrs() {
        return drs;
    }

    /**
     * 
     * @param drs
     *     The drs
     */
    @JsonProperty("drs")
    public void setDrs(List<Dr> drs) {
        this.drs = drs;
    }

    public Msg withDrs(List<Dr> drs) {
        this.drs = drs;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Msg withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

}
