
package example.references;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Error
 * <p>
 * A common error response
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "code",
    "more_info",
    "fieldErrors"
})
public class Error {

    @JsonProperty("code")
    private String code;
    @JsonProperty("more_info")
    private String moreInfo;
    @JsonProperty("fieldErrors")
    private List<FieldError> fieldErrors = new ArrayList<FieldError>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * 
     * @return
     *     The code
     */
    @JsonProperty("code")
    public String getCode() {
        return code;
    }

    /**
     * 
     * @param code
     *     The code
     */
    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public Error withCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * 
     * @return
     *     The moreInfo
     */
    @JsonProperty("more_info")
    public String getMoreInfo() {
        return moreInfo;
    }

    /**
     * 
     * @param moreInfo
     *     The more_info
     */
    @JsonProperty("more_info")
    public void setMoreInfo(String moreInfo) {
        this.moreInfo = moreInfo;
    }

    public Error withMoreInfo(String moreInfo) {
        this.moreInfo = moreInfo;
        return this;
    }

    /**
     * 
     * @return
     *     The fieldErrors
     */
    @JsonProperty("fieldErrors")
    public List<FieldError> getFieldErrors() {
        return fieldErrors;
    }

    /**
     * 
     * @param fieldErrors
     *     The fieldErrors
     */
    @JsonProperty("fieldErrors")
    public void setFieldErrors(List<FieldError> fieldErrors) {
        this.fieldErrors = fieldErrors;
    }

    public Error withFieldErrors(List<FieldError> fieldErrors) {
        this.fieldErrors = fieldErrors;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Error withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

}
