package example.support;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import example.model.Limb;
import java.io.IOException;

public class LimbSerializer extends StdSerializer<Limb> {
  public LimbSerializer() {
    super(Limb.class);}

  public void serialize(Limb object, JsonGenerator jsonGenerator, SerializerProvider jsonSerializerProvider) throws IOException, JsonProcessingException {
    if ( object.isArm()) {
      jsonGenerator.writeObject(object.getArm());
      return;
    }
    if ( object.isLeg()) {
      jsonGenerator.writeObject(object.getLeg());
      return;
    }
    throw new IOException("Can't figure out type of object" + object);
  }
}
