package example.support;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import example.model.Arm;
import example.model.Leg;
import example.model.Limb;
import java.io.IOException;
import java.lang.Object;
import java.lang.String;
import java.util.Arrays;
import java.util.Map;

public class LimbDeserializer extends StdDeserializer<Limb> {
  public LimbDeserializer() {
    super(Limb.class);}

  private boolean looksLikeArm(Map<String, Object> map) {
    return map.keySet().containsAll(Arrays.asList("fingers"));
  }

  private boolean looksLikeLeg(Map<String, Object> map) {
    return map.keySet().containsAll(Arrays.asList("toes"));
  }

  public Limb deserialize(JsonParser jsonParser, DeserializationContext jsonContext) throws IOException, JsonProcessingException {
    ObjectMapper mapper  = new ObjectMapper();
    Map<String, Object> map = mapper.readValue(jsonParser, Map.class);
    if ( looksLikeArm(map) ) return new Limb(mapper.convertValue(map, Arm.class));
    if ( looksLikeLeg(map) ) return new Limb(mapper.convertValue(map, Leg.class));
    throw new IOException("Can't figure out type of object" + map);
  }
}
