package example.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import example.support.LimbDeserializer;
import example.support.LimbSerializer;
import java.lang.IllegalStateException;
import java.lang.Object;

@JsonDeserialize(
    using = LimbDeserializer.class
)
@JsonSerialize(
    using = LimbSerializer.class
)
public class Limb {
  private Object anyType;

  private Limb() {
    this.anyType = null;
  }

  public Limb(Arm arm) {
    this.anyType = arm;
  }

  public Limb(Leg leg) {
    this.anyType = leg;
  }

  public Arm getArm() {
    if ( !(anyType instanceof  Arm)) throw new IllegalStateException("fetching wrong type out of the union: Arm");
    return (Arm) anyType;
  }

  public boolean isArm() {
    return anyType instanceof Arm;
  }

  public Leg getLeg() {
    if ( !(anyType instanceof  Leg)) throw new IllegalStateException("fetching wrong type out of the union: Leg");
    return (Leg) anyType;
  }

  public boolean isLeg() {
    return anyType instanceof Leg;
  }
}
