/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.generator.v10;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.raml.jaxrs.generator.CurrentBuild;
import org.raml.jaxrs.generator.GAbstraction;
import org.raml.jaxrs.generator.v10.V10GMethod;
import org.raml.jaxrs.generator.v10.V10GResource;
import org.raml.jaxrs.generator.v10.V10GResponse;
import org.raml.jaxrs.generator.v10.V10GType;
import org.raml.ramltopojo.PluginDef;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.common.Annotable;
import org.raml.v2.api.model.v10.datamodel.TypeInstance;
import org.raml.v2.api.model.v10.datamodel.TypeInstanceProperty;
import org.raml.v2.api.model.v10.declarations.AnnotationRef;

public abstract class Annotations<T> {
    public static Annotations<String> CLASS_NAME = new Annotations<String>(){

        @Override
        public String getWithContext(CurrentBuild currentBuild, Annotable target, Annotable ... others) {
            return (String)Annotations.getWithDefault("types", "className", null, target, others);
        }
    };
    public static Annotations<List<PluginDef>> RESOURCE_PLUGINS = new Annotations<List<PluginDef>>(){

        @Override
        public List<PluginDef> getWithContext(CurrentBuild currentBuild, Annotable target, Annotable ... others) {
            return (List)Annotations.getWithDefault(new TypeInstanceToPluginDefFunction(), "resources", "plugins", Collections.emptyList(), target, others);
        }
    };
    public static Annotations<List<PluginDef>> METHOD_PLUGINS = new Annotations<List<PluginDef>>(){

        @Override
        public List<PluginDef> getWithContext(CurrentBuild currentBuild, Annotable target, Annotable ... others) {
            return (List)Annotations.getWithDefault(new TypeInstanceToPluginDefFunction(), "methods", "plugins", Collections.emptyList(), target, others);
        }
    };
    public static Annotations<List<PluginDef>> RESPONSE_PLUGINS = new Annotations<List<PluginDef>>(){

        @Override
        public List<PluginDef> getWithContext(CurrentBuild currentBuild, Annotable target, Annotable ... others) {
            return (List)Annotations.getWithDefault(new TypeInstanceToPluginDefFunction(), "responses", "plugins", Collections.emptyList(), target, others);
        }
    };
    public static Annotations<List<PluginDef>> RESPONSE_CLASS_PLUGINS = new Annotations<List<PluginDef>>(){

        @Override
        public List<PluginDef> getWithContext(CurrentBuild currentBuild, Annotable target, Annotable ... others) {
            return (List)Annotations.getWithDefault(new TypeInstanceToPluginDefFunction(), "responseClasses", "plugins", Collections.emptyList(), target, others);
        }
    };

    private static <T, R> R getWithDefault(Function<TypeInstance, T> convert, String annotationName, String propName, R def, Annotable target, Annotable ... others) {
        Object b = org.raml.ramltopojo.Annotations.evaluate(convert, (String)annotationName, (String)propName, (Annotable)target, (Annotable[])others);
        if (b == null) {
            return def;
        }
        return (R)b;
    }

    private static <T> T getWithDefault(String annotationName, String propName, T def, Annotable target, Annotable ... others) {
        T b = Annotations.evaluate(annotationName, propName, target, others);
        if (b == null) {
            return def;
        }
        return b;
    }

    private static <T> T evaluate(String annotationName, String parameterName, Annotable mandatory, Annotable ... others) {
        Object retval = null;
        ArrayList<Annotable> targets = new ArrayList<Annotable>();
        targets.add(mandatory);
        targets.addAll(Arrays.asList(others));
        for (Annotable target : targets) {
            Object o;
            AnnotationRef annotationRef = Annotations.findRef(target, annotationName);
            if (annotationRef == null || (o = Annotations.findProperty(annotationRef, parameterName)) == null) continue;
            retval = o;
        }
        return (T)retval;
    }

    private static Object findProperty(AnnotationRef annotationRef, String propName) {
        for (TypeInstanceProperty typeInstanceProperty : annotationRef.structuredValue().properties()) {
            if (!typeInstanceProperty.name().equalsIgnoreCase(propName)) continue;
            if (typeInstanceProperty.isArray().booleanValue()) {
                return Annotations.toValueList(typeInstanceProperty.values());
            }
            return typeInstanceProperty.value().value();
        }
        return null;
    }

    private static List<Object> toValueList(List<TypeInstance> values) {
        return Lists.transform(values, (Function)new Function<TypeInstance, Object>(){

            @Nullable
            public Object apply(@Nullable TypeInstance input) {
                return input.value();
            }
        });
    }

    private static AnnotationRef findRef(Annotable annotable, String annotation) {
        for (AnnotationRef annotationRef : annotable.annotations()) {
            if (!annotationRef.annotation().name().equalsIgnoreCase(annotation)) continue;
            return annotationRef;
        }
        return null;
    }

    public abstract T getWithContext(CurrentBuild var1, Annotable var2, Annotable ... var3);

    public T getValueWithDefault(T def, Annotable annotable, Annotable ... others) {
        T t = this.getWithContext(null, annotable, others);
        if (t == null) {
            return def;
        }
        return t;
    }

    public T get(V10GType type) {
        return this.getWithContext(null, (Annotable)type.implementation(), new Annotable[0]);
    }

    public T get(V10GResource resource) {
        return this.getWithContext(null, (Annotable)resource.implementation(), new Annotable[0]);
    }

    public T get(V10GMethod method) {
        return this.getWithContext(null, (Annotable)method.implementation(), new Annotable[0]);
    }

    public T get(V10GResponse response) {
        return this.getWithContext(null, (Annotable)response.implementation(), new Annotable[0]);
    }

    public T get(T def, V10GType type) {
        return this.get(def, (Annotable)type.implementation());
    }

    public T get(T def, Annotable type) {
        return this.getValueWithDefault(def, type, new Annotable[0]);
    }

    public T get(Annotable type) {
        return this.getValueWithDefault(null, type, new Annotable[0]);
    }

    public T get(T def, Annotable type, Annotable ... others) {
        return this.getValueWithDefault(def, type, others);
    }

    public T get(T def, Api api, GAbstraction ... others) {
        if (api == null) {
            return def;
        }
        return this.getValueWithDefault(def, (Annotable)api, (Annotable[])FluentIterable.of((Object[])others).transform((Function)new Function<GAbstraction, Annotable>(){

            @Nullable
            public Annotable apply(@Nullable GAbstraction o) {
                return (Annotable)o.implementation();
            }
        }).toArray(Annotable.class));
    }

    private static class TypeInstanceToPluginDefFunction
    implements Function<TypeInstance, PluginDef> {
        private TypeInstanceToPluginDefFunction() {
        }

        public PluginDef apply(@Nullable TypeInstance input) {
            if (input.properties().size() == 0) {
                return new PluginDef((String)input.value(), Collections.emptyList());
            }
            if (input.properties().size() == 1) {
                return new PluginDef((String)((TypeInstanceProperty)input.properties().get(0)).value().value(), Collections.emptyList());
            }
            return new PluginDef((String)((TypeInstanceProperty)input.properties().get(0)).value().value(), Lists.transform((List)((TypeInstanceProperty)input.properties().get(1)).values(), (Function)new Function<TypeInstance, String>(){

                @Nullable
                public String apply(@Nullable TypeInstance input) {
                    return (String)input.value();
                }
            }));
        }
    }
}

