/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.wallpaper;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.service.wallpaper.WallpaperService;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import org.rajawali3d.renderer.ISurfaceRenderer;
import org.rajawali3d.util.Capabilities;
import org.rajawali3d.view.ISurface;
import org.rajawali3d.view.SurfaceView;

public abstract class Wallpaper
extends WallpaperService {

    protected class WallpaperEngine
    extends WallpaperService.Engine {
        protected Context mContext;
        protected ISurfaceRenderer mRenderer;
        protected WallpaperSurfaceView mSurfaceView;
        protected ISurface.ANTI_ALIASING_CONFIG mAntiAliasingConfig;
        protected float mDefaultPreviewOffsetX;

        public WallpaperEngine(Context context, ISurfaceRenderer renderer) {
            this(context, renderer, ISurface.ANTI_ALIASING_CONFIG.NONE);
        }

        public WallpaperEngine(Context context, ISurfaceRenderer renderer, ISurface.ANTI_ALIASING_CONFIG antiAliasingConfig) {
            super((WallpaperService)Wallpaper.this);
            this.mContext = context;
            this.mRenderer = renderer;
            this.mAntiAliasingConfig = antiAliasingConfig;
            this.mDefaultPreviewOffsetX = 0.5f;
        }

        public void onOffsetsChanged(float xOffset, float yOffset, float xOffsetStep, float yOffsetStep, int xPixelOffset, int yPixelOffset) {
            super.onOffsetsChanged(xOffset, yOffset, xOffsetStep, yOffsetStep, xPixelOffset, yPixelOffset);
            if (this.mRenderer != null) {
                if (this.isPreview() && this.enableDefaultXOffsetInPreview()) {
                    xOffset = this.mDefaultPreviewOffsetX;
                }
                this.mRenderer.onOffsetsChanged(xOffset, yOffset, xOffsetStep, yOffsetStep, xPixelOffset, yPixelOffset);
            }
        }

        public boolean enableDefaultXOffsetInPreview() {
            return true;
        }

        public void onTouchEvent(MotionEvent event) {
            super.onTouchEvent(event);
            if (this.mRenderer != null) {
                this.mRenderer.onTouchEvent(event);
            }
        }

        @TargetApi(value=15)
        public void setOffsetNotificationsEnabled(boolean enabled) {
            if (Build.VERSION.SDK_INT >= 15) {
                super.setOffsetNotificationsEnabled(enabled);
            }
        }

        public void onCreate(SurfaceHolder holder) {
            super.onCreate(holder);
            this.mSurfaceView = new WallpaperSurfaceView(this.mContext);
            this.mSurfaceView.setEGLContextClientVersion(Capabilities.getGLESMajorVersion());
            this.mSurfaceView.setRenderMode(0);
            this.mSurfaceView.setAntiAliasingMode(this.mAntiAliasingConfig);
            this.mSurfaceView.setSurfaceRenderer(this.mRenderer);
            this.setTouchEventsEnabled(true);
        }

        public void onSurfaceDestroyed(SurfaceHolder holder) {
            super.onSurfaceDestroyed(holder);
        }

        public void onDestroy() {
            this.setTouchEventsEnabled(false);
            this.mRenderer.onRenderSurfaceDestroyed(null);
            this.mRenderer = null;
            this.mSurfaceView.onDestroy();
            super.onDestroy();
        }

        public void onVisibilityChanged(boolean visible) {
            super.onVisibilityChanged(visible);
            if (visible) {
                this.mSurfaceView.onResume();
            } else {
                this.mSurfaceView.onPause();
            }
        }

        class WallpaperSurfaceView
        extends SurfaceView {
            WallpaperSurfaceView(Context context) {
                super(context);
            }

            public SurfaceHolder getHolder() {
                return WallpaperEngine.this.getSurfaceHolder();
            }

            public void onDestroy() {
                super.onDetachedFromWindow();
            }
        }
    }
}

