/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.visitors;

import org.rajawali3d.Object3D;
import org.rajawali3d.bounds.BoundingBox;
import org.rajawali3d.bounds.BoundingSphere;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.util.Intersector;
import org.rajawali3d.visitors.INode;
import org.rajawali3d.visitors.INodeVisitor;

public class RayPickingVisitor
implements INodeVisitor {
    private Vector3 mRayStart;
    private Vector3 mRayEnd;
    private Vector3 mHitPoint;
    private Object3D mPickedObject;

    public RayPickingVisitor(Vector3 rayStart, Vector3 rayEnd) {
        this.mRayStart = rayStart;
        this.mRayEnd = rayEnd;
        this.mHitPoint = new Vector3();
    }

    @Override
    public void apply(INode node) {
        if (node instanceof Object3D) {
            Object3D o = (Object3D)node;
            if (!o.isVisible() || !o.isInFrustum()) {
                return;
            }
            if (o.getGeometry().hasBoundingSphere()) {
                BoundingSphere bsphere = o.getGeometry().getBoundingSphere();
                bsphere.calculateBounds(o.getGeometry());
                bsphere.transform(o.getModelMatrix());
                if (this.intersectsWith(bsphere) && (this.mPickedObject == null || this.mPickedObject != null && o.getPosition().z < this.mPickedObject.getPosition().z)) {
                    this.mPickedObject = o;
                }
            } else {
                BoundingBox bbox = o.getGeometry().getBoundingBox();
                bbox.calculateBounds(o.getGeometry());
                bbox.transform(o.getModelMatrix());
                if (this.intersectsWith(bbox) && (this.mPickedObject == null || this.mPickedObject != null && o.getPosition().z < this.mPickedObject.getPosition().z)) {
                    this.mPickedObject = o;
                }
            }
        }
    }

    private boolean intersectsWith(BoundingBox bbox) {
        Vector3 raySta = this.mRayStart;
        Vector3 rayEnd = this.mRayEnd;
        Vector3 boxMin = bbox.getTransformedMin();
        Vector3 boxMax = bbox.getTransformedMax();
        if (rayEnd.x < boxMin.x && raySta.x < boxMin.x) {
            return false;
        }
        if (rayEnd.x > boxMax.x && raySta.x > boxMax.x) {
            return false;
        }
        if (rayEnd.y < boxMin.y && raySta.y < boxMin.y) {
            return false;
        }
        if (rayEnd.y > boxMax.y && raySta.y > boxMax.y) {
            return false;
        }
        if (rayEnd.z < boxMin.z && raySta.z < boxMin.z) {
            return false;
        }
        if (rayEnd.z > boxMax.z && raySta.z > boxMax.z) {
            return false;
        }
        if (raySta.x > boxMin.x && raySta.x < boxMax.x && raySta.y > boxMin.y && raySta.y < boxMax.y && raySta.z > boxMin.z && raySta.z < boxMax.z) {
            this.mHitPoint.setAll(raySta);
            return true;
        }
        return this.getIntersection(raySta.x - boxMin.x, rayEnd.x - boxMin.x, raySta, rayEnd) && this.isInBox(boxMin, boxMax, Vector3.Axis.X) || this.getIntersection(raySta.y - boxMin.y, rayEnd.y - boxMin.y, raySta, rayEnd) && this.isInBox(boxMin, boxMax, Vector3.Axis.Y) || this.getIntersection(raySta.z - boxMin.z, rayEnd.z - boxMin.z, raySta, rayEnd) && this.isInBox(boxMin, boxMax, Vector3.Axis.Z) || this.getIntersection(raySta.x - boxMax.x, rayEnd.x - boxMax.x, raySta, rayEnd) && this.isInBox(boxMin, boxMax, Vector3.Axis.X) || this.getIntersection(raySta.y - boxMax.y, rayEnd.y - boxMax.y, raySta, rayEnd) && this.isInBox(boxMin, boxMax, Vector3.Axis.Y) || this.getIntersection(raySta.z - boxMax.z, rayEnd.z - boxMax.z, raySta, rayEnd) && this.isInBox(boxMin, boxMax, Vector3.Axis.Z);
    }

    private boolean intersectsWith(BoundingSphere bsphere) {
        return Intersector.intersectRaySphere(this.mRayStart, this.mRayEnd, bsphere.getPosition(), bsphere.getRadius(), this.mHitPoint);
    }

    private boolean getIntersection(double fDst1, double fDst2, Vector3 P1, Vector3 P2) {
        if (fDst1 * fDst2 >= 0.0) {
            return false;
        }
        if (this.floatEqual(fDst1, fDst2)) {
            return false;
        }
        this.mHitPoint.setAll(P1);
        this.mHitPoint.add(Vector3.subtractAndCreate(P2, P1));
        this.mHitPoint.multiply(-fDst1 / (fDst2 - fDst1));
        return true;
    }

    private boolean floatEqual(double lhs, double rhs) {
        return Math.abs(lhs - rhs) < (double)1.0E-5f;
    }

    private boolean isInBox(Vector3 boxMin, Vector3 boxMax, Vector3.Axis axis) {
        if (axis == Vector3.Axis.X && this.mHitPoint.z > boxMin.z && this.mHitPoint.z < boxMax.z && this.mHitPoint.y > boxMin.y && this.mHitPoint.y < boxMax.y) {
            return true;
        }
        if (axis == Vector3.Axis.Y && this.mHitPoint.z > boxMin.z && this.mHitPoint.z < boxMax.z && this.mHitPoint.x > boxMin.x && this.mHitPoint.x < boxMax.x) {
            return true;
        }
        return axis == Vector3.Axis.Z && this.mHitPoint.x > boxMin.x && this.mHitPoint.x < boxMax.x && this.mHitPoint.y > boxMin.y && this.mHitPoint.y < boxMax.y;
    }

    public Object3D getPickedObject() {
        return this.mPickedObject;
    }
}

