/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.SurfaceTexture;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.TextureView;
import android.view.View;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Locale;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;
import javax.microedition.khronos.opengles.GL10;
import org.rajawali3d.R;
import org.rajawali3d.renderer.ISurfaceRenderer;
import org.rajawali3d.util.Capabilities;
import org.rajawali3d.util.egl.RajawaliEGLConfigChooser;
import org.rajawali3d.view.ISurface;

public class TextureView
extends android.view.TextureView
implements ISurface {
    private static final String TAG = "TextureView";
    private static final boolean LOG_ATTACH_DETACH = false;
    private static final boolean LOG_THREADS = false;
    private static final boolean LOG_PAUSE_RESUME = false;
    private static final boolean LOG_SURFACE = true;
    private static final boolean LOG_RENDERER = false;
    private static final boolean LOG_RENDERER_DRAW_FRAME = false;
    private static final boolean LOG_EGL = false;
    private static final GLThreadManager sGLThreadManager = new GLThreadManager();
    private final WeakReference<TextureView> mThisWeakRef = new WeakReference<TextureView>(this);
    protected double mFrameRate = 60.0;
    protected int mRenderMode = 0;
    protected ISurface.ANTI_ALIASING_CONFIG mAntiAliasingConfig = ISurface.ANTI_ALIASING_CONFIG.NONE;
    protected int mBitsRed = 5;
    protected int mBitsGreen = 6;
    protected int mBitsBlue = 5;
    protected int mBitsAlpha = 0;
    protected int mBitsDepth = 16;
    protected int mMultiSampleCount = 0;
    private GLThread mGLThread;
    private boolean mDetached;
    private GLSurfaceView.EGLConfigChooser mEGLConfigChooser;
    private GLSurfaceView.EGLContextFactory mEGLContextFactory;
    private GLSurfaceView.EGLWindowSurfaceFactory mEGLWindowSurfaceFactory;
    private int mEGLContextClientVersion;
    private boolean mPreserveEGLContextOnPause;
    protected RendererDelegate mRendererDelegate;

    public TextureView(Context context) {
        super(context);
    }

    public TextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.applyAttributes(context, attrs);
    }

    public TextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.applyAttributes(context, attrs);
    }

    @TargetApi(value=21)
    public TextureView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.applyAttributes(context, attrs);
    }

    private void applyAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.TextureView);
        int count = array.getIndexCount();
        for (int i = 0; i < count; ++i) {
            int attr = array.getIndex(i);
            if (attr == R.styleable.TextureView_frameRate) {
                this.mFrameRate = array.getFloat(attr, 60.0f);
                continue;
            }
            if (attr == R.styleable.TextureView_renderMode) {
                this.mRenderMode = array.getInt(attr, 0);
                continue;
            }
            if (attr == R.styleable.TextureView_antiAliasingType) {
                this.mAntiAliasingConfig = ISurface.ANTI_ALIASING_CONFIG.fromInteger(array.getInteger(attr, ISurface.ANTI_ALIASING_CONFIG.NONE.ordinal()));
                continue;
            }
            if (attr == R.styleable.TextureView_bitsRed) {
                this.mBitsRed = array.getInteger(attr, 5);
                continue;
            }
            if (attr == R.styleable.TextureView_bitsGreen) {
                this.mBitsGreen = array.getInteger(attr, 6);
                continue;
            }
            if (attr == R.styleable.TextureView_bitsBlue) {
                this.mBitsBlue = array.getInteger(attr, 5);
                continue;
            }
            if (attr == R.styleable.TextureView_bitsAlpha) {
                this.mBitsAlpha = array.getInteger(attr, 0);
                continue;
            }
            if (attr != R.styleable.TextureView_bitsDepth) continue;
            this.mBitsDepth = array.getInteger(attr, 16);
        }
        array.recycle();
    }

    private void initialize() {
        int glesMajorVersion = Capabilities.getGLESMajorVersion();
        this.setEGLContextClientVersion(glesMajorVersion);
        this.setEGLConfigChooser(new RajawaliEGLConfigChooser(glesMajorVersion, this.mAntiAliasingConfig, this.mMultiSampleCount, this.mBitsRed, this.mBitsGreen, this.mBitsBlue, this.mBitsAlpha, this.mBitsDepth));
    }

    private void checkRenderThreadState() {
        if (this.mGLThread != null) {
            throw new IllegalStateException("setRenderer has already been called for this instance.");
        }
    }

    private void surfaceCreated(int width, int height) {
        this.mGLThread.surfaceCreated(width, height);
    }

    private void surfaceDestroyed() {
        this.mGLThread.surfaceDestroyed();
    }

    private void surfaceChanged(int w, int h) {
        this.mGLThread.onWindowResize(w, h);
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        if (!this.isInEditMode()) {
            if (visibility == 8 || visibility == 4) {
                this.onPause();
            } else {
                this.onResume();
            }
        }
        super.onVisibilityChanged(changedView, visibility);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mDetached && this.mRendererDelegate != null) {
            int renderMode = 1;
            if (this.mGLThread != null) {
                renderMode = this.mGLThread.getRenderMode();
            }
            this.mGLThread = new GLThread(this.mThisWeakRef);
            if (renderMode != 1) {
                this.mGLThread.setRenderMode(renderMode);
            }
            this.mGLThread.start();
        }
        this.mDetached = false;
    }

    protected void onDetachedFromWindow() {
        this.mRendererDelegate.mRenderer.onRenderSurfaceDestroyed(null);
        if (this.mGLThread != null) {
            this.mGLThread.requestExitAndWait();
        }
        this.mDetached = true;
        super.onDetachedFromWindow();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mGLThread != null) {
                this.mGLThread.requestExitAndWait();
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void setFrameRate(double rate) {
        this.mFrameRate = rate;
        if (this.mRendererDelegate != null) {
            this.mRendererDelegate.mRenderer.setFrameRate(rate);
        }
    }

    @Override
    public int getRenderMode() {
        if (this.mRendererDelegate != null) {
            return this.getRenderModeInternal();
        }
        return this.mRenderMode;
    }

    @Override
    public void setRenderMode(int mode) {
        this.mRenderMode = mode;
        if (this.mRendererDelegate != null) {
            this.setRenderModeInternal(this.mRenderMode);
        }
    }

    @Override
    public void setAntiAliasingMode(ISurface.ANTI_ALIASING_CONFIG config) {
        this.mAntiAliasingConfig = config;
    }

    @Override
    public void setSampleCount(int count) {
        this.mMultiSampleCount = count;
    }

    @Override
    public void setSurfaceRenderer(ISurfaceRenderer renderer) throws IllegalStateException {
        if (this.mRendererDelegate != null) {
            throw new IllegalStateException("A renderer has already been set for this view.");
        }
        this.initialize();
        this.checkRenderThreadState();
        if (this.mEGLConfigChooser == null) {
            throw new IllegalStateException("You must set an EGL config before attempting to set a surface renderer.");
        }
        if (this.mEGLContextFactory == null) {
            this.mEGLContextFactory = new DefaultContextFactory();
        }
        if (this.mEGLWindowSurfaceFactory == null) {
            this.mEGLWindowSurfaceFactory = new DefaultWindowSurfaceFactory();
        }
        RendererDelegate delegate = new RendererDelegate(renderer, this);
        this.mGLThread = new GLThread(this.mThisWeakRef);
        this.mGLThread.start();
        this.setRenderModeInternal(this.mRenderMode);
        this.mRendererDelegate = delegate;
        this.setSurfaceTextureListener(this.mRendererDelegate);
    }

    @Override
    public void requestRenderUpdate() {
        this.mGLThread.requestRender();
    }

    public void setPreserveEGLContextOnPause(boolean preserveOnPause) {
        this.mPreserveEGLContextOnPause = preserveOnPause;
    }

    public boolean getPreserveEGLContextOnPause() {
        return this.mPreserveEGLContextOnPause;
    }

    public void setEGLContextFactory(GLSurfaceView.EGLContextFactory factory) {
        this.checkRenderThreadState();
        this.mEGLContextFactory = factory;
    }

    public void setEGLWindowSurfaceFactory(GLSurfaceView.EGLWindowSurfaceFactory factory) {
        this.checkRenderThreadState();
        this.mEGLWindowSurfaceFactory = factory;
    }

    public void setEGLConfigChooser(GLSurfaceView.EGLConfigChooser configChooser) {
        this.checkRenderThreadState();
        this.mEGLConfigChooser = configChooser;
    }

    public void setEGLConfigChooser(int redSize, int greenSize, int blueSize, int alphaSize, int depthSize, int stencilSize) {
        this.setEGLConfigChooser(new ComponentSizeChooser(redSize, greenSize, blueSize, alphaSize, depthSize, stencilSize));
    }

    public void setEGLContextClientVersion(int version) {
        this.checkRenderThreadState();
        this.mEGLContextClientVersion = version;
    }

    private void setRenderModeInternal(int renderMode) {
        this.mGLThread.setRenderMode(renderMode);
    }

    private int getRenderModeInternal() {
        return this.mGLThread.getRenderMode();
    }

    public void onPause() {
        if (this.mRendererDelegate != null) {
            this.mRendererDelegate.mRenderer.onPause();
        }
        if (this.mGLThread != null) {
            this.mGLThread.onPause();
        }
    }

    public void onResume() {
        if (this.mRendererDelegate != null) {
            this.mRendererDelegate.mRenderer.onResume();
        }
        this.mGLThread.onResume();
    }

    public void queueEvent(Runnable r) {
        this.mGLThread.queueEvent(r);
    }

    static /* synthetic */ boolean access$1100(TextureView x0) {
        return x0.mPreserveEGLContextOnPause;
    }

    private static class GLThreadManager {
        private static String TAG = "RajawaliGLThreadManager";
        private boolean mGLESVersionCheckComplete;
        private int mGLESVersion;
        private boolean mGLESDriverCheckComplete;
        private boolean mMultipleGLESContextsAllowed;
        private boolean mLimitedGLESContexts;
        private static final int kGLES_20 = 131072;
        private static final String kMSM7K_RENDERER_PREFIX = "Q3Dimension MSM7500 ";
        private GLThread mEglOwner;

        private GLThreadManager() {
        }

        public synchronized void threadExiting(GLThread thread) {
            thread.mExited = true;
            if (this.mEglOwner == thread) {
                this.mEglOwner = null;
            }
            this.notifyAll();
        }

        public boolean tryAcquireEglContextLocked(GLThread thread) {
            if (this.mEglOwner == thread || this.mEglOwner == null) {
                this.mEglOwner = thread;
                this.notifyAll();
                return true;
            }
            this.checkGLESVersion();
            if (this.mMultipleGLESContextsAllowed) {
                return true;
            }
            if (this.mEglOwner != null) {
                this.mEglOwner.requestReleaseEglContextLocked();
            }
            return false;
        }

        public void releaseEglContextLocked(GLThread thread) {
            if (this.mEglOwner == thread) {
                this.mEglOwner = null;
            }
            this.notifyAll();
        }

        public synchronized boolean shouldReleaseEGLContextWhenPausing() {
            return this.mLimitedGLESContexts;
        }

        public synchronized boolean shouldTerminateEGLWhenPausing() {
            this.checkGLESVersion();
            return !this.mMultipleGLESContextsAllowed;
        }

        private void checkGLESVersion() {
            if (!this.mGLESVersionCheckComplete) {
                this.mGLESVersion = Capabilities.getGLESMajorVersion();
                if (this.mGLESVersion >= 131072) {
                    this.mMultipleGLESContextsAllowed = true;
                }
                Log.w((String)TAG, (String)("checkGLESVersion mGLESVersion = " + this.mGLESVersion + " mMultipleGLESContextsAllowed = " + this.mMultipleGLESContextsAllowed));
                this.mGLESVersionCheckComplete = true;
            }
        }

        public synchronized void checkGLDriver(GL10 gl) {
            if (!this.mGLESDriverCheckComplete) {
                this.checkGLESVersion();
                String renderer = gl.glGetString(7937);
                if (this.mGLESVersion < 131072) {
                    this.mMultipleGLESContextsAllowed = !renderer.startsWith(kMSM7K_RENDERER_PREFIX);
                    this.notifyAll();
                }
                this.mLimitedGLESContexts = !this.mMultipleGLESContextsAllowed;
                Log.w((String)TAG, (String)("checkGLDriver renderer = \"" + renderer + "\" multipleContextsAllowed = " + this.mMultipleGLESContextsAllowed + " mLimitedGLESContexts = " + this.mLimitedGLESContexts));
                this.mGLESDriverCheckComplete = true;
            }
        }
    }

    static class GLThread
    extends Thread {
        private boolean mShouldExit;
        private boolean mExited;
        private boolean mRequestPaused;
        private boolean mPaused;
        private boolean mHasSurface;
        private boolean mSurfaceIsBad;
        private boolean mWaitingForSurface;
        private boolean mHaveEglContext;
        private boolean mHaveEglSurface;
        private boolean mFinishedCreatingEglSurface;
        private boolean mShouldReleaseEglContext;
        private int mWidth = 0;
        private int mHeight = 0;
        private int mRenderMode = 1;
        private boolean mRequestRender = true;
        private boolean mRenderComplete;
        private ArrayList<Runnable> mEventQueue = new ArrayList();
        private boolean mSizeChanged = true;
        private EglHelper mEglHelper;
        private WeakReference<TextureView> mRajawaliTextureViewWeakRef;

        GLThread(WeakReference<TextureView> glSurfaceViewWeakRef) {
            this.mRajawaliTextureViewWeakRef = glSurfaceViewWeakRef;
        }

        @Override
        public void run() {
            this.setName("RajawaliGLThread " + this.getId());
            try {
                this.guardedRun();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                sGLThreadManager.threadExiting(this);
            }
        }

        private void stopEglSurfaceLocked() {
            if (this.mHaveEglSurface) {
                this.mHaveEglSurface = false;
                this.mEglHelper.destroySurface();
            }
        }

        private void stopEglContextLocked() {
            if (this.mHaveEglContext) {
                this.mEglHelper.finish();
                this.mHaveEglContext = false;
                sGLThreadManager.releaseEglContextLocked(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void guardedRun() throws InterruptedException {
            this.mEglHelper = new EglHelper(this.mRajawaliTextureViewWeakRef);
            this.mHaveEglContext = false;
            this.mHaveEglSurface = false;
            try {
                gl = null;
                createEglContext = false;
                createEglSurface = false;
                createGlInterface = false;
                lostEglContext = false;
                sizeChanged = false;
                wantRenderNotification = false;
                doRenderNotification = false;
                askedToReleaseEglContext = false;
                w = 0;
                h = 0;
                event = null;
                while (true) {
                    var13_13 = TextureView.access$1000();
                    synchronized (var13_13) {
                        while (true) {
                            if (this.mShouldExit) {
                                return;
                            }
                            if (!this.mEventQueue.isEmpty()) {
                                event = this.mEventQueue.remove(0);
                                break;
                            }
                            pausing = false;
                            if (this.mPaused != this.mRequestPaused) {
                                pausing = this.mRequestPaused;
                                this.mPaused = this.mRequestPaused;
                                TextureView.access$1000().notifyAll();
                            }
                            if (this.mShouldReleaseEglContext) {
                                Log.i((String)"RajawaliGLThread", (String)("releasing EGL context because asked to tid=" + this.getId()));
                                this.stopEglSurfaceLocked();
                                this.stopEglContextLocked();
                                this.mShouldReleaseEglContext = false;
                                askedToReleaseEglContext = true;
                            }
                            if (lostEglContext) {
                                this.stopEglSurfaceLocked();
                                this.stopEglContextLocked();
                                lostEglContext = false;
                            }
                            if (pausing && this.mHaveEglSurface) {
                                Log.i((String)"RajawaliGLThread", (String)("releasing EGL surface because paused tid=" + this.getId()));
                                this.stopEglSurfaceLocked();
                            }
                            if (pausing && this.mHaveEglContext) {
                                view = (TextureView)this.mRajawaliTextureViewWeakRef.get();
                                v0 = preserveEglContextOnPause = view != null && TextureView.access$1100(view) != false;
                                if (!preserveEglContextOnPause || TextureView.access$1000().shouldReleaseEGLContextWhenPausing()) {
                                    this.stopEglContextLocked();
                                    Log.i((String)"RajawaliGLThread", (String)("releasing EGL context because paused tid=" + this.getId()));
                                }
                            }
                            if (pausing && TextureView.access$1000().shouldTerminateEGLWhenPausing()) {
                                this.mEglHelper.finish();
                                Log.i((String)"RajawaliGLThread", (String)("terminating EGL because paused tid=" + this.getId()));
                            }
                            if (!this.mHasSurface && !this.mWaitingForSurface) {
                                Log.i((String)"RajawaliGLThread", (String)("noticed surfaceView surface lost tid=" + this.getId()));
                                if (this.mHaveEglSurface) {
                                    this.stopEglSurfaceLocked();
                                }
                                this.mWaitingForSurface = true;
                                this.mSurfaceIsBad = false;
                                TextureView.access$1000().notifyAll();
                            }
                            if (this.mHasSurface && this.mWaitingForSurface) {
                                Log.i((String)"RajawaliGLThread", (String)("noticed surfaceView surface acquired tid=" + this.getId()));
                                this.mWaitingForSurface = false;
                                TextureView.access$1000().notifyAll();
                            }
                            if (doRenderNotification) {
                                Log.i((String)"RajawaliGLThread", (String)("sending render notification tid=" + this.getId()));
                                wantRenderNotification = false;
                                doRenderNotification = false;
                                this.mRenderComplete = true;
                                TextureView.access$1000().notifyAll();
                            }
                            if (this.readyToDraw()) {
                                if (!this.mHaveEglContext) {
                                    if (askedToReleaseEglContext) {
                                        askedToReleaseEglContext = false;
                                    } else if (TextureView.access$1000().tryAcquireEglContextLocked(this)) {
                                        try {
                                            this.mEglHelper.start();
                                        }
                                        catch (RuntimeException t) {
                                            TextureView.access$1000().releaseEglContextLocked(this);
                                            throw t;
                                        }
                                        this.mHaveEglContext = true;
                                        createEglContext = true;
                                        TextureView.access$1000().notifyAll();
                                    }
                                }
                                if (this.mHaveEglContext && !this.mHaveEglSurface) {
                                    this.mHaveEglSurface = true;
                                    createEglSurface = true;
                                    createGlInterface = true;
                                    sizeChanged = true;
                                }
                                if (this.mHaveEglSurface) {
                                    if (this.mSizeChanged) {
                                        sizeChanged = true;
                                        w = this.mWidth;
                                        h = this.mHeight;
                                        wantRenderNotification = true;
                                        Log.i((String)"RajawaliGLThread", (String)("noticing that we want render notification tid=" + this.getId()));
                                        createEglSurface = true;
                                        this.mSizeChanged = false;
                                    }
                                    this.mRequestRender = false;
                                    TextureView.access$1000().notifyAll();
                                    break;
                                }
                            }
                            TextureView.access$1000().wait();
                        }
                        ** if (event == null) goto lbl116
                    }
lbl-1000:
                    // 1 sources

                    {
                        event.run();
                        event = null;
                        continue;
                    }
lbl116:
                    // 1 sources

                    if (createEglSurface) {
                        Log.w((String)"RajawaliGLThread", (String)"egl createSurface");
                        if (this.mEglHelper.createSurface()) {
                            var13_13 = TextureView.access$1000();
                            synchronized (var13_13) {
                                this.mFinishedCreatingEglSurface = true;
                                TextureView.access$1000().notifyAll();
                            }
                            createEglSurface = false;
                        } else {
                            var13_13 = TextureView.access$1000();
                            synchronized (var13_13) {
                                this.mFinishedCreatingEglSurface = true;
                                this.mSurfaceIsBad = true;
                                TextureView.access$1000().notifyAll();
                                continue;
                            }
                        }
                    }
                    if (createGlInterface) {
                        gl = (GL10)this.mEglHelper.createGL();
                        TextureView.access$1000().checkGLDriver(gl);
                        createGlInterface = false;
                    }
                    if (createEglContext) {
                        view = (TextureView)this.mRajawaliTextureViewWeakRef.get();
                        if (view != null) {
                            view.mRendererDelegate.mRenderer.onRenderSurfaceCreated(this.mEglHelper.mEglConfig, gl, -1, -1);
                        }
                        createEglContext = false;
                    }
                    if (sizeChanged) {
                        view = (TextureView)this.mRajawaliTextureViewWeakRef.get();
                        if (view != null) {
                            view.mRendererDelegate.mRenderer.onRenderSurfaceSizeChanged(gl, w, h);
                        }
                        sizeChanged = false;
                    }
                    if ((view = (TextureView)this.mRajawaliTextureViewWeakRef.get()) != null) {
                        view.mRendererDelegate.mRenderer.onRenderFrame(gl);
                    }
                    swapError = this.mEglHelper.swap();
                    switch (swapError) {
                        case 12288: {
                            break;
                        }
                        case 12302: {
                            Log.i((String)"RajawaliGLThread", (String)("egl context lost tid=" + this.getId()));
                            lostEglContext = true;
                            break;
                        }
                        default: {
                            EglHelper.logEglErrorAsWarning("RajawaliGLThread", "eglSwapBuffers", swapError);
                            var14_17 = TextureView.access$1000();
                            synchronized (var14_17) {
                                this.mSurfaceIsBad = true;
                                TextureView.access$1000().notifyAll();
                                break;
                            }
                        }
                    }
                    if (!wantRenderNotification) continue;
                    doRenderNotification = true;
                }
            }
            finally {
                var14_15 = TextureView.access$1000();
                synchronized (var14_15) {
                    this.stopEglSurfaceLocked();
                    this.stopEglContextLocked();
                }
            }
        }

        public boolean ableToDraw() {
            return this.mHaveEglContext && this.mHaveEglSurface && this.readyToDraw();
        }

        private boolean readyToDraw() {
            return !this.mPaused && this.mHasSurface && !this.mSurfaceIsBad && this.mWidth > 0 && this.mHeight > 0 && (this.mRequestRender || this.mRenderMode == 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRenderMode(int renderMode) {
            if (0 > renderMode || renderMode > 1) {
                throw new IllegalArgumentException("renderMode");
            }
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRenderMode = renderMode;
                sGLThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRenderMode() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                return this.mRenderMode;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestRender() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestRender = true;
                sGLThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void surfaceCreated(int w, int h) {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mHasSurface = true;
                this.mWidth = w;
                this.mHeight = h;
                this.mFinishedCreatingEglSurface = false;
                sGLThreadManager.notifyAll();
                while (this.mWaitingForSurface && !this.mFinishedCreatingEglSurface && !this.mExited) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void surfaceDestroyed() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mHasSurface = false;
                sGLThreadManager.notifyAll();
                while (!this.mWaitingForSurface && !this.mExited) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPause() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestPaused = true;
                sGLThreadManager.notifyAll();
                while (!this.mExited && !this.mPaused) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResume() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestPaused = false;
                this.mRequestRender = true;
                this.mRenderComplete = false;
                sGLThreadManager.notifyAll();
                while (!this.mExited && this.mPaused && !this.mRenderComplete) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWindowResize(int w, int h) {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mWidth = w;
                this.mHeight = h;
                this.mSizeChanged = true;
                this.mRequestRender = true;
                this.mRenderComplete = false;
                sGLThreadManager.notifyAll();
                while (!this.mExited && !this.mPaused && !this.mRenderComplete && this.ableToDraw()) {
                    Log.i((String)"Main thread", (String)("onWindowResize waiting for render complete from tid=" + this.getId()));
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestExitAndWait() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mShouldExit = true;
                sGLThreadManager.notifyAll();
                while (!this.mExited) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        public void requestReleaseEglContextLocked() {
            this.mShouldReleaseEglContext = true;
            sGLThreadManager.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueEvent(Runnable r) {
            if (r == null) {
                throw new IllegalArgumentException("r must not be null");
            }
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mEventQueue.add(r);
                sGLThreadManager.notifyAll();
            }
        }
    }

    private static class EglHelper {
        private WeakReference<TextureView> mRajawaliTextureViewWeakRef;
        EGL10 mEgl;
        EGLDisplay mEglDisplay;
        EGLSurface mEglSurface;
        EGLConfig mEglConfig;
        EGLContext mEglContext;

        public EglHelper(WeakReference<TextureView> glSurfaceViewWeakRef) {
            this.mRajawaliTextureViewWeakRef = glSurfaceViewWeakRef;
        }

        public void start() {
            this.mEgl = (EGL10)EGLContext.getEGL();
            this.mEglDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            if (this.mEglDisplay == EGL10.EGL_NO_DISPLAY) {
                throw new RuntimeException("eglGetDisplay failed");
            }
            int[] version = new int[2];
            if (!this.mEgl.eglInitialize(this.mEglDisplay, version)) {
                throw new RuntimeException("eglInitialize failed");
            }
            TextureView view = (TextureView)this.mRajawaliTextureViewWeakRef.get();
            if (view == null) {
                this.mEglConfig = null;
                this.mEglContext = null;
            } else {
                this.mEglConfig = view.mEGLConfigChooser.chooseConfig(this.mEgl, this.mEglDisplay);
                this.mEglContext = view.mEGLContextFactory.createContext(this.mEgl, this.mEglDisplay, this.mEglConfig);
            }
            if (this.mEglContext == null || this.mEglContext == EGL10.EGL_NO_CONTEXT) {
                this.mEglContext = null;
                this.throwEglException("createContext");
            }
            this.mEglSurface = null;
        }

        public boolean createSurface() {
            if (this.mEgl == null) {
                throw new RuntimeException("egl not initialized");
            }
            if (this.mEglDisplay == null) {
                throw new RuntimeException("eglDisplay not initialized");
            }
            if (this.mEglConfig == null) {
                throw new RuntimeException("mEglConfig not initialized");
            }
            this.destroySurfaceImp();
            TextureView view = (TextureView)this.mRajawaliTextureViewWeakRef.get();
            this.mEglSurface = view != null ? view.mEGLWindowSurfaceFactory.createWindowSurface(this.mEgl, this.mEglDisplay, this.mEglConfig, (Object)view.getSurfaceTexture()) : null;
            if (this.mEglSurface == null || this.mEglSurface == EGL10.EGL_NO_SURFACE) {
                int error = this.mEgl.eglGetError();
                if (error == 12299) {
                    Log.e((String)"EglHelper", (String)"createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
                }
                return false;
            }
            if (!this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext)) {
                EglHelper.logEglErrorAsWarning("EGLHelper", "eglMakeCurrent", this.mEgl.eglGetError());
                return false;
            }
            return true;
        }

        GL createGL() {
            return this.mEglContext.getGL();
        }

        public int swap() {
            if (!this.mEgl.eglSwapBuffers(this.mEglDisplay, this.mEglSurface)) {
                return this.mEgl.eglGetError();
            }
            return 12288;
        }

        public void destroySurface() {
            this.destroySurfaceImp();
        }

        private void destroySurfaceImp() {
            if (this.mEglSurface != null && this.mEglSurface != EGL10.EGL_NO_SURFACE) {
                this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                TextureView view = (TextureView)this.mRajawaliTextureViewWeakRef.get();
                if (view != null) {
                    view.mEGLWindowSurfaceFactory.destroySurface(this.mEgl, this.mEglDisplay, this.mEglSurface);
                }
                this.mEglSurface = null;
            }
        }

        public void finish() {
            if (this.mEglContext != null) {
                TextureView view = (TextureView)this.mRajawaliTextureViewWeakRef.get();
                if (view != null) {
                    view.mEGLContextFactory.destroyContext(this.mEgl, this.mEglDisplay, this.mEglContext);
                }
                this.mEglContext = null;
            }
            if (this.mEglDisplay != null) {
                this.mEgl.eglTerminate(this.mEglDisplay);
                this.mEglDisplay = null;
            }
        }

        private void throwEglException(String function) {
            EglHelper.throwEglException(function, this.mEgl.eglGetError());
        }

        public static void throwEglException(String function, int error) {
            String message = EglHelper.formatEglError(function, error);
            throw new RuntimeException(message);
        }

        public static void logEglErrorAsWarning(String tag, String function, int error) {
            Log.w((String)tag, (String)EglHelper.formatEglError(function, error));
        }

        public static String formatEglError(String function, int error) {
            return function + " failed: " + EglHelper.getErrorString(error);
        }

        public static String getErrorString(int error) {
            switch (error) {
                case 12288: {
                    return "EGL_SUCCESS";
                }
                case 12289: {
                    return "EGL_NOT_INITIALIZED";
                }
                case 12290: {
                    return "EGL_BAD_ACCESS";
                }
                case 12291: {
                    return "EGL_BAD_ALLOC";
                }
                case 12292: {
                    return "EGL_BAD_ATTRIBUTE";
                }
                case 12293: {
                    return "EGL_BAD_CONFIG";
                }
                case 12294: {
                    return "EGL_BAD_CONTEXT";
                }
                case 12295: {
                    return "EGL_BAD_CURRENT_SURFACE";
                }
                case 12296: {
                    return "EGL_BAD_DISPLAY";
                }
                case 12297: {
                    return "EGL_BAD_MATCH";
                }
                case 12298: {
                    return "EGL_BAD_NATIVE_PIXMAP";
                }
                case 12299: {
                    return "EGL_BAD_NATIVE_WINDOW";
                }
                case 12300: {
                    return "EGL_BAD_PARAMETER";
                }
                case 12301: {
                    return "EGL_BAD_SURFACE";
                }
                case 12302: {
                    return "EGL_CONTEXT_LOST";
                }
            }
            return "0x" + Integer.toHexString(error).toUpperCase(Locale.US);
        }
    }

    private class ComponentSizeChooser
    extends BaseConfigChooser {
        private int[] mValue;
        protected int mRedSize;
        protected int mGreenSize;
        protected int mBlueSize;
        protected int mAlphaSize;
        protected int mDepthSize;
        protected int mStencilSize;

        public ComponentSizeChooser(int redSize, int greenSize, int blueSize, int alphaSize, int depthSize, int stencilSize) {
            super(new int[]{12324, redSize, 12323, greenSize, 12322, blueSize, 12321, alphaSize, 12325, depthSize, 12326, stencilSize, 12344});
            this.mValue = new int[1];
            this.mRedSize = redSize;
            this.mGreenSize = greenSize;
            this.mBlueSize = blueSize;
            this.mAlphaSize = alphaSize;
            this.mDepthSize = depthSize;
            this.mStencilSize = stencilSize;
        }

        @Override
        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            for (EGLConfig config : configs) {
                int d = this.findConfigAttrib(egl, display, config, 12325, 0);
                int s = this.findConfigAttrib(egl, display, config, 12326, 0);
                if (d < this.mDepthSize || s < this.mStencilSize) continue;
                int r = this.findConfigAttrib(egl, display, config, 12324, 0);
                int g = this.findConfigAttrib(egl, display, config, 12323, 0);
                int b = this.findConfigAttrib(egl, display, config, 12322, 0);
                int a = this.findConfigAttrib(egl, display, config, 12321, 0);
                if (r != this.mRedSize || g != this.mGreenSize || b != this.mBlueSize || a != this.mAlphaSize) continue;
                return config;
            }
            return null;
        }

        private int findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
            if (egl.eglGetConfigAttrib(display, config, attribute, this.mValue)) {
                return this.mValue[0];
            }
            return defaultValue;
        }
    }

    private abstract class BaseConfigChooser
    implements GLSurfaceView.EGLConfigChooser {
        protected int[] mConfigSpec;

        public BaseConfigChooser(int[] configSpec) {
            this.mConfigSpec = this.filterConfigSpec(configSpec);
        }

        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
            int[] num_config = new int[1];
            if (!egl.eglChooseConfig(display, this.mConfigSpec, null, 0, num_config)) {
                throw new IllegalArgumentException("eglChooseConfig failed");
            }
            int numConfigs = num_config[0];
            if (numConfigs <= 0) {
                throw new IllegalArgumentException("No configs match configSpec");
            }
            EGLConfig[] configs = new EGLConfig[numConfigs];
            if (!egl.eglChooseConfig(display, this.mConfigSpec, configs, numConfigs, num_config)) {
                throw new IllegalArgumentException("eglChooseConfig#2 failed");
            }
            EGLConfig config = this.chooseConfig(egl, display, configs);
            if (config == null) {
                throw new IllegalArgumentException("No config chosen");
            }
            return config;
        }

        abstract EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2, EGLConfig[] var3);

        private int[] filterConfigSpec(int[] configSpec) {
            if (TextureView.this.mEGLContextClientVersion != 2 && TextureView.this.mEGLContextClientVersion != 3) {
                return configSpec;
            }
            int len = configSpec.length;
            int[] newConfigSpec = new int[len + 2];
            System.arraycopy(configSpec, 0, newConfigSpec, 0, len - 1);
            newConfigSpec[len - 1] = 12352;
            newConfigSpec[len] = TextureView.this.mEGLContextClientVersion == 2 ? 4 : 64;
            newConfigSpec[len + 1] = 12344;
            return newConfigSpec;
        }
    }

    private static class DefaultWindowSurfaceFactory
    implements GLSurfaceView.EGLWindowSurfaceFactory {
        private DefaultWindowSurfaceFactory() {
        }

        public EGLSurface createWindowSurface(EGL10 egl, EGLDisplay display, EGLConfig config, Object nativeWindow) {
            EGLSurface result = null;
            try {
                result = egl.eglCreateWindowSurface(display, config, nativeWindow, null);
            }
            catch (IllegalArgumentException e) {
                Log.e((String)TextureView.TAG, (String)"eglCreateWindowSurface", (Throwable)e);
            }
            return result;
        }

        public void destroySurface(EGL10 egl, EGLDisplay display, EGLSurface surface) {
            egl.eglDestroySurface(display, surface);
        }
    }

    private class DefaultContextFactory
    implements GLSurfaceView.EGLContextFactory {
        private int EGL_CONTEXT_CLIENT_VERSION = 12440;

        private DefaultContextFactory() {
        }

        public EGLContext createContext(EGL10 egl, EGLDisplay display, EGLConfig config) {
            int[] attrib_list = new int[]{this.EGL_CONTEXT_CLIENT_VERSION, TextureView.this.mEGLContextClientVersion, 12344};
            return egl.eglCreateContext(display, config, EGL10.EGL_NO_CONTEXT, (int[])(TextureView.this.mEGLContextClientVersion != 0 ? attrib_list : null));
        }

        public void destroyContext(EGL10 egl, EGLDisplay display, EGLContext context) {
            if (!egl.eglDestroyContext(display, context)) {
                Log.e((String)"DefaultContextFactory", (String)("display:" + display + " context: " + context));
                EglHelper.throwEglException("eglDestroyContex", egl.eglGetError());
            }
        }
    }

    private static class RendererDelegate
    implements TextureView.SurfaceTextureListener {
        final TextureView mRajawaliTextureView;
        final ISurfaceRenderer mRenderer;

        public RendererDelegate(ISurfaceRenderer renderer, TextureView textureView) {
            this.mRenderer = renderer;
            this.mRajawaliTextureView = textureView;
            this.mRenderer.setFrameRate(this.mRajawaliTextureView.mRenderMode == 0 ? this.mRajawaliTextureView.mFrameRate : 0.0);
            this.mRenderer.setAntiAliasingMode(this.mRajawaliTextureView.mAntiAliasingConfig);
            this.mRenderer.setRenderSurface(this.mRajawaliTextureView);
            this.mRajawaliTextureView.setSurfaceTextureListener(this);
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
            this.mRajawaliTextureView.surfaceCreated(width, height);
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
            this.mRajawaliTextureView.surfaceChanged(width, height);
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            surface.release();
            this.mRajawaliTextureView.surfaceDestroyed();
            return false;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        }
    }
}

