/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.view.View;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import org.rajawali3d.R;
import org.rajawali3d.renderer.ISurfaceRenderer;
import org.rajawali3d.util.Capabilities;
import org.rajawali3d.util.egl.RajawaliEGLConfigChooser;
import org.rajawali3d.view.ISurface;

public class SurfaceView
extends GLSurfaceView
implements ISurface {
    protected RendererDelegate mRendererDelegate;
    protected double mFrameRate = 60.0;
    protected int mRenderMode = 0;
    protected ISurface.ANTI_ALIASING_CONFIG mAntiAliasingConfig = ISurface.ANTI_ALIASING_CONFIG.NONE;
    protected boolean mIsTransparent = false;
    protected int mBitsRed = 5;
    protected int mBitsGreen = 6;
    protected int mBitsBlue = 5;
    protected int mBitsAlpha = 0;
    protected int mBitsDepth = 16;
    protected int mMultiSampleCount = 0;

    public SurfaceView(Context context) {
        super(context);
    }

    public SurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.applyAttributes(context, attrs);
    }

    private void applyAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.SurfaceView);
        int count = array.getIndexCount();
        for (int i = 0; i < count; ++i) {
            int attr = array.getIndex(i);
            if (attr == R.styleable.SurfaceView_frameRate) {
                this.mFrameRate = array.getFloat(attr, 60.0f);
                continue;
            }
            if (attr == R.styleable.SurfaceView_renderMode) {
                this.mRenderMode = array.getInt(attr, 0);
                continue;
            }
            if (attr == R.styleable.SurfaceView_antiAliasingType) {
                this.mAntiAliasingConfig = ISurface.ANTI_ALIASING_CONFIG.fromInteger(array.getInteger(attr, ISurface.ANTI_ALIASING_CONFIG.NONE.ordinal()));
                continue;
            }
            if (attr == R.styleable.SurfaceView_multiSampleCount) {
                this.mMultiSampleCount = array.getInteger(attr, 0);
                continue;
            }
            if (attr == R.styleable.SurfaceView_isTransparent) {
                this.mIsTransparent = array.getBoolean(attr, false);
                continue;
            }
            if (attr == R.styleable.SurfaceView_bitsRed) {
                this.mBitsRed = array.getInteger(attr, 5);
                continue;
            }
            if (attr == R.styleable.SurfaceView_bitsGreen) {
                this.mBitsGreen = array.getInteger(attr, 6);
                continue;
            }
            if (attr == R.styleable.SurfaceView_bitsBlue) {
                this.mBitsBlue = array.getInteger(attr, 5);
                continue;
            }
            if (attr == R.styleable.SurfaceView_bitsAlpha) {
                this.mBitsAlpha = array.getInteger(attr, 0);
                continue;
            }
            if (attr != R.styleable.SurfaceView_bitsDepth) continue;
            this.mBitsDepth = array.getInteger(attr, 16);
        }
        array.recycle();
    }

    private void initialize() {
        int glesMajorVersion = Capabilities.getGLESMajorVersion();
        this.setEGLContextClientVersion(glesMajorVersion);
        if (this.mIsTransparent) {
            this.setEGLConfigChooser(new RajawaliEGLConfigChooser(glesMajorVersion, this.mAntiAliasingConfig, this.mMultiSampleCount, 8, 8, 8, 8, this.mBitsDepth));
            this.getHolder().setFormat(-3);
            this.setZOrderOnTop(true);
        } else {
            this.setEGLConfigChooser(new RajawaliEGLConfigChooser(glesMajorVersion, this.mAntiAliasingConfig, this.mMultiSampleCount, this.mBitsRed, this.mBitsGreen, this.mBitsBlue, this.mBitsAlpha, this.mBitsDepth));
            this.getHolder().setFormat(1);
            this.setZOrderOnTop(false);
        }
    }

    public void onPause() {
        super.onPause();
        if (this.mRendererDelegate != null) {
            this.mRendererDelegate.mRenderer.onPause();
        }
    }

    public void onResume() {
        super.onResume();
        if (this.mRendererDelegate != null) {
            this.mRendererDelegate.mRenderer.onResume();
        }
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        if (!this.isInEditMode()) {
            if (visibility == 8 || visibility == 4) {
                this.onPause();
            } else {
                this.onResume();
            }
        }
        super.onVisibilityChanged(changedView, visibility);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.onResume();
        }
    }

    protected void onDetachedFromWindow() {
        try {
            this.mRendererDelegate.mRenderer.onRenderSurfaceDestroyed(null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        super.onDetachedFromWindow();
    }

    @Override
    public void setFrameRate(double rate) {
        this.mFrameRate = rate;
        if (this.mRendererDelegate != null) {
            this.mRendererDelegate.mRenderer.setFrameRate(rate);
        }
    }

    @Override
    public int getRenderMode() {
        if (this.mRendererDelegate != null) {
            return super.getRenderMode();
        }
        return this.mRenderMode;
    }

    @Override
    public void setRenderMode(int mode) {
        this.mRenderMode = mode;
        if (this.mRendererDelegate != null) {
            super.setRenderMode(this.mRenderMode);
        }
    }

    public void setTransparent(boolean isTransparent) {
        this.mIsTransparent = isTransparent;
    }

    @Override
    public void setAntiAliasingMode(ISurface.ANTI_ALIASING_CONFIG config) {
        this.mAntiAliasingConfig = config;
    }

    @Override
    public void setSampleCount(int count) {
        this.mMultiSampleCount = count;
    }

    @Override
    public void setSurfaceRenderer(ISurfaceRenderer renderer) throws IllegalStateException {
        if (this.mRendererDelegate != null) {
            throw new IllegalStateException("A renderer has already been set for this view.");
        }
        this.initialize();
        RendererDelegate delegate = new RendererDelegate(renderer, this);
        super.setRenderer((GLSurfaceView.Renderer)delegate);
        this.mRendererDelegate = delegate;
        this.setRenderMode(this.mRenderMode);
        this.onPause();
    }

    @Override
    public void requestRenderUpdate() {
        this.requestRender();
    }

    private static class RendererDelegate
    implements GLSurfaceView.Renderer {
        final SurfaceView mRajawaliSurfaceView;
        final ISurfaceRenderer mRenderer;

        public RendererDelegate(ISurfaceRenderer renderer, SurfaceView surfaceView) {
            this.mRenderer = renderer;
            this.mRajawaliSurfaceView = surfaceView;
            this.mRenderer.setFrameRate(this.mRajawaliSurfaceView.mRenderMode == 0 ? this.mRajawaliSurfaceView.mFrameRate : 0.0);
            this.mRenderer.setAntiAliasingMode(this.mRajawaliSurfaceView.mAntiAliasingConfig);
            this.mRenderer.setRenderSurface(this.mRajawaliSurfaceView);
        }

        public void onSurfaceCreated(GL10 gl, EGLConfig config) {
            this.mRenderer.onRenderSurfaceCreated(config, gl, -1, -1);
        }

        public void onSurfaceChanged(GL10 gl, int width, int height) {
            this.mRenderer.onRenderSurfaceSizeChanged(gl, width, height);
        }

        public void onDrawFrame(GL10 gl) {
            this.mRenderer.onRenderFrame(gl);
        }
    }
}

