/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.service.dreams.DreamService;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import org.rajawali3d.renderer.ISurfaceRenderer;
import org.rajawali3d.util.Capabilities;
import org.rajawali3d.view.IDisplay;
import org.rajawali3d.view.ISurface;
import org.rajawali3d.view.SurfaceView;

@TargetApi(value=17)
public abstract class Daydream
extends DreamService
implements IDisplay {
    protected SurfaceView mSurfaceView;
    protected FrameLayout mLayout;
    private ISurfaceRenderer mRajawaliRenderer;

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mSurfaceView = new SurfaceView((Context)this);
        this.mSurfaceView.setEGLContextClientVersion(Capabilities.getGLESMajorVersion());
        this.setInteractive(false);
        this.setFullscreen(true);
        this.mLayout = new FrameLayout((Context)this);
        this.mLayout.addView((View)this.mSurfaceView);
        this.setContentView((View)this.mLayout);
        this.setRenderer(this.createRenderer());
    }

    public void onDreamingStarted() {
        super.onDreamingStarted();
        this.mSurfaceView.setRenderMode(0);
        this.mSurfaceView.onResume();
    }

    public void onDreamingStopped() {
        super.onDreamingStopped();
        this.mSurfaceView.onPause();
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mRajawaliRenderer.onRenderSurfaceDestroyed(null);
        this.unbindDrawables((View)this.mLayout);
        System.gc();
    }

    protected void setAntiAliasingConfig(ISurface.ANTI_ALIASING_CONFIG config) {
        this.mSurfaceView.setAntiAliasingMode(config);
    }

    protected void setRenderer(ISurfaceRenderer renderer) {
        this.mRajawaliRenderer = renderer;
        this.mSurfaceView.setSurfaceRenderer(this.mRajawaliRenderer);
    }

    private void unbindDrawables(View view) {
        if (view.getBackground() != null) {
            view.getBackground().setCallback(null);
        }
        if (view instanceof ViewGroup && !(view instanceof AdapterView)) {
            for (int i = 0; i < ((ViewGroup)view).getChildCount(); ++i) {
                this.unbindDrawables(((ViewGroup)view).getChildAt(i));
            }
            ((ViewGroup)view).removeAllViews();
        }
    }
}

