/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.util.egl;

import android.annotation.TargetApi;
import android.opengl.GLSurfaceView;
import android.support.annotation.NonNull;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLDisplay;
import org.rajawali3d.view.ISurface;

public class RajawaliEGLConfigChooser
implements GLSurfaceView.EGLConfigChooser {
    private static final int EGL_COVERAGE_BUFFERS_NV = 12512;
    private static final int EGL_COVERAGE_SAMPLES_NV = 12513;
    public static final int EGL_OPENGL_ES2_BIT = 4;
    public static final int EGL_OPENGL_ES3_BIT_KHR = 64;
    private final int[] mConfigSpec;
    private final ISurface.ANTI_ALIASING_CONFIG mAntiAliasingConfig;

    public RajawaliEGLConfigChooser(int glMajorVersion, @NonNull ISurface.ANTI_ALIASING_CONFIG antiAliasingConfig, int sampleCount, int bitsRed, int bitsGreen, int bitsBlue, int bitsAlpha, int bitsDepth) {
        this.mAntiAliasingConfig = antiAliasingConfig;
        this.mConfigSpec = this.mAntiAliasingConfig.equals((Object)ISurface.ANTI_ALIASING_CONFIG.MULTISAMPLING) ? new int[]{12324, bitsRed, 12323, bitsGreen, 12322, bitsBlue, 12321, bitsAlpha, 12325, bitsDepth, 12352, 4, 12338, antiAliasingConfig.equals((Object)ISurface.ANTI_ALIASING_CONFIG.MULTISAMPLING) ? 1 : 0, 12337, antiAliasingConfig.equals((Object)ISurface.ANTI_ALIASING_CONFIG.MULTISAMPLING) ? sampleCount : 0, 12344} : (this.mAntiAliasingConfig.equals((Object)ISurface.ANTI_ALIASING_CONFIG.COVERAGE) ? new int[]{12324, bitsRed, 12323, bitsGreen, 12322, bitsBlue, 12321, bitsAlpha, 12325, bitsDepth, 12352, 4, 12512, 1, 12513, 2, 12344} : new int[]{12324, bitsRed, 12323, bitsGreen, 12322, bitsBlue, 12321, bitsAlpha, 12325, bitsDepth, 12352, 4, 12344});
        if (glMajorVersion > 2) {
            this.makeConfigSpecES3();
        }
    }

    @TargetApi(value=18)
    private void makeConfigSpecES3() {
        this.mConfigSpec[11] = 64;
    }

    public ISurface.ANTI_ALIASING_CONFIG getAntiAliasingConfig() {
        return this.mAntiAliasingConfig;
    }

    public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
        EGLConfig config;
        int[] result = new int[1];
        if (!egl.eglChooseConfig(display, this.mConfigSpec, null, 0, result)) {
            throw new IllegalStateException("This device does not support the requested EGL Configuration!");
        }
        EGLConfig[] configs = new EGLConfig[result[0]];
        if (!egl.eglChooseConfig(display, this.mConfigSpec, configs, result[0], result)) {
            throw new RuntimeException("Couldn't create EGL configuration.");
        }
        int index = -1;
        int[] value = new int[1];
        for (int i = 0; i < configs.length; ++i) {
            egl.eglGetConfigAttrib(display, configs[i], 12324, value);
            if (value[0] != this.mConfigSpec[1]) continue;
            index = i;
            break;
        }
        EGLConfig eGLConfig = config = configs.length > 0 ? configs[index] : null;
        if (config == null) {
            throw new RuntimeException("No EGL configuration chosen");
        }
        return config;
    }
}

