/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.util;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.IntBuffer;

public class ScreenGrab {
    public static void saveAsImage(int width, int height, String path) throws FileNotFoundException {
        ScreenGrab.saveAsImage(0, 0, width, height, path, Bitmap.CompressFormat.PNG, 100);
    }

    public static void saveAsImage(int x, int y, int width, int height, String path, Bitmap.CompressFormat compressFormat, int quality) throws FileNotFoundException {
        Bitmap bmp = ScreenGrab.getPixelsFromBuffer(x, y, width, height);
        File file = new File(path);
        try {
            file.createNewFile();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        FileOutputStream fos = new FileOutputStream(file);
        bmp.compress(compressFormat, quality, (OutputStream)fos);
        try {
            fos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Bitmap getPixelsFromBuffer(int x, int y, int width, int height) {
        int[] b = new int[width * (y + height)];
        int[] bt = new int[width * height];
        IntBuffer ib = IntBuffer.wrap(b);
        ib.position(0);
        GLES20.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)6408, (int)5121, (Buffer)ib);
        int i = 0;
        int k = 0;
        while (i < height) {
            for (int j = 0; j < width; ++j) {
                int pix1;
                int pix = b[i * width + j];
                int pb = pix >> 16 & 0xFF;
                int pr = pix << 16 & 0xFF0000;
                bt[(height - k - 1) * width + j] = pix1 = pix & 0xFF00FF00 | pr | pb;
            }
            ++i;
            ++k;
        }
        return Bitmap.createBitmap((int[])bt, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }
}

