/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.util;

import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.util.IObjectPicker;
import org.rajawali3d.util.OnObjectPickedListener;
import org.rajawali3d.visitors.RayPickingVisitor;

public class RayPicker
implements IObjectPicker {
    private Renderer mRenderer;
    private OnObjectPickedListener mObjectPickedListener;

    public RayPicker(Renderer renderer) {
        this.mRenderer = renderer;
    }

    @Override
    public void setOnObjectPickedListener(OnObjectPickedListener objectPickedListener) {
        this.mObjectPickedListener = objectPickedListener;
    }

    @Override
    public void getObjectAt(float x, float y) {
        Vector3 pointNear = this.mRenderer.unProject(x, y, 0.0);
        Vector3 pointFar = this.mRenderer.unProject(x, y, 1.0);
        RayPickingVisitor visitor = new RayPickingVisitor(pointNear, pointFar);
        this.mObjectPickedListener.onObjectPicked(visitor.getPickedObject());
    }
}

