/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import org.rajawali3d.util.RajLog;

public final class RawShaderLoader {
    @SuppressLint(value={"UseSparseArrays"})
    private static final HashMap<Integer, String> mRawMaterials = new HashMap();
    public static WeakReference<Context> mContext;

    public static final String fetch(int resID) {
        if (mRawMaterials.containsKey(resID)) {
            return mRawMaterials.get(resID);
        }
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            Resources res = ((Context)mContext.get()).getResources();
            InputStreamReader isr = new InputStreamReader(res.openRawResource(resID));
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            mRawMaterials.put(resID, sb.toString());
            isr.close();
            br.close();
        }
        catch (Exception e) {
            RajLog.e("Failed to read material: " + e.getMessage());
            e.printStackTrace();
        }
        return mRawMaterials.get(resID);
    }
}

