/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.util;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.opengl.GLES20;
import android.os.Build;
import android.util.Log;
import org.rajawali3d.util.Capabilities;
import org.rajawali3d.util.GLU;

public final class RajLog {
    public static final String TAG = "Rajawali";
    private static boolean debugEnabled;

    public static void setDebugEnabled(boolean flag) {
        debugEnabled = flag;
    }

    public static boolean isDebugEnabled() {
        return debugEnabled;
    }

    public static void d(String msg) {
        if (debugEnabled) {
            Log.d((String)TAG, (String)msg);
        }
    }

    public static void e(String msg) {
        Log.e((String)TAG, (String)msg);
    }

    public static void i(String msg) {
        Log.i((String)TAG, (String)msg);
    }

    public static void v(String msg) {
        Log.v((String)TAG, (String)msg);
    }

    public static void w(String msg) {
        Log.w((String)TAG, (String)msg);
    }

    public static void checkGLError(String message) {
        int error = GLES20.glGetError();
        if (error > 0) {
            throw new RuntimeException("OpenGL Error: " + GLU.gluErrorString(error) + " " + error + " | " + message);
        }
    }

    public static void systemInformation() {
        StringBuffer sb = new StringBuffer();
        sb.append("-=-=-=- Device Information -=-=-=-\n");
        sb.append("Brand : ").append(Build.BRAND).append("\n");
        sb.append("Manufacturer : ").append(Build.MANUFACTURER).append("\n");
        sb.append("Model : ").append(Build.MODEL).append("\n");
        sb.append("Bootloader : ").append(Build.BOARD).append("\n");
        sb.append("CPU ABI : ").append(Build.CPU_ABI).append("\n");
        sb.append("CPU ABI 2 : ").append(Build.CPU_ABI2).append("\n");
        sb.append("-=-=-=- /Device Information -=-=-=-\n\n");
        sb.append("-=-=-=- OpenGL Information -=-=-=-\n");
        sb.append("Vendor : ").append(GLES20.glGetString((int)7936)).append("\n");
        sb.append("Renderer : ").append(GLES20.glGetString((int)7937)).append("\n");
        sb.append("Version : ").append(GLES20.glGetString((int)7938)).append("\n");
        String extensions = GLES20.glGetString((int)7939);
        String[] ext = extensions.split(" ");
        int extLength = ext.length;
        if (extLength > 0) {
            sb.append("Extensions : ").append('\n').append(ext[0]).append('\n');
            for (int i = 1; i < extLength; ++i) {
                sb.append(" : ").append(ext[i]).append('\n');
            }
        }
        sb.append("-=-=-=- /OpenGL Information -=-=-=-\n");
        sb.append(Capabilities.getInstance().toString());
        RajLog.i(sb.toString());
    }

    @TargetApi(value=16)
    public static void getDeviceMemoryCharacteristics(Context context) {
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        String memInfo = "-----------------------------------------\n";
        memInfo = memInfo + "Standard Heap per Application :  " + am.getMemoryClass() + "mb \n";
        memInfo = memInfo + "Large Heap per Application :  " + am.getLargeMemoryClass() + "mb \n";
        am.getMemoryInfo(mi);
        memInfo = memInfo + "Total Device Memory :  " + Math.round(mi.totalMem / 1024L / 1024L) + "mb \n";
        memInfo = memInfo + "Approximate Memory Available :  " + Math.round(mi.availMem / 1024L / 1024L) + "mb \n";
        memInfo = memInfo + "-----------------------------------------\n";
        RajLog.i(memInfo);
    }
}

