/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.util;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.rajawali3d.Object3D;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.MaterialManager;
import org.rajawali3d.materials.textures.ATexture;
import org.rajawali3d.renderer.RenderTarget;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.util.IObjectPicker;
import org.rajawali3d.util.OnObjectPickedListener;

public class ObjectColorPicker
implements IObjectPicker {
    private final List<Object3D> mObjectLookup = Collections.synchronizedList(new CopyOnWriteArrayList());
    private final Renderer mRenderer;
    private int mColorIndex = 0;
    private RenderTarget mRenderTarget;
    private Material mPickerMaterial;
    private OnObjectPickedListener mObjectPickedListener;

    public ObjectColorPicker(Renderer renderer) {
        this.mRenderer = renderer;
        this.mRenderer.initializeColorPicker(this);
    }

    public void initialize() {
        int size = Math.max(this.mRenderer.getViewportWidth(), this.mRenderer.getViewportHeight());
        this.mRenderTarget = new RenderTarget("colorPickerTarget", size, size, 0, 0, false, false, 3553, Bitmap.Config.ARGB_8888, ATexture.FilterType.LINEAR, ATexture.WrapType.CLAMP);
        this.mRenderer.addRenderTarget(this.mRenderTarget);
        this.mPickerMaterial = new Material();
        MaterialManager.getInstance().addMaterial(this.mPickerMaterial);
    }

    @Override
    public void setOnObjectPickedListener(OnObjectPickedListener objectPickedListener) {
        this.mObjectPickedListener = objectPickedListener;
    }

    public void registerObject(Object3D object) {
        if (!this.mObjectLookup.contains(object)) {
            this.mObjectLookup.add(object);
            object.setPickingColor(this.mColorIndex);
            ++this.mColorIndex;
        }
    }

    public void unregisterObject(Object3D object) {
        if (this.mObjectLookup.contains(object)) {
            int index = this.mObjectLookup.indexOf(object);
            this.mObjectLookup.set(index, null);
        }
        object.setPickingColor(-1);
    }

    @Override
    public void getObjectAt(float x, float y) {
        if (this.mObjectPickedListener != null) {
            this.mRenderer.getCurrentScene().requestColorPicking(new ColorPickerInfo(x, y, this));
        }
    }

    public RenderTarget getRenderTarget() {
        return this.mRenderTarget;
    }

    public static void pickObject(ColorPickerInfo pickerInfo) {
        ObjectColorPicker picker = pickerInfo.getPicker();
        OnObjectPickedListener listener = picker.mObjectPickedListener;
        if (listener != null) {
            Object3D pickedObject;
            ByteBuffer pixelBuffer = ByteBuffer.allocateDirect(4);
            pixelBuffer.order(ByteOrder.nativeOrder());
            GLES20.glReadPixels((int)pickerInfo.getX(), (int)(picker.mRenderer.getViewportHeight() - pickerInfo.getY()), (int)1, (int)1, (int)6408, (int)5121, (Buffer)pixelBuffer);
            GLES20.glBindFramebuffer((int)36160, (int)0);
            pixelBuffer.rewind();
            int r = pixelBuffer.get(0) & 0xFF;
            int g = pixelBuffer.get(1) & 0xFF;
            int b = pixelBuffer.get(2) & 0xFF;
            int a = pixelBuffer.get(3) & 0xFF;
            int index = Color.argb((int)a, (int)r, (int)g, (int)b);
            if (0 <= index && index < picker.mObjectLookup.size() && (pickedObject = picker.mObjectLookup.get(index)) != null) {
                listener.onObjectPicked(pickedObject);
                return;
            }
            listener.onNoObjectPicked();
        }
    }

    public Material getMaterial() {
        return this.mPickerMaterial;
    }

    public static final class ObjectColorPickerException
    extends Exception {
        private static final long serialVersionUID = 3732833696361901287L;

        public ObjectColorPickerException() {
        }

        public ObjectColorPickerException(String msg) {
            super(msg);
        }

        public ObjectColorPickerException(Throwable throwable) {
            super(throwable);
        }

        public ObjectColorPickerException(String msg, Throwable throwable) {
            super(msg, throwable);
        }
    }

    public class ColorPickerInfo {
        private final int mX;
        private final int mY;
        private final ObjectColorPicker mPicker;

        public ColorPickerInfo(float x, float y, ObjectColorPicker picker) {
            this.mX = (int)x;
            this.mY = (int)y;
            this.mPicker = picker;
        }

        public ObjectColorPicker getPicker() {
            return this.mPicker;
        }

        public int getX() {
            return this.mX;
        }

        public int getY() {
            return this.mY;
        }
    }
}

