/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.util;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LittleEndianDataInputStream
extends InputStream
implements DataInput {
    protected final DataInputStream d;
    protected final InputStream in;
    protected final byte[] w;
    protected long mPosition;

    public LittleEndianDataInputStream(InputStream in) {
        this.in = in;
        this.d = new DataInputStream(in);
        this.w = new byte[8];
    }

    @Override
    public int available() throws IOException {
        return this.d.available();
    }

    public long getPosition() {
        return this.mPosition;
    }

    @Override
    public final short readShort() throws IOException {
        this.mPosition += 2L;
        this.d.readFully(this.w, 0, 2);
        return (short)((this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF);
    }

    public String readString(int length) throws IOException {
        if (length == 0) {
            return null;
        }
        this.mPosition += (long)length;
        byte[] b = new byte[length];
        this.d.readFully(b);
        return new String(b, "US-ASCII");
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        this.mPosition += 2L;
        this.d.readFully(this.w, 0, 2);
        return (this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF;
    }

    @Override
    public final char readChar() throws IOException {
        this.mPosition += 2L;
        this.d.readFully(this.w, 0, 2);
        return (char)((this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF);
    }

    @Override
    public final int readInt() throws IOException {
        this.mPosition += 4L;
        this.d.readFully(this.w, 0, 4);
        return this.w[3] << 24 | (this.w[2] & 0xFF) << 16 | (this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF;
    }

    public final long readUnsignedInt() throws IOException {
        this.mPosition += 4L;
        this.d.readFully(this.w, 0, 4);
        return ((long)this.w[3] << 24 | (long)((this.w[2] & 0xFF) << 16) | (long)((this.w[1] & 0xFF) << 8) | (long)(this.w[0] & 0xFF)) & 0xFFFFFFFFL;
    }

    @Override
    public final long readLong() throws IOException {
        this.mPosition += 8L;
        this.d.readFully(this.w, 0, 8);
        return (long)this.w[7] << 56 | (long)(this.w[6] & 0xFF) << 48 | (long)(this.w[5] & 0xFF) << 40 | (long)(this.w[4] & 0xFF) << 32 | (long)(this.w[3] & 0xFF) << 24 | (long)(this.w[2] & 0xFF) << 16 | (long)(this.w[1] & 0xFF) << 8 | (long)(this.w[0] & 0xFF);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        this.mPosition += (long)len;
        return this.in.read(b, off, len);
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.mPosition += (long)b.length;
        this.d.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        this.mPosition += (long)len;
        this.d.readFully(b, off, len);
    }

    public final long skip(int n) throws IOException {
        this.mPosition += (long)n;
        return this.d.skip(n);
    }

    @Override
    public final long skip(long n) throws IOException {
        this.mPosition += n;
        return this.d.skip(n);
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        this.mPosition += (long)n;
        return this.d.skipBytes(n);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        ++this.mPosition;
        return this.d.readBoolean();
    }

    @Override
    public final byte readByte() throws IOException {
        ++this.mPosition;
        return this.d.readByte();
    }

    @Override
    public int read() throws IOException {
        ++this.mPosition;
        return this.in.read();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        ++this.mPosition;
        return this.d.readUnsignedByte();
    }

    @Override
    @Deprecated
    public final String readLine() throws IOException {
        String line = this.d.readLine();
        this.mPosition += (long)line.getBytes().length;
        return line;
    }

    @Override
    public final String readUTF() throws IOException {
        String line = this.d.readUTF();
        this.mPosition += (long)line.getBytes().length;
        return line;
    }

    @Override
    public final void close() throws IOException {
        this.d.close();
    }
}

