/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.util;

import org.rajawali3d.math.Plane;
import org.rajawali3d.math.vector.Vector3;

public final class Intersector {
    private static final Vector3 v0 = new Vector3();
    private static final Vector3 v1 = new Vector3();
    private static final Vector3 v2 = new Vector3();
    private static final Plane p = new Plane();
    private static final Vector3 i = new Vector3();

    public static boolean intersectRayPlane(Vector3 rayStart, Vector3 rayEnd, Plane plane, Vector3 hitPoint) {
        Vector3 rayDir = Vector3.subtractAndCreate(rayEnd, rayStart);
        double denorm = rayDir.dot(plane.getNormal());
        if (denorm != 0.0) {
            double t = -(rayStart.dot(plane.getNormal()) + plane.getD()) / denorm;
            if (t < 0.0) {
                return false;
            }
            if (hitPoint != null) {
                hitPoint.addAndSet(rayStart, Vector3.scaleAndCreate(rayDir, t));
            }
            return true;
        }
        if (plane.getPointSide(rayStart) == Plane.PlaneSide.ONPLANE) {
            if (hitPoint != null) {
                hitPoint.setAll(rayStart);
            }
            return true;
        }
        return false;
    }

    public static boolean intersectRayTriangle(Vector3 rayStart, Vector3 rayEnd, Vector3 t1, Vector3 t2, Vector3 t3, Vector3 hitPoint) {
        Vector3 rayDir = Vector3.subtractAndCreate(rayEnd, rayStart);
        rayDir.normalize();
        p.set(t1, t2, t3);
        if (!Intersector.intersectRayPlane(rayStart, rayEnd, p, i)) {
            return false;
        }
        v0.subtractAndSet(t3, t1);
        v1.subtractAndSet(t2, t1);
        v2.subtractAndSet(i, t1);
        double dot00 = v0.dot(v0);
        double dot01 = v0.dot(v1);
        double dot02 = v0.dot(v2);
        double dot11 = v1.dot(v1);
        double dot12 = v1.dot(v2);
        double denom = dot00 * dot11 - dot01 * dot01;
        if (denom == 0.0) {
            return false;
        }
        double u = (dot11 * dot02 - dot01 * dot12) / denom;
        double v = (dot00 * dot12 - dot01 * dot02) / denom;
        if (u >= 0.0 && v >= 0.0 && u + v <= 1.0) {
            if (hitPoint != null) {
                hitPoint.setAll(i);
            }
            return true;
        }
        return false;
    }

    public static boolean intersectRaySphere(Vector3 rayStart, Vector3 rayEnd, Vector3 sphereCenter, double sphereRadius, Vector3 hitPoint) {
        double t1;
        double c;
        rayStart = new Vector3(rayStart);
        rayEnd = new Vector3(rayEnd);
        Vector3 dir = Vector3.subtractAndCreate(rayEnd, rayStart);
        double len = dir.normalize();
        sphereCenter = new Vector3(sphereCenter);
        double radius2 = sphereRadius * sphereRadius;
        double a = Vector3.dot(dir, dir);
        double b = 2.0 * Vector3.dot(dir, Vector3.subtractAndCreate(rayStart, sphereCenter));
        double result = b * b - 4.0 * a * (c = Vector3.dot(sphereCenter, sphereCenter) + Vector3.dot(rayStart, rayStart) - 2.0 * Vector3.dot(sphereCenter, rayStart) - radius2);
        if (result < 0.0) {
            return false;
        }
        double distSqrt = Math.sqrt(result);
        double q = b < 0.0 ? (-b - distSqrt) / 2.0 : (-b + distSqrt) / 2.0;
        double t0 = q / 1.0;
        if (t0 > (t1 = c / q)) {
            double temp = t0;
            t0 = t1;
            t1 = temp;
        }
        if (t1 < 0.0) {
            return false;
        }
        if (t0 < 0.0) {
            hitPoint.setAll(rayStart.add(Vector3.scaleAndCreate(dir, t1 * len)));
            return true;
        }
        hitPoint.setAll(rayStart.add(Vector3.scaleAndCreate(dir, t0 * len)));
        return true;
    }
}

