/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.util;

import javax.microedition.khronos.opengles.GL10;
import org.rajawali3d.math.Matrix;
import org.rajawali3d.util.ArrayUtils;

public class GLU {
    private static final double[] sScratch = new double[32];
    private static final float[] sTempFloats = new float[32];

    public static String gluErrorString(int error) {
        switch (error) {
            case 0: {
                return "no error";
            }
            case 1280: {
                return "invalid enum";
            }
            case 1281: {
                return "invalid value";
            }
            case 1282: {
                return "invalid operation";
            }
            case 1283: {
                return "stack overflow";
            }
            case 1284: {
                return "stack underflow";
            }
            case 1285: {
                return "out of memory";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gluLookAt(GL10 gl, double eyeX, double eyeY, double eyeZ, double centerX, double centerY, double centerZ, double upX, double upY, double upZ) {
        double[] scratch;
        double[] dArray = scratch = sScratch;
        synchronized (scratch) {
            Matrix.setLookAtM(scratch, 0, eyeX, eyeY, eyeZ, centerX, centerY, centerZ, upX, upY, upZ);
            gl.glMultMatrixf(ArrayUtils.convertDoublesToFloats(scratch, sTempFloats), 0);
            // ** MonitorExit[var20_11] (shouldn't be in output)
            return;
        }
    }

    public static void gluOrtho2D(GL10 gl, double left, double right, double bottom, double top) {
        gl.glOrthof((float)left, (float)right, (float)bottom, (float)top, -1.0f, 1.0f);
    }

    public static void gluPerspective(GL10 gl, double fovy, double aspect, double zNear, double zFar) {
        double top = zNear * Math.tan(fovy * (Math.PI / 360));
        double bottom = -top;
        double left = bottom * aspect;
        double right = top * aspect;
        gl.glFrustumf((float)left, (float)right, (float)bottom, (float)top, (float)zNear, (float)zFar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int gluProject(double objX, double objY, double objZ, double[] model, int modelOffset, double[] project, int projectOffset, int[] view, int viewOffset, double[] win, int winOffset) {
        double[] scratch;
        double[] dArray = scratch = sScratch;
        synchronized (scratch) {
            boolean M_OFFSET = false;
            int V_OFFSET = 16;
            int V2_OFFSET = 20;
            Matrix.multiplyMM(scratch, 0, project, projectOffset, model, modelOffset);
            scratch[16] = objX;
            scratch[17] = objY;
            scratch[18] = objZ;
            scratch[19] = 1.0;
            Matrix.multiplyMV(scratch, 20, scratch, 0, scratch, 16);
            double w = scratch[23];
            if (w == 0.0) {
                // ** MonitorExit[var15_12] (shouldn't be in output)
                return 0;
            }
            double rw = 1.0 / w;
            win[winOffset] = (double)view[viewOffset] + (double)view[viewOffset + 2] * (scratch[20] * rw + 1.0) * 0.5;
            win[winOffset + 1] = (double)view[viewOffset + 1] + (double)view[viewOffset + 3] * (scratch[21] * rw + 1.0) * 0.5;
            win[winOffset + 2] = (scratch[22] * rw + 1.0) * 0.5;
            // ** MonitorExit[var15_12] (shouldn't be in output)
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int gluUnProject(double winX, double winY, double winZ, double[] model, int modelOffset, double[] project, int projectOffset, int[] view, int viewOffset, double[] obj, int objOffset) {
        double[] scratch;
        double[] dArray = scratch = sScratch;
        synchronized (scratch) {
            boolean PM_OFFSET = false;
            int INVPM_OFFSET = 16;
            boolean V_OFFSET = false;
            Matrix.multiplyMM(scratch, 0, project, projectOffset, model, modelOffset);
            if (!Matrix.invertM(scratch, 16, scratch, 0)) {
                // ** MonitorExit[var15_12] (shouldn't be in output)
                return 0;
            }
            scratch[0] = 2.0 * (winX - (double)view[viewOffset + 0]) / (double)view[viewOffset + 2] - 1.0;
            scratch[1] = 2.0 * (winY - (double)view[viewOffset + 1]) / (double)view[viewOffset + 3] - 1.0;
            scratch[2] = 2.0 * winZ - 1.0;
            scratch[3] = 1.0;
            Matrix.multiplyMV(obj, objOffset, scratch, 16, scratch, 0);
            // ** MonitorExit[var15_12] (shouldn't be in output)
            return 1;
        }
    }
}

