/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.util;

import android.annotation.TargetApi;
import android.opengl.GLES20;
import android.os.Build;
import android.support.annotation.NonNull;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import org.rajawali3d.util.RajLog;

public class Capabilities {
    private static Capabilities instance = null;
    private static volatile boolean sGLChecked = false;
    private static int mEGLMajorVersion;
    private static int mEGLMinorVersion;
    private static int mGLESMajorVersion;
    private int mMaxTextureSize;
    private int mMaxCombinedTextureImageUnits;
    private int mMaxCubeMapTextureSize;
    private int mMaxFragmentUniformVectors;
    private int mMaxRenderbufferSize;
    private int mMaxTextureImageUnits;
    private int mMaxVaryingVectors;
    private int mMaxVertexAttribs;
    private int mMaxVertexTextureImageUnits;
    private int mMaxVertexUniformVectors;
    private int mMaxViewportWidth;
    private int mMaxViewportHeight;
    private int mMinAliasedLineWidth;
    private int mMaxAliasedLineWidth;
    private int mMinAliasedPointSize;
    private int mMaxAliasedPointSize;
    private int[] mParam;
    private String mVendor = "";
    private String mRenderer = "";
    private String mVersion = "";
    private String[] mExtensions = new String[0];

    private Capabilities() {
        this.initialize();
    }

    @NonNull
    public static Capabilities getInstance() {
        if (instance == null) {
            instance = new Capabilities();
        }
        return instance;
    }

    private static void checkGLVersion() {
        int[] version;
        EGLDisplay display;
        EGL10 egl = (EGL10)EGLContext.getEGL();
        if (!egl.eglInitialize(display = egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY), version = new int[2])) {
            throw new IllegalStateException("Failed to initialize an EGL context while getting device capabilities.");
        }
        mEGLMajorVersion = version[0];
        mEGLMinorVersion = version[1];
        mGLESMajorVersion = 2;
        if (Build.VERSION.SDK_INT >= 18) {
            Capabilities.checkGLVersionIs3(egl, display);
        }
        egl.eglTerminate(display);
        sGLChecked = true;
    }

    @TargetApi(value=18)
    private static void checkGLVersionIs3(@NonNull EGL10 egl, EGLDisplay display) {
        int[] num_config = new int[1];
        egl.eglGetConfigs(display, null, 0, num_config);
        int configCount = num_config[0];
        EGLConfig[] configs = new EGLConfig[configCount];
        egl.eglGetConfigs(display, configs, configCount, num_config);
        int[] value = new int[1];
        for (EGLConfig config : configs) {
            egl.eglGetConfigAttrib(display, config, 12352, value);
            if ((value[0] & 0x40) == 0) continue;
            int[] configAttribs = new int[]{12324, 4, 12323, 4, 12322, 4, 12352, 64, 12344};
            value[0] = 0;
            egl.eglChooseConfig(display, configAttribs, configs, 1, value);
            mGLESMajorVersion = value[0] > 0 ? 3 : 2;
            break;
        }
    }

    private void initialize() {
        RajLog.d("Fetching device capabilities.");
        this.mParam = new int[1];
        this.mVendor = GLES20.glGetString((int)7936);
        this.mRenderer = GLES20.glGetString((int)7937);
        this.mVersion = GLES20.glGetString((int)7938);
        this.mMaxCombinedTextureImageUnits = this.getInt(35661);
        this.mMaxCubeMapTextureSize = this.getInt(34076);
        this.mMaxFragmentUniformVectors = this.getInt(36349);
        this.mMaxRenderbufferSize = this.getInt(34024);
        this.mMaxTextureImageUnits = this.getInt(34930);
        this.mMaxTextureSize = this.getInt(3379);
        this.mMaxVaryingVectors = this.getInt(36348);
        this.mMaxVertexAttribs = this.getInt(34921);
        this.mMaxVertexTextureImageUnits = this.getInt(35660);
        this.mMaxVertexUniformVectors = this.getInt(36347);
        this.mMaxViewportWidth = this.getInt(3386, 2, 0);
        this.mMaxViewportHeight = this.getInt(3386, 2, 1);
        this.mMinAliasedLineWidth = this.getInt(33902, 2, 0);
        this.mMaxAliasedLineWidth = this.getInt(33902, 2, 1);
        this.mMinAliasedPointSize = this.getInt(33901, 2, 0);
        this.mMaxAliasedPointSize = this.getInt(33901, 2, 1);
        String extensions = GLES20.glGetString((int)7939);
        this.mExtensions = extensions.split(" ");
    }

    private int getInt(int pname) {
        GLES20.glGetIntegerv((int)pname, (int[])this.mParam, (int)0);
        return this.mParam[0];
    }

    private int getInt(int pname, int length, int index) {
        int[] params = new int[length];
        GLES20.glGetIntegerv((int)pname, (int[])params, (int)0);
        return params[index];
    }

    public static int getEGLMajorVersion() {
        if (!sGLChecked) {
            Capabilities.checkGLVersion();
        }
        return mEGLMajorVersion;
    }

    public static int getEGLMinorVersion() {
        if (!sGLChecked) {
            Capabilities.checkGLVersion();
        }
        return mEGLMinorVersion;
    }

    public static int getGLESMajorVersion() {
        if (!sGLChecked) {
            Capabilities.checkGLVersion();
        }
        return mGLESMajorVersion;
    }

    @NonNull
    public String getVendor() {
        return this.mVendor;
    }

    @NonNull
    public String getRenderer() {
        return this.mRenderer;
    }

    @NonNull
    public String getVersion() {
        return this.mVersion;
    }

    @NonNull
    public String[] getExtensions() {
        return this.mExtensions;
    }

    public void verifyExtension(@NonNull String extension) throws UnsupportedCapabilityException {
        for (String ext : this.mExtensions) {
            if (!extension.equals(ext)) continue;
            return;
        }
        throw new UnsupportedCapabilityException("Extension (" + extension + ") is not supported!");
    }

    public int getMaxTextureSize() {
        return this.mMaxTextureSize;
    }

    public int getMaxCombinedTextureUnits() {
        return this.mMaxCombinedTextureImageUnits;
    }

    public int getMaxCubeMapTextureSize() {
        return this.mMaxCubeMapTextureSize;
    }

    public int getMaxFragmentUniformVectors() {
        return this.mMaxFragmentUniformVectors;
    }

    public int getMaxRenderbufferSize() {
        return this.mMaxRenderbufferSize;
    }

    public int getMaxTextureImageUnits() {
        return this.mMaxTextureImageUnits;
    }

    public int getMaxVaryingVectors() {
        return this.mMaxVaryingVectors;
    }

    public int getMaxVertexAttribs() {
        return this.mMaxVertexAttribs;
    }

    public int getMaxVertexTextureImageUnits() {
        return this.mMaxVertexTextureImageUnits;
    }

    public int getMaxVertexUniformVectors() {
        return this.mMaxVertexUniformVectors;
    }

    public int getMaxViewportWidth() {
        return this.mMaxViewportWidth;
    }

    public int getMaxViewportHeight() {
        return this.mMaxViewportHeight;
    }

    public int getMinAliasedLineWidth() {
        return this.mMinAliasedLineWidth;
    }

    public int getMaxAliasedLineWidth() {
        return this.mMaxAliasedLineWidth;
    }

    public int getMinAliasedPointSize() {
        return this.mMinAliasedPointSize;
    }

    public int getMaxAliasedPointSize() {
        return this.mMaxAliasedPointSize;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("-=-=-=- OpenGL Capabilities -=-=-=-\n");
        sb.append("Max Combined Texture Image Units   : ").append(this.mMaxCombinedTextureImageUnits).append("\n");
        sb.append("Max Cube Map Texture Size          : ").append(this.mMaxCubeMapTextureSize).append("\n");
        sb.append("Max Fragment Uniform Vectors       : ").append(this.mMaxFragmentUniformVectors).append("\n");
        sb.append("Max Renderbuffer Size              : ").append(this.mMaxRenderbufferSize).append("\n");
        sb.append("Max Texture Image Units            : ").append(this.mMaxTextureImageUnits).append("\n");
        sb.append("Max Texture Size                   : ").append(this.mMaxTextureSize).append("\n");
        sb.append("Max Varying Vectors                : ").append(this.mMaxVaryingVectors).append("\n");
        sb.append("Max Vertex Attribs                 : ").append(this.mMaxVertexAttribs).append("\n");
        sb.append("Max Vertex Texture Image Units     : ").append(this.mMaxVertexTextureImageUnits).append("\n");
        sb.append("Max Vertex Uniform Vectors         : ").append(this.mMaxVertexUniformVectors).append("\n");
        sb.append("Max Viewport Width                 : ").append(this.mMaxViewportWidth).append("\n");
        sb.append("Max Viewport Height                : ").append(this.mMaxViewportHeight).append("\n");
        sb.append("Min Aliased Line Width             : ").append(this.mMinAliasedLineWidth).append("\n");
        sb.append("Max Aliased Line Width             : ").append(this.mMaxAliasedLineWidth).append("\n");
        sb.append("Min Aliased Point Size             : ").append(this.mMinAliasedPointSize).append("\n");
        sb.append("Max Aliased Point Width            : ").append(this.mMaxAliasedPointSize).append("\n");
        sb.append("-=-=-=- /OpenGL Capabilities -=-=-=-\n");
        return sb.toString();
    }

    public static class UnsupportedCapabilityException
    extends Exception {
        public UnsupportedCapabilityException() {
        }

        public UnsupportedCapabilityException(String detailMessage) {
            super(detailMessage);
        }

        public UnsupportedCapabilityException(String detailMessage, Throwable throwable) {
            super(detailMessage, throwable);
        }

        public UnsupportedCapabilityException(Throwable throwable) {
            super(throwable);
        }
    }
}

