/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.util;

import java.nio.Buffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;

public class ArrayUtils {
    public static float[] convertDoublesToFloats(double[] input, float[] output) {
        if (input == null || output == null) {
            return output;
        }
        for (int i = 0; i < input.length; ++i) {
            output[i] = (float)input[i];
        }
        return output;
    }

    public static float[] convertDoublesToFloats(double[] input) {
        if (input == null) {
            return null;
        }
        float[] output = new float[input.length];
        for (int i = 0; i < input.length; ++i) {
            output[i] = (float)input[i];
        }
        return output;
    }

    public static double[] convertFloatsToDoubles(float[] input, double[] output) {
        if (input == null || output == null) {
            return output;
        }
        for (int i = 0; i < input.length; ++i) {
            output[i] = input[i];
        }
        return output;
    }

    public static double[] convertFloatsToDoubles(float[] input) {
        if (input == null) {
            return null;
        }
        double[] output = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            output[i] = input[i];
        }
        return output;
    }

    public static double[] concatAllDouble(double[] ... arrays) {
        int totalLength = 0;
        int subArrayCount = arrays.length;
        for (int i = 0; i < subArrayCount; ++i) {
            totalLength += arrays[i].length;
        }
        double[] result = Arrays.copyOf(arrays[0], totalLength);
        int offset = arrays[0].length;
        for (int i = 1; i < subArrayCount; ++i) {
            System.arraycopy(arrays[i], 0, result, offset, arrays[i].length);
            offset += arrays[i].length;
        }
        return result;
    }

    public static float[] concatAllFloat(float[] ... arrays) {
        int totalLength = 0;
        int subArrayCount = arrays.length;
        for (int i = 0; i < subArrayCount; ++i) {
            totalLength += arrays[i].length;
        }
        float[] result = Arrays.copyOf(arrays[0], totalLength);
        int offset = arrays[0].length;
        for (int i = 1; i < subArrayCount; ++i) {
            System.arraycopy(arrays[i], 0, result, offset, arrays[i].length);
            offset += arrays[i].length;
        }
        return result;
    }

    public static int[] concatAllInt(int[] ... arrays) {
        int totalLength = 0;
        int subArrayCount = arrays.length;
        for (int i = 0; i < subArrayCount; ++i) {
            totalLength += arrays[i].length;
        }
        int[] result = Arrays.copyOf(arrays[0], totalLength);
        int offset = arrays[0].length;
        for (int i = 1; i < subArrayCount; ++i) {
            System.arraycopy(arrays[i], 0, result, offset, arrays[i].length);
            offset += arrays[i].length;
        }
        return result;
    }

    public static double[] getDoubleArrayFromBuffer(DoubleBuffer buffer) {
        double[] array = null;
        if (buffer.hasArray()) {
            array = buffer.array();
        } else {
            buffer.rewind();
            array = new double[buffer.capacity()];
            buffer.get(array);
        }
        return array;
    }

    public static float[] getFloatArrayFromBuffer(FloatBuffer buffer) {
        float[] array = null;
        if (buffer.hasArray()) {
            array = buffer.array();
        } else {
            buffer.rewind();
            array = new float[buffer.capacity()];
            buffer.get(array);
        }
        return array;
    }

    public static int[] getIntArrayFromBuffer(Buffer buffer) {
        int[] array = null;
        if (buffer.hasArray()) {
            array = (int[])buffer.array();
        } else {
            buffer.rewind();
            array = new int[buffer.capacity()];
            if (buffer instanceof IntBuffer) {
                ((IntBuffer)buffer).get(array);
            } else if (buffer instanceof ShortBuffer) {
                int count = 0;
                while (buffer.hasRemaining()) {
                    array[count] = ((ShortBuffer)buffer).get();
                    ++count;
                }
            }
        }
        return array;
    }
}

