/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.terrain;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.terrain.SquareTerrain;

public class TerrainGenerator {
    public static SquareTerrain createSquareTerrainFromBitmap(SquareTerrain.Parameters prs, boolean createVBOs) {
        int j;
        int i;
        double temp;
        double max;
        int divisions = prs.divisions;
        if (prs.divisions == 0 || (prs.divisions & prs.divisions - 1) != 0) {
            throw new RuntimeException("Divisions must be x^2");
        }
        double[][] terrain = new double[divisions + 1][divisions + 1];
        double[][] temperature = new double[divisions + 1][divisions + 1];
        Vector3[][] normals = new Vector3[divisions + 1][divisions + 1];
        boolean useColorBitmap = prs.colorMapBitmap != null;
        int[] colorpixels = null;
        Bitmap bnew = Bitmap.createBitmap((int)(divisions + 1), (int)(divisions + 1), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas cnv = new Canvas(bnew);
        cnv.drawBitmap(prs.heightMapBitmap, new Rect(0, 0, prs.heightMapBitmap.getWidth(), prs.heightMapBitmap.getHeight()), new Rect(0, 0, divisions + 1, divisions + 1), null);
        int[] pixels = new int[(divisions + 1) * (divisions + 1)];
        bnew.getPixels(pixels, 0, divisions + 1, 0, 0, divisions + 1, divisions + 1);
        if (useColorBitmap) {
            colorpixels = new int[(divisions + 1) * (divisions + 1)];
            Paint clearPaint = new Paint();
            clearPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
            cnv.drawRect(0.0f, 0.0f, (float)prs.colorMapBitmap.getWidth(), (float)prs.colorMapBitmap.getHeight(), clearPaint);
            cnv.drawBitmap(prs.colorMapBitmap, new Rect(0, 0, prs.colorMapBitmap.getWidth(), prs.colorMapBitmap.getHeight()), new Rect(0, 0, divisions + 1, divisions + 1), null);
            bnew.getPixels(colorpixels, 0, divisions + 1, 0, 0, divisions + 1, divisions + 1);
        }
        bnew.recycle();
        int cols = divisions + 1;
        terrain[0][0] = (double)((float)Color.green((int)0) / 255.0f) * prs.scale.y;
        double min = max = terrain[0][0];
        float oneover255 = 0.003921569f;
        for (int i2 = 0; i2 <= divisions; ++i2) {
            for (int j2 = 0; j2 <= divisions; ++j2) {
                int color = pixels[i2 + j2 * cols];
                double alt = (double)((float)Color.green((int)color) * oneover255) * prs.scale.y;
                temp = (double)((float)Color.red((int)color) * oneover255) * (prs.maxTemp - prs.minTemp) + prs.minTemp;
                if (i2 > 0 && j2 > 0) {
                    temp = ((temperature[i2 - 1][j2] + temperature[i2][j2 - 1]) * 0.5 + temp) * 0.5;
                    alt = ((terrain[i2 - 1][j2] + terrain[i2][j2 - 1]) * 0.5 + alt) * 0.5;
                } else if (j2 > 0) {
                    temp = (temperature[i2][j2 - 1] + temp) * 0.5;
                    alt = (terrain[i2][j2 - 1] + alt) * 0.5;
                } else if (i2 > 0) {
                    temp = (temperature[i2 - 1][j2] + temp) * 0.5;
                    alt = (terrain[i2 - 1][j2] + alt) * 0.5;
                }
                temperature[i2][j2] = temp;
                terrain[i2][j2] = alt;
                if (alt < min) {
                    min = alt;
                } else if (alt > max) {
                    max = alt;
                }
                normals[i2][j2] = new Vector3(0.0, 1.0, 0.0);
            }
        }
        Vector3 scale = prs.scale;
        Vector3 v0 = new Vector3();
        Vector3 v1 = new Vector3();
        Vector3 v2 = new Vector3();
        Vector3 na = new Vector3();
        Vector3 nb = new Vector3();
        Vector3 nc = new Vector3();
        Vector3 nd = new Vector3();
        for (int x = 1; x < divisions; ++x) {
            for (int z = 1; z < divisions; ++z) {
                v0.x = (double)(x - 1) * scale.x;
                v0.z = (double)z * scale.z;
                v0.y = terrain[x - 1][z];
                v1.x = (double)x * scale.x;
                v1.z = (double)(z - 1) * scale.z;
                v1.y = terrain[x][z - 1];
                v2.x = (double)x * scale.x;
                v2.z = (double)z * scale.z;
                v2.y = terrain[x][z];
                na = v1.subtract(v0).cross(v2.subtract(v0));
                v0.x = (double)x * scale.x;
                v0.z = (double)z * scale.z;
                v0.y = terrain[x][z];
                v1.x = (double)x * scale.x;
                v1.z = (double)(z - 1) * scale.z;
                v1.y = terrain[x][z - 1];
                v2.x = (double)(x + 1) * scale.x;
                v2.z = (double)z * scale.z;
                v2.y = terrain[x + 1][z];
                nb = v1.subtract(v0).cross(v2.subtract(v0));
                v0.x = (double)x * scale.x;
                v0.z = (double)z * scale.z;
                v0.y = terrain[x][z];
                v1.x = (double)(x + 1) * scale.x;
                v1.z = (double)z * scale.z;
                v1.y = terrain[x + 1][z];
                v2.x = (double)x * scale.x;
                v2.z = (double)(z + 1) * scale.z;
                v2.y = terrain[x][z + 1];
                nc = v1.subtract(v0).cross(v2.subtract(v0));
                v0.x = (double)x * scale.x;
                v0.z = (double)z * scale.z;
                v0.y = terrain[x][z];
                v1.x = (double)x * scale.x;
                v1.z = (double)(z + 1) * scale.z;
                v1.y = terrain[x][z + 1];
                v2.x = (double)(x - 1) * scale.x;
                v2.z = (double)z * scale.z;
                v2.y = terrain[x - 1][z];
                nd = v1.subtract(v0).cross(v2.subtract(v0));
                normals[x][z].y = 0.0;
                normals[x][z].add(na);
                normals[x][z].add(nb);
                normals[x][z].add(nc);
                normals[x][z].add(nd);
            }
        }
        SquareTerrain sq = new SquareTerrain(divisions, terrain, normals, temperature, scale.x, scale.z);
        float[] vertices = new float[(divisions + 1) * (divisions + 1) * 3];
        float[] nors = new float[(divisions + 1) * (divisions + 1) * 3];
        float[] colors = new float[(divisions + 1) * (divisions + 1) * 4];
        float[] textureCoords = new float[(divisions + 1) * (divisions + 1) * 2];
        int[] indices = new int[divisions * divisions * 6];
        int ii = 0;
        int nn = 0;
        int tt = 0;
        int xx = 0;
        int cc = 0;
        double maxtt = 1.0f / (float)(divisions + 1);
        double xmid = (double)divisions * scale.x / 2.0;
        double zmid = (double)divisions * scale.z / 2.0;
        double percalt = 0.0;
        float a = 1.0f;
        float a_basecolor = (float)Color.alpha((int)prs.basecolor) * oneover255;
        float a_middlecolor = (float)Color.alpha((int)prs.middlecolor) * oneover255;
        float a_upcolor = (float)Color.alpha((int)prs.upcolor) * oneover255;
        float g_basecolor = (float)Color.green((int)prs.basecolor) * oneover255;
        float g_middlecolor = (float)Color.green((int)prs.middlecolor) * oneover255;
        float g_upcolor = (float)Color.green((int)prs.upcolor) * oneover255;
        float b_basecolor = (float)Color.blue((int)prs.basecolor) * oneover255;
        float b_middlecolor = (float)Color.blue((int)prs.middlecolor) * oneover255;
        float b_upcolor = (float)Color.blue((int)prs.upcolor) * oneover255;
        float r_basecolor = (float)Color.red((int)prs.basecolor) * oneover255;
        float r_middlecolor = (float)Color.red((int)prs.middlecolor) * oneover255;
        float r_upcolor = (float)Color.red((int)prs.upcolor) * oneover255;
        for (i = 0; i <= divisions; ++i) {
            for (j = 0; j <= divisions; ++j) {
                float b;
                float g;
                float r;
                vertices[ii++] = (float)((double)i * scale.x - xmid);
                vertices[ii++] = (float)terrain[i][j];
                vertices[ii++] = (float)((double)j * scale.z - zmid);
                percalt = sq.getPercAltitude(i, j);
                if (percalt < 0.5) {
                    temp = (percalt - 0.0) * 2.0;
                    r = (float)((double)r_basecolor + (double)(r_middlecolor - r_basecolor) * temp);
                    g = (float)((double)g_basecolor + (double)(g_middlecolor - g_basecolor) * temp);
                    b = (float)((double)b_basecolor + (double)(b_middlecolor - b_basecolor) * temp);
                    a = (float)((double)a_basecolor + (double)(a_middlecolor - a_basecolor) * temp);
                } else {
                    temp = (percalt - 0.5) * 2.0;
                    r = (float)((double)r_middlecolor + (double)(r_upcolor - r_middlecolor) * temp);
                    g = (float)((double)g_middlecolor + (double)(g_upcolor - g_middlecolor) * temp);
                    b = (float)((double)b_middlecolor + (double)(b_upcolor - b_middlecolor) * temp);
                    a = (float)((double)a_middlecolor + (double)(a_upcolor - a_middlecolor) * temp);
                }
                if (useColorBitmap) {
                    int bmpcolor = colorpixels[i + j * cols];
                    float a_bmp = (float)Color.alpha((int)bmpcolor) * oneover255;
                    float r_bmp = (float)Color.red((int)bmpcolor) * oneover255;
                    float g_bmp = (float)Color.green((int)bmpcolor) * oneover255;
                    float b_bmp = (float)Color.blue((int)bmpcolor) * oneover255;
                    r = r * (1.0f - a_bmp) + a_bmp * r_bmp;
                    g = g * (1.0f - a_bmp) + a_bmp * g_bmp;
                    b = b * (1.0f - a_bmp) + a_bmp * b_bmp;
                }
                r = r < 0.0f ? 0.0f : r;
                r = r > 1.0f ? 1.0f : r;
                g = g < 0.0f ? 0.0f : g;
                g = g > 1.0f ? 1.0f : g;
                b = b < 0.0f ? 0.0f : b;
                b = b > 1.0f ? 1.0f : b;
                a = a < 0.0f ? 0.0f : a;
                a = a > 1.0f ? 1.0f : a;
                colors[cc++] = r;
                colors[cc++] = g;
                colors[cc++] = b;
                colors[cc++] = a;
                normals[i][j].normalize();
                nors[nn++] = (float)normals[i][j].x;
                nors[nn++] = (float)normals[i][j].y;
                nors[nn++] = (float)normals[i][j].z;
                textureCoords[tt++] = (float)((double)i * maxtt * prs.textureMult);
                textureCoords[tt++] = (float)((double)j * maxtt * prs.textureMult);
            }
        }
        for (i = 0; i < divisions; i += 2) {
            for (j = 0; j < divisions; j += 2) {
                indices[xx++] = i + j * cols;
                indices[xx++] = i + 1 + j * cols;
                indices[xx++] = i + (j + 1) * cols;
                indices[xx++] = i + 1 + j * cols;
                indices[xx++] = i + 1 + (j + 1) * cols;
                indices[xx++] = i + (j + 1) * cols;
                indices[xx++] = i + 1 + j * cols;
                indices[xx++] = i + 2 + (j + 1) * cols;
                indices[xx++] = i + 1 + (j + 1) * cols;
                indices[xx++] = i + 1 + j * cols;
                indices[xx++] = i + 2 + j * cols;
                indices[xx++] = i + 2 + (j + 1) * cols;
                indices[xx++] = i + (j + 1) * cols;
                indices[xx++] = i + 1 + (j + 2) * cols;
                indices[xx++] = i + (j + 2) * cols;
                indices[xx++] = i + (j + 1) * cols;
                indices[xx++] = i + 1 + (j + 1) * cols;
                indices[xx++] = i + 1 + (j + 2) * cols;
                indices[xx++] = i + 1 + (j + 1) * cols;
                indices[xx++] = i + 2 + (j + 1) * cols;
                indices[xx++] = i + 1 + (j + 2) * cols;
                indices[xx++] = i + 2 + (j + 1) * cols;
                indices[xx++] = i + 2 + (j + 2) * cols;
                indices[xx++] = i + 1 + (j + 2) * cols;
            }
        }
        sq.setData(vertices, nors, textureCoords, colors, indices, createVBOs);
        nors = null;
        colors = null;
        indices = null;
        textureCoords = null;
        vertices = null;
        return sq;
    }
}

