/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.terrain;

import android.graphics.Bitmap;
import org.rajawali3d.ATransformable3D;
import org.rajawali3d.math.Plane;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.primitives.Sphere;
import org.rajawali3d.terrain.Terrain;

public class SquareTerrain
extends Terrain {
    private static final boolean debug = false;
    private double[][] mTerrain;
    private double[][] mTemperature;
    private Vector3[][] mNormals;
    private int mDivisions;
    private double mXScale;
    private double mZScale;
    private double mOneOverXScale;
    private double mOneOverZScale;
    private double mMinH;
    private double mMaxH;
    private double mMinT;
    private double mMaxT;
    private Sphere mV0;
    private Sphere mV1;
    private Sphere mV2;
    private Sphere mNor;
    private Sphere mNorBase;
    private Plane mTmpPlane = new Plane();
    private Vector3 mTmpV0 = new Vector3();
    private Vector3 mTmpV1 = new Vector3();
    private Vector3 mTmpV2 = new Vector3();
    private Vector3 mTmpS = new Vector3();
    private Plane mTmpNorPlane = new Plane();
    private Vector3 mTmpNorV0 = new Vector3();
    private Vector3 mTmpNorV1 = new Vector3();
    private Vector3 mTmpNorV2 = new Vector3();
    private Vector3 mTmpNorS = new Vector3();

    public static Parameters createParameters(Bitmap hMapBitmap) {
        return new Parameters(hMapBitmap);
    }

    protected SquareTerrain(int divisions, double[][] terrain, Vector3[][] normals, double[][] temperature, double xScale, double zScale) {
        this.mDivisions = divisions;
        this.mTerrain = terrain;
        this.mTemperature = temperature;
        this.mNormals = normals;
        this.mXScale = xScale;
        this.mZScale = zScale;
        this.mOneOverXScale = 1.0 / xScale;
        this.mOneOverZScale = 1.0 / zScale;
        for (int i = 0; i <= divisions; ++i) {
            for (int j = 0; j <= divisions; ++j) {
                if (terrain[i][j] < this.mMinH) {
                    this.mMinH = terrain[i][j];
                } else if (terrain[i][j] > this.mMaxH) {
                    this.mMaxH = terrain[i][j];
                }
                if (temperature[i][j] < this.mMinT) {
                    this.mMinT = temperature[i][j];
                    continue;
                }
                if (!(temperature[i][j] > this.mMaxT)) continue;
                this.mMaxT = temperature[i][j];
            }
        }
    }

    public int getDivisions() {
        return this.mDivisions;
    }

    public double getExtensionX() {
        return (double)this.mDivisions * this.mXScale;
    }

    public double getExtensionZ() {
        return (double)this.mDivisions * this.mZScale;
    }

    public double getMinAltitude() {
        return this.mMinH;
    }

    public double getMaxAltitude() {
        return this.mMaxH;
    }

    public double[][] getHeights() {
        return this.mTerrain;
    }

    public double getMinTemperature() {
        return this.mMinT;
    }

    public double getMaxTemperature() {
        return this.mMaxT;
    }

    public boolean contains(double x, double z) {
        double xx = (x - this.mPosition.x) * this.mOneOverXScale + (double)this.mDivisions * 0.5;
        double zz = (z - this.mPosition.z) * this.mOneOverZScale + (double)this.mDivisions * 0.5;
        return xx >= 0.0 && zz >= 0.0 && xx < (double)this.mDivisions && zz < (double)this.mDivisions;
    }

    public double getPercAltitude(int i, int j) {
        double alt = this.mTerrain[i][j];
        return (alt - this.mMinH) / (this.mMaxH - this.mMinH);
    }

    public double getAltitude(double x, double z) {
        return this.getInterpolateValue(this.mTerrain, x, z) + this.mPosition.y;
    }

    private synchronized double getInterpolateValue(double[][] matrix, double x, double z) {
        double alt;
        double xx = (x - this.mPosition.x) * this.mOneOverXScale + (double)this.mDivisions * 0.5;
        double zz = (z - this.mPosition.z) * this.mOneOverZScale + (double)this.mDivisions * 0.5;
        double fx = Math.floor(xx);
        double fz = Math.floor(zz);
        int i = (int)fx;
        int j = (int)fz;
        if (i < 0) {
            i = 0;
            fx = i;
        } else if (i > this.mDivisions - 1) {
            i = this.mDivisions - 1;
            fx = this.mDivisions - 1;
        }
        if (j < 0) {
            j = 0;
            fz = 0.0;
        } else if (j > this.mDivisions - 1) {
            j = this.mDivisions - 1;
            fz = this.mDivisions - 1;
        }
        int flagcase = 0;
        if (i % 2 == 0) {
            if (j % 2 == 0) {
                this.mTmpV0.setAll(fx + 1.0, matrix[i + 1][j], fz);
                this.mTmpV1.setAll(fx, matrix[i][j + 1], fz + 1.0);
            } else {
                this.mTmpV0.setAll(fx, matrix[i][--j + 1], (fz -= 1.0) + 1.0);
                this.mTmpV1.setAll(fx + 1.0, matrix[i + 1][j + 2], fz + 2.0);
                flagcase = 1;
            }
        } else {
            --i;
            fx -= 1.0;
            if (j % 2 == 0) {
                this.mTmpV0.setAll(fx + 1.0, matrix[i + 1][j], fz);
                this.mTmpV1.setAll(fx + 2.0, matrix[i + 2][j + 1], fz + 1.0);
                flagcase = 2;
            } else {
                this.mTmpV0.setAll(fx + 2.0, matrix[i + 2][--j + 1], (fz -= 1.0) + 1.0);
                this.mTmpV1.setAll(fx + 1.0, matrix[i + 1][j + 2], fz + 2.0);
                flagcase = 3;
            }
        }
        this.mTmpV2.setAll(fx + 1.0, 0.0, fz + 1.0);
        this.mTmpS.setAll(xx, 0.0, zz);
        boolean useTriInt = this.intpoint_inside_trigon(this.mTmpS, this.mTmpV0, this.mTmpV1, this.mTmpV2);
        if (useTriInt) {
            switch (flagcase) {
                case 0: {
                    this.mTmpV2.setAll(fx + 1.0, matrix[i + 1][j + 1], fz + 1.0);
                    break;
                }
                case 1: {
                    this.mTmpV2.setAll(fx + 1.0, matrix[i + 1][j + 1], fz + 1.0);
                    break;
                }
                case 2: {
                    this.mTmpV2.setAll(fx + 1.0, matrix[i + 1][j + 1], fz + 1.0);
                    break;
                }
                case 3: {
                    this.mTmpV2.setAll(fx + 1.0, matrix[i + 1][j + 1], fz + 1.0);
                }
            }
        } else {
            switch (flagcase) {
                case 0: {
                    this.mTmpV2.setAll(fx, matrix[i][j], fz);
                    break;
                }
                case 1: {
                    this.mTmpV2.setAll(fx, matrix[i][j + 2], fz + 2.0);
                    break;
                }
                case 2: {
                    this.mTmpV2.setAll(fx + 2.0, matrix[i + 2][j], fz);
                    break;
                }
                case 3: {
                    this.mTmpV2.setAll(fx + 2.0, matrix[i + 2][j + 2], fz + 2.0);
                }
            }
        }
        this.mTmpPlane.set(this.mTmpV0, this.mTmpV1, this.mTmpV2);
        if (Math.abs(this.mTmpPlane.getNormal().y) < 1.0E-5) {
            alt = Math.min(this.mTmpV1.y, this.mTmpV0.y);
            alt = Math.min(alt, this.mTmpV2.y);
        } else {
            alt = (-this.mTmpPlane.getNormal().x * xx - this.mTmpPlane.getNormal().z * zz - this.mTmpPlane.getD()) / this.mTmpPlane.getNormal().y;
        }
        return alt;
    }

    private boolean intpoint_inside_trigon(Vector3 s, Vector3 a, Vector3 b, Vector3 c) {
        boolean s_ab;
        double as_x;
        double as_y;
        if ((c.x - a.x) * as_y - (c.z - a.z) * as_x > 0.0 == (s_ab = (b.x - a.x) * (as_y = s.z - a.z) - (b.z - a.z) * (as_x = s.x - a.x) > 0.0)) {
            return false;
        }
        return (c.x - b.x) * (s.z - b.z) - (c.z - b.z) * (s.x - b.x) > 0.0 == s_ab;
    }

    public synchronized void getNormalAt(double x, double z, Vector3 normal) {
        double xx = (x - this.mPosition.x) * this.mOneOverXScale + (double)this.mDivisions * 0.5;
        double zz = (z - this.mPosition.z) * this.mOneOverZScale + (double)this.mDivisions * 0.5;
        double fx = Math.floor(xx);
        double fz = Math.floor(zz);
        int i = (int)fx;
        int j = (int)fz;
        if (i < 0) {
            i = 0;
            fx = i;
        } else if (i > this.mDivisions - 1) {
            i = this.mDivisions - 1;
            fx = this.mDivisions - 1;
        }
        if (j < 0) {
            j = 0;
            fz = 0.0;
        } else if (j > this.mDivisions - 1) {
            j = this.mDivisions - 1;
            fz = this.mDivisions - 1;
        }
        int flagcase = 0;
        if (i % 2 == 0) {
            if (j % 2 == 0) {
                this.mTmpNorV0.setAll(fx + 1.0, this.mTerrain[i + 1][j], fz);
                this.mTmpNorV1.setAll(fx, this.mTerrain[i][j + 1], fz + 1.0);
            } else {
                this.mTmpNorV0.setAll(fx, this.mTerrain[i][--j + 1], (fz -= 1.0) + 1.0);
                this.mTmpNorV1.setAll(fx + 1.0, this.mTerrain[i + 1][j + 2], fz + 2.0);
                flagcase = 1;
            }
        } else {
            --i;
            fx -= 1.0;
            if (j % 2 == 0) {
                this.mTmpNorV0.setAll(fx + 1.0, this.mTerrain[i + 1][j], fz);
                this.mTmpNorV1.setAll(fx + 2.0, this.mTerrain[i + 2][j + 1], fz + 1.0);
                flagcase = 2;
            } else {
                this.mTmpNorV0.setAll(fx + 2.0, this.mTerrain[i + 2][--j + 1], (fz -= 1.0) + 1.0);
                this.mTmpNorV1.setAll(fx + 1.0, this.mTerrain[i + 1][j + 2], fz + 2.0);
                flagcase = 3;
            }
        }
        this.mTmpNorV2.setAll(fx + 1.0, 0.0, fz + 1.0);
        this.mTmpNorS.setAll(xx, 0.0, zz);
        boolean useTriInt = this.intpoint_inside_trigon(this.mTmpNorS, this.mTmpNorV0, this.mTmpNorV1, this.mTmpNorV2);
        if (useTriInt) {
            switch (flagcase) {
                case 0: {
                    this.mTmpNorV2.setAll(fx + 1.0, this.mTerrain[i + 1][j + 1], fz + 1.0);
                    this.mTmpNorPlane.set(this.mTmpNorV0, this.mTmpNorV1, this.mTmpNorV2);
                    normal.setAll(this.mTmpNorPlane.getNormal());
                    break;
                }
                case 1: {
                    this.mTmpNorV2.setAll(fx + 1.0, this.mTerrain[i + 1][j + 1], fz + 1.0);
                    this.mTmpNorPlane.set(this.mTmpNorV0, this.mTmpNorV1, this.mTmpNorV2);
                    normal.setAll(this.mTmpNorPlane.getNormal());
                    break;
                }
                case 2: {
                    this.mTmpNorV2.setAll(fx + 1.0, this.mTerrain[i + 1][j + 1], fz + 1.0);
                    this.mTmpNorPlane.set(this.mTmpNorV0, this.mTmpNorV1, this.mTmpNorV2);
                    normal.setAll(this.mTmpNorPlane.getNormal());
                    normal.multiply(-1.0);
                    break;
                }
                case 3: {
                    this.mTmpNorV2.setAll(fx + 1.0, this.mTerrain[i + 1][j + 1], fz + 1.0);
                    this.mTmpNorPlane.set(this.mTmpNorV0, this.mTmpNorV1, this.mTmpNorV2);
                    normal.setAll(this.mTmpNorPlane.getNormal());
                    normal.multiply(-1.0);
                }
            }
        } else {
            switch (flagcase) {
                case 0: {
                    this.mTmpNorV2.setAll(fx, this.mTerrain[i][j], fz);
                    this.mTmpNorPlane.set(this.mTmpNorV0, this.mTmpNorV1, this.mTmpNorV2);
                    normal.setAll(this.mTmpNorPlane.getNormal());
                    normal.multiply(-1.0);
                    break;
                }
                case 1: {
                    this.mTmpNorV2.setAll(fx, this.mTerrain[i][j + 2], fz + 2.0);
                    this.mTmpNorPlane.set(this.mTmpNorV0, this.mTmpNorV1, this.mTmpNorV2);
                    normal.setAll(this.mTmpNorPlane.getNormal());
                    normal.multiply(-1.0);
                    break;
                }
                case 2: {
                    this.mTmpNorV2.setAll(fx + 2.0, this.mTerrain[i + 2][j], fz);
                    this.mTmpNorPlane.set(this.mTmpNorV0, this.mTmpNorV1, this.mTmpNorV2);
                    normal.setAll(this.mTmpNorPlane.getNormal());
                    break;
                }
                case 3: {
                    this.mTmpNorV2.setAll(fx + 2.0, this.mTerrain[i + 2][j + 2], fz + 2.0);
                    this.mTmpNorPlane.set(this.mTmpNorV0, this.mTmpNorV1, this.mTmpNorV2);
                    normal.setAll(this.mTmpNorPlane.getNormal());
                }
            }
        }
    }

    public double getTemperature(double x, double z) {
        return this.getInterpolateValue(this.mTemperature, x, z);
    }

    @Override
    public ATransformable3D setScale(double scale) {
        throw new RuntimeException("Not permitted for Terrain Object");
    }

    @Override
    public ATransformable3D setScale(double scaleX, double scaleY, double scaleZ) {
        throw new RuntimeException("Not permitted for Terrain Object");
    }

    @Override
    public ATransformable3D setScaleX(double scaleX) {
        throw new RuntimeException("Not permitted for Terrain Object");
    }

    @Override
    public ATransformable3D setScaleY(double scaleY) {
        throw new RuntimeException("Not permitted for Terrain Object");
    }

    @Override
    public ATransformable3D setScaleZ(double scaleZ) {
        throw new RuntimeException("Not permitted for Terrain Object");
    }

    public static class Parameters {
        protected Bitmap heightMapBitmap;
        protected int divisions = 128;
        protected Vector3 scale = new Vector3(1.0, 1.0, 1.0);
        protected double minTemp = 0.0;
        protected double maxTemp = 100.0;
        protected Bitmap colorMapBitmap = null;
        protected double textureMult = 1.0;
        protected int basecolor = -16776961;
        protected int middlecolor = -16711936;
        protected int upcolor = -1;

        protected Parameters(Bitmap hMapBitmap) {
            this.heightMapBitmap = hMapBitmap;
        }

        public void setDivisions(int value) {
            if (value == 0 || (value & value - 1) != 0) {
                throw new RuntimeException("Divisions must be value^2");
            }
            this.divisions = value;
        }

        public void setScale(double sx, double sy, double sz) {
            this.scale.setAll(sx, sy, sz);
        }

        public void setMinTemp(double value) {
            this.minTemp = value;
        }

        public void setMaxTemp(double value) {
            this.maxTemp = value;
        }

        public void setColorMapBitmap(Bitmap value) {
            this.colorMapBitmap = value;
        }

        public void setTextureMult(double value) {
            this.textureMult = value;
        }

        public void setBasecolor(int value) {
            this.basecolor = value;
        }

        public void setMiddleColor(int value) {
            this.middlecolor = value;
        }

        public void setUpColor(int value) {
            this.upcolor = value;
        }

        public int getDivisions() {
            return this.divisions;
        }

        public Vector3 getScale() {
            return this.scale.clone();
        }

        public double getMinTemp() {
            return this.minTemp;
        }

        public double getMaxTemp(double value) {
            return this.maxTemp;
        }

        public Bitmap getHeightMapBitmap() {
            return this.heightMapBitmap;
        }

        public Bitmap getColorMapBitmap() {
            return this.colorMapBitmap;
        }

        public double getTextureMult() {
            return this.textureMult;
        }

        public int getBasecolor() {
            return this.basecolor;
        }

        public int getMiddleColor() {
            return this.middlecolor;
        }

        public int getUpColor() {
            return this.upcolor;
        }
    }
}

