/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.scenegraph;

import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.scenegraph.A_nAABBTree;
import org.rajawali3d.util.RajLog;

public class Octree
extends A_nAABBTree {
    protected static final int[] COLORS = new int[]{-7722014, -16776961, -2987746, -16744448, -2969600, -16711936, -65281, -12525360};

    public Octree() {
        this.init();
    }

    public Octree(int mergeThreshold, int splitThreshold, int shrinkThreshold, int growThreshold, int overlap) {
        super(mergeThreshold, splitThreshold, shrinkThreshold, growThreshold, overlap);
    }

    public Octree(Octree parent, int mergeThreshold, int splitThreshold, int shrinkThreshold, int growThreshold, int overlap) {
        super(parent, mergeThreshold, splitThreshold, shrinkThreshold, growThreshold, overlap);
    }

    @Override
    protected void init() {
        this.CHILD_COUNT = 8;
        this.mChildren = new Octree[this.CHILD_COUNT];
        this.mMembers = Collections.synchronizedList(new CopyOnWriteArrayList());
        if (this.mParent == null) {
            this.mOutside = Collections.synchronizedList(new CopyOnWriteArrayList());
        }
        this.mChildLengths = new Vector3();
    }

    @Override
    protected void setChildRegion(int octant, Vector3 side_lengths) {
        this.mChildRegion = octant;
        Vector3 min = this.mParent.getMin();
        Vector3 max = this.mParent.getMax();
        switch (this.mChildRegion) {
            case 0: {
                this.mMax.setAll(this.mParent.getMax());
                this.mMin.subtractAndSet(this.mMax, side_lengths);
                break;
            }
            case 1: {
                this.mMax.x = min.x + side_lengths.x;
                this.mMax.y = max.y;
                this.mMax.z = max.z;
                this.mMin.x = min.x;
                this.mMin.y = max.y - side_lengths.y;
                this.mMin.z = max.z - side_lengths.z;
                break;
            }
            case 2: {
                this.mMax.x = min.x + side_lengths.x;
                this.mMax.y = min.y + side_lengths.y;
                this.mMax.z = max.z;
                this.mMin.x = min.x;
                this.mMin.y = min.y;
                this.mMin.z = max.z - side_lengths.z;
                break;
            }
            case 3: {
                this.mMax.x = max.x;
                this.mMax.y = min.y + side_lengths.y;
                this.mMax.z = max.z;
                this.mMin.x = max.x - side_lengths.x;
                this.mMin.y = min.y;
                this.mMin.z = max.z - side_lengths.z;
                break;
            }
            case 4: {
                this.mMax.x = max.x;
                this.mMax.y = max.y;
                this.mMax.z = min.z + side_lengths.z;
                this.mMin.x = max.x - side_lengths.x;
                this.mMin.y = max.y - side_lengths.y;
                this.mMin.z = min.z;
                break;
            }
            case 5: {
                this.mMax.x = min.x + side_lengths.x;
                this.mMax.y = max.y;
                this.mMax.z = min.z + side_lengths.z;
                this.mMin.x = min.x;
                this.mMin.y = max.y - side_lengths.y;
                this.mMin.z = min.z;
                break;
            }
            case 6: {
                this.mMin.setAll(min);
                this.mMax.addAndSet(this.mMin, side_lengths);
                break;
            }
            case 7: {
                this.mMax.x = max.x;
                this.mMax.y = min.y + side_lengths.y;
                this.mMax.z = min.z + side_lengths.z;
                this.mMin.x = max.x - side_lengths.x;
                this.mMin.y = min.y;
                this.mMin.z = min.z;
                break;
            }
            default: {
                return;
            }
        }
        super.setChildRegion(octant, side_lengths);
    }

    @Override
    protected void destroy() {
        RajLog.d("[" + this.getClass().getName() + "] Destroying octree node: " + this);
    }

    @Override
    protected void split() {
        RajLog.d("[" + this.getClass().getName() + "] Spliting node: " + this);
        for (int i = 0; i < this.CHILD_COUNT; ++i) {
            if (this.mChildren[i] == null) {
                this.mChildren[i] = new Octree(this, this.mMergeThreshold, this.mSplitThreshold, this.mShrinkThreshold, this.mGrowThreshold, this.mOverlap);
            }
            this.mChildren[i].setBoundingColor(COLORS[i]);
            this.mChildren[i].setChildRegion(i, this.mChildLengths);
        }
        super.split();
    }

    @Override
    public String toString() {
        String str = "Octant: " + this.mChildRegion + " member/outside count: " + this.mMembers.size() + "/";
        str = this.mParent == null ? str + this.mOutside.size() : str + "NULL";
        return str;
    }
}

