/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.scenegraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.rajawali3d.ATransformable3D;
import org.rajawali3d.bounds.BoundingBox;
import org.rajawali3d.bounds.BoundingSphere;
import org.rajawali3d.bounds.IBoundingVolume;
import org.rajawali3d.cameras.Camera;
import org.rajawali3d.math.Matrix4;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.scenegraph.IGraphNode;
import org.rajawali3d.scenegraph.IGraphNodeMember;
import org.rajawali3d.scenegraph.Octree;
import org.rajawali3d.util.RajLog;

public abstract class A_nAABBTree
extends BoundingBox
implements IGraphNode {
    protected int CHILD_COUNT = 0;
    protected A_nAABBTree mParent;
    protected A_nAABBTree[] mChildren;
    protected Vector3 mChildLengths;
    protected boolean mSplit = false;
    protected List<IGraphNodeMember> mMembers;
    protected List<IGraphNodeMember> mOutside;
    protected int mOverlap = 0;
    protected int mGrowThreshold = 5;
    protected int mShrinkThreshold = 4;
    protected int mSplitThreshold = 5;
    protected int mMergeThreshold = 2;
    protected boolean mRecursiveAdd = false;
    protected boolean mRecursiveRemove = false;
    protected final Matrix4 mMMatrix = new Matrix4();
    protected final Vector3 mPosition = new Vector3();
    protected int mChildRegion = -1;

    protected A_nAABBTree() {
    }

    public A_nAABBTree(int mergeThreshold, int splitThreshold, int shrinkThreshold, int growThreshold, int overlap) {
        this(null, mergeThreshold, splitThreshold, shrinkThreshold, growThreshold, overlap);
    }

    public A_nAABBTree(A_nAABBTree parent, int mergeThreshold, int splitThreshold, int shrinkThreshold, int growThreshold, int overlap) {
        this.mParent = parent;
        this.mMergeThreshold = mergeThreshold;
        this.mSplitThreshold = splitThreshold;
        this.mShrinkThreshold = shrinkThreshold;
        this.mGrowThreshold = growThreshold;
        this.mOverlap = overlap;
        this.init();
    }

    protected abstract void destroy();

    protected void calculateChildSideLengths() {
        Vector3 temp = Vector3.subtractAndCreate(this.mTransformedMax, this.mTransformedMin);
        temp.multiply(0.5);
        float overlap = 1.0f + (float)this.mOverlap / 100.0f;
        temp.multiply(overlap);
        temp.absoluteValue();
        this.mChildLengths.setAll(temp);
    }

    protected void setBounds(IGraphNodeMember member) {
        if (this.mMembers.size() != 0 && this.mParent != null) {
            return;
        }
        IBoundingVolume volume = member.getTransformedBoundingVolume();
        BoundingBox bcube = null;
        BoundingSphere bsphere = null;
        Vector3 position = member.getScenePosition();
        double span_y = 0.0;
        double span_x = 0.0;
        double span_z = 0.0;
        if (volume == null) {
            span_x = 5.0;
            span_y = 5.0;
            span_z = 5.0;
        } else if (volume instanceof BoundingBox) {
            bcube = (BoundingBox)volume;
            Vector3 min = bcube.getTransformedMin();
            Vector3 max = bcube.getTransformedMax();
            span_x = max.x - min.x;
            span_y = max.y - min.y;
            span_z = max.z - min.z;
        } else if (volume instanceof BoundingSphere) {
            bsphere = (BoundingSphere)volume;
            span_y = span_x = 2.0 * bsphere.getScaledRadius();
            span_z = span_x;
        }
        this.mMin.x = (float)(position.x - span_x);
        this.mMin.y = (float)(position.y - span_y);
        this.mMin.z = (float)(position.z - span_z);
        this.mMax.x = (float)(position.x + span_x);
        this.mMax.y = (float)(position.y + span_y);
        this.mMax.z = (float)(position.z + span_z);
        this.mTransformedMin.setAll(this.mMin);
        this.mTransformedMax.setAll(this.mMax);
        this.calculatePoints();
        this.calculateChildSideLengths();
    }

    protected void setBounds(int child) {
        A_nAABBTree new_bounds = this.mChildren[child];
        this.mMin.setAll(new_bounds.mMin);
        this.mMax.setAll(new_bounds.mMax);
        this.mTransformedMin.setAll(this.mMin);
        this.mTransformedMax.setAll(this.mMax);
        this.calculatePoints();
        this.calculateChildSideLengths();
    }

    protected void setChildRegion(int region, Vector3 side_lengths) {
        this.mTransformedMin.setAll(this.mMin);
        this.mTransformedMax.setAll(this.mMax);
        this.calculatePoints();
        this.calculateChildSideLengths();
        if (this.mSplit) {
            for (int i = 0; i < this.CHILD_COUNT; ++i) {
                this.mChildren[i].setChildRegion(i, this.mChildLengths);
            }
        }
    }

    protected int getChildRegion() {
        return this.mChildRegion;
    }

    public void setGrowThreshold(int threshold) {
        this.mGrowThreshold = threshold;
    }

    public void setShrinkThreshold(int threshold) {
        this.mShrinkThreshold = threshold;
    }

    public void setMergeThreshold(int threshold) {
        this.mMergeThreshold = threshold;
    }

    public void setSplitThreshold(int threshold) {
        this.mSplitThreshold = threshold;
    }

    protected void addToMembers(IGraphNodeMember object) {
        RajLog.d("[" + this.getClass().getName() + "] Adding object: " + object + " to members list in: " + this);
        object.getTransformedBoundingVolume().setBoundingColor(this.mBoundingColor.get());
        object.setGraphNode(this, true);
        this.mMembers.add(object);
    }

    protected void removeFromMembers(IGraphNodeMember object) {
        RajLog.d("[" + this.getClass().getName() + "] Removing object: " + object + " from members list in: " + this);
        object.getTransformedBoundingVolume().setBoundingColor(-256);
        object.setGraphNode(null, false);
        this.mMembers.remove(object);
    }

    protected void addToOutside(IGraphNodeMember object) {
        if (this.mOutside.contains(object)) {
            return;
        }
        this.mOutside.add(object);
        object.setGraphNode(this, false);
        object.getTransformedBoundingVolume().setBoundingColor(-256);
    }

    protected ArrayList<IGraphNodeMember> getAllMembersRecursively(boolean shouldClear) {
        ArrayList<IGraphNodeMember> members = new ArrayList<IGraphNodeMember>();
        members.addAll(this.mMembers);
        if (this.mParent == null) {
            members.addAll(this.mOutside);
        }
        if (shouldClear) {
            this.clear();
        }
        if (this.mSplit) {
            for (int i = 0; i < this.CHILD_COUNT; ++i) {
                members.addAll(this.mChildren[i].mMembers);
                if (!shouldClear) continue;
                this.mChildren[i].clear();
            }
        }
        return members;
    }

    protected void internalAddObject(IGraphNodeMember object) {
        if (this.mSplit) {
            int fits_in_child = -1;
            for (int i = 0; i < this.CHILD_COUNT; ++i) {
                if (!this.mChildren[i].contains(object.getTransformedBoundingVolume())) continue;
                if (fits_in_child < 0) {
                    fits_in_child = i;
                    continue;
                }
                fits_in_child = -1;
                break;
            }
            if (fits_in_child >= 0) {
                this.mChildren[fits_in_child].addObject(object);
            } else {
                this.addToMembers(object);
            }
        } else {
            this.addToMembers(object);
            if (this.mMembers.size() >= this.mSplitThreshold) {
                this.split();
            }
        }
    }

    protected void shrinkAddObject(IGraphNodeMember object) {
        if (this.contains(object.getTransformedBoundingVolume())) {
            this.internalAddObject(object);
        } else {
            this.addToOutside(object);
        }
    }

    protected void split() {
        ArrayList<IGraphNodeMember> removed = new ArrayList<IGraphNodeMember>();
        for (int i = 0; i < this.mMembers.size(); ++i) {
            int fits_in_child = -1;
            IGraphNodeMember member = this.mMembers.get(i);
            for (int j = 0; j < this.CHILD_COUNT; ++j) {
                if (!this.mChildren[j].contains(member.getTransformedBoundingVolume())) continue;
                if (fits_in_child < 0) {
                    fits_in_child = j;
                    continue;
                }
                fits_in_child = -1;
                break;
            }
            if (fits_in_child < 0) continue;
            this.mChildren[fits_in_child].addObject(member);
            removed.add(member);
        }
        this.mMembers.removeAll(removed);
        this.mSplit = true;
    }

    protected void merge() {
        RajLog.d("[" + this.getClass().getName() + "] Merge nodes called on node: " + this);
        if (this.mParent != null && this.mParent.canMerge()) {
            RajLog.d("[" + this.getClass().getName() + "] Parent can merge...passing call up.");
            this.mParent.merge();
        } else if (this.mSplit) {
            for (int i = 0; i < this.CHILD_COUNT; ++i) {
                ArrayList<IGraphNodeMember> members = this.mChildren[i].getAllMembersRecursively(false);
                int members_count = members.size();
                for (int j = 0; j < members_count; ++j) {
                    this.addToMembers(members.get(j));
                }
                this.mChildren[i].destroy();
                this.mChildren[i] = null;
            }
            this.mSplit = false;
        }
    }

    protected void grow() {
        int i;
        RajLog.d("[" + this.getClass().getName() + "] Growing tree: " + this);
        Vector3 min = new Vector3(3.4028234663852886E38, 3.4028234663852886E38, 3.4028234663852886E38);
        Vector3 max = new Vector3(-3.4028234663852886E38, -3.4028234663852886E38, -3.4028234663852886E38);
        ArrayList<IGraphNodeMember> members = this.getAllMembersRecursively(true);
        int members_count = members.size();
        for (i = 0; i < members_count; ++i) {
            IBoundingVolume volume = members.get(i).getTransformedBoundingVolume();
            Vector3 test_against_min = null;
            Vector3 test_against_max = null;
            if (volume == null) {
                ATransformable3D object = (ATransformable3D)members.get(i);
                test_against_max = test_against_min = object.getPosition();
            } else if (volume instanceof BoundingBox) {
                BoundingBox bb = (BoundingBox)volume;
                test_against_min = bb.getTransformedMin();
                test_against_max = bb.getTransformedMax();
            } else if (volume instanceof BoundingSphere) {
                BoundingSphere bs = (BoundingSphere)volume;
                Vector3 bs_position = bs.getPosition();
                double radius = bs.getScaledRadius();
                Vector3 rad = new Vector3();
                rad.setAll(radius, radius, radius);
                test_against_min = Vector3.subtractAndCreate(bs_position, rad);
                test_against_max = Vector3.addAndCreate(bs_position, rad);
            } else {
                RajLog.e("[" + this.getClass().getName() + "] Received a bounding box of unknown type.");
                throw new IllegalArgumentException("Received a bounding box of unknown type.");
            }
            if (test_against_min == null || test_against_max == null) continue;
            if (test_against_min.x < min.x) {
                min.x = test_against_min.x;
            }
            if (test_against_min.y < min.y) {
                min.y = test_against_min.y;
            }
            if (test_against_min.z < min.z) {
                min.z = test_against_min.z;
            }
            if (test_against_max.x > max.x) {
                max.x = test_against_max.x;
            }
            if (test_against_max.y > max.y) {
                max.y = test_against_max.y;
            }
            if (!(test_against_max.z > max.z)) continue;
            max.z = test_against_max.z;
        }
        this.mMin.setAll(min);
        this.mMax.setAll(max);
        this.mTransformedMin.setAll(min);
        this.mTransformedMax.setAll(max);
        this.calculatePoints();
        this.calculateChildSideLengths();
        if (this.mSplit) {
            for (i = 0; i < this.CHILD_COUNT; ++i) {
                ((Octree)this.mChildren[i]).setChildRegion(i, this.mChildLengths);
            }
        }
        for (i = 0; i < members_count; ++i) {
            this.internalAddObject(members.get(i));
        }
    }

    protected abstract void init();

    protected void shrink() {
        int i;
        if (this.mParent != null) {
            throw new IllegalStateException("Shrink can only be called by the root node.");
        }
        RajLog.d("[" + this.getClass().getName() + "] Checking if tree should be shrunk.");
        int maxCount = 0;
        int index_max = -1;
        for (i = 0; i < this.CHILD_COUNT; ++i) {
            if (this.mChildren[i].getObjectCount() <= maxCount) continue;
            maxCount = this.mChildren[i].getObjectCount();
            index_max = i;
        }
        if (index_max >= 0) {
            for (i = 0; i < this.CHILD_COUNT; ++i) {
                if (i == index_max || this.mChildren[i].getObjectCount() != maxCount) continue;
                return;
            }
            if (this.getObjectCount() - maxCount <= this.mShrinkThreshold) {
                int i2;
                RajLog.d("[" + this.getClass().getName() + "] Shrinking tree.");
                ArrayList<IGraphNodeMember> members = this.getAllMembersRecursively(true);
                int members_count = members.size();
                this.setBounds(index_max);
                if (this.mSplit) {
                    for (i2 = 0; i2 < this.CHILD_COUNT; ++i2) {
                        this.mChildren[i2].destroy();
                        this.mChildren[i2] = null;
                    }
                    this.mSplit = false;
                }
                for (i2 = 0; i2 < members_count; ++i2) {
                    this.shrinkAddObject(members.get(i2));
                }
            }
        }
    }

    public boolean canMerge() {
        int count = this.mMembers.size();
        if (this.mSplit) {
            for (int i = 0; i < this.CHILD_COUNT; ++i) {
                count += this.mChildren[i].mMembers.size();
            }
        }
        return count <= this.mMergeThreshold;
    }

    @Override
    public void clear() {
        this.mMembers.clear();
        if (this.mParent == null) {
            this.mOutside.clear();
        }
    }

    @Override
    public synchronized void addObject(IGraphNodeMember object) {
        RajLog.d("[" + this.getClass().getName() + "] Adding object: " + object + " to octree.");
        if (this.mParent == null) {
            this.mBoundingColor.set(-65536);
            if (this.getObjectCount() == 0) {
                this.setBounds(object);
                this.addToMembers(object);
            } else if (this.contains(object.getTransformedBoundingVolume())) {
                this.internalAddObject(object);
            } else {
                this.addToOutside(object);
                if (this.mOutside.size() >= this.mGrowThreshold) {
                    this.grow();
                }
            }
        } else {
            this.internalAddObject(object);
        }
    }

    @Override
    public void addObjects(Collection<IGraphNodeMember> objects) {
    }

    @Override
    public synchronized void removeObject(IGraphNodeMember object) {
        RajLog.d("[" + this.getClass().getName() + "] Removing object: " + object + " from octree.");
        IGraphNode container = object.getGraphNode();
        if (container == null) {
            this.mOutside.remove(object);
        } else if (container == this) {
            this.removeFromMembers(object);
            if (this.canMerge() && this.mParent != null) {
                this.merge();
            }
        } else {
            container.removeObject(object);
        }
        if (this.mParent == null && this.mSplit) {
            this.shrink();
        }
    }

    @Override
    public void removeObjects(Collection<IGraphNodeMember> objects) {
    }

    @Override
    public synchronized void updateObject(IGraphNodeMember object) {
        if (this.mParent == null && this.getObjectCount() == 1) {
            this.setBounds(object);
            return;
        }
        IGraphNode container = object.getGraphNode();
        this.handleRecursiveUpdate((A_nAABBTree)container, object);
        RajLog.e("Node: " + this + " Object Container: " + container);
    }

    protected void handleRecursiveUpdate(A_nAABBTree container, IGraphNodeMember object) {
        A_nAABBTree local_container = container;
        boolean updated = false;
        while (!updated) {
            if (local_container.contains(object.getTransformedBoundingVolume())) {
                int fits_in_child = -1;
                if (this.mSplit) {
                    for (int j = 0; j < this.CHILD_COUNT; ++j) {
                        if (!this.mChildren[j].contains(object.getTransformedBoundingVolume())) continue;
                        if (fits_in_child < 0) {
                            fits_in_child = j;
                            continue;
                        }
                        fits_in_child = -1;
                        break;
                    }
                    if (fits_in_child >= 0) {
                        RajLog.i("Fits in a single child.");
                        local_container.removeFromMembers(object);
                        this.mChildren[fits_in_child].internalAddObject(object);
                        updated = true;
                        continue;
                    }
                    RajLog.i("Fits in multiple children, leaving in place.");
                    updated = true;
                    continue;
                }
                RajLog.i("No children so we are leaving in same node.");
                if (!object.isInGraph()) {
                    RajLog.i("Removing from outside graph and moving to inside root.");
                    local_container.mOutside.remove(object);
                    local_container.internalAddObject(object);
                }
                updated = true;
                continue;
            }
            if (local_container.mParent == null) {
                if (object.isInGraph()) {
                    local_container.removeFromMembers(object);
                    local_container.addToOutside(object);
                }
                updated = true;
                continue;
            }
            RajLog.i("Container is not root (" + local_container + "). Moving search up a level.");
            local_container = local_container.mParent;
        }
    }

    @Override
    public void rebuild() {
    }

    @Override
    public void addChildrenRecursively(boolean recursive) {
        this.mRecursiveAdd = recursive;
    }

    @Override
    public void removeChildrenRecursively(boolean recursive) {
        this.mRecursiveRemove = recursive;
    }

    @Override
    public void cullFromBoundingVolume(IBoundingVolume volume) {
    }

    @Override
    public void displayGraph(Camera camera, Matrix4 vpMatrix, Matrix4 projMatrix, Matrix4 vMatrix) {
        this.drawBoundingVolume(camera, vpMatrix, projMatrix, vMatrix, this.mMMatrix);
        if (this.mSplit) {
            for (int i = 0; i < this.CHILD_COUNT; ++i) {
                this.mChildren[i].displayGraph(camera, vpMatrix, projMatrix, vMatrix);
            }
        }
    }

    @Override
    public Vector3 getSceneMinBound() {
        return this.getTransformedMin();
    }

    @Override
    public Vector3 getSceneMaxBound() {
        return this.getTransformedMax();
    }

    @Override
    public int getObjectCount() {
        int count = this.mMembers.size();
        if (this.mParent == null) {
            count += this.mOutside.size();
        }
        if (this.mSplit) {
            for (int i = 0; i < this.CHILD_COUNT; ++i) {
                count += this.mChildren[i].getObjectCount();
            }
        }
        return count;
    }

    @Override
    public boolean contains(IBoundingVolume boundingVolume) {
        if (!(boundingVolume instanceof BoundingBox)) {
            return false;
        }
        BoundingBox boundingBox = (BoundingBox)boundingVolume;
        Vector3 otherMin = boundingBox.getTransformedMin();
        Vector3 otherMax = boundingBox.getTransformedMax();
        Vector3 min = this.mTransformedMin;
        Vector3 max = this.mTransformedMax;
        return max.x >= otherMax.x && min.x <= otherMin.x && max.y >= otherMax.y && min.y <= otherMin.y && max.z >= otherMax.z && min.z <= otherMin.z;
    }

    @Override
    public boolean isContainedBy(IBoundingVolume boundingVolume) {
        if (!(boundingVolume instanceof BoundingBox)) {
            return false;
        }
        BoundingBox boundingBox = (BoundingBox)boundingVolume;
        Vector3 otherMin = boundingBox.getTransformedMin();
        Vector3 otherMax = boundingBox.getTransformedMax();
        Vector3 min = this.mTransformedMin;
        Vector3 max = this.mTransformedMax;
        return max.x <= otherMax.x && min.x >= otherMin.x && max.y <= otherMax.y && min.y >= otherMin.y && max.z <= otherMax.z && min.z >= otherMin.z;
    }

    @Override
    public String toString() {
        String str = "A_nAABBTree: " + this.mChildRegion + " member/outside count: " + this.mMembers.size() + "/";
        str = this.mParent == null ? str + this.mOutside.size() : str + "NULL";
        return str;
    }
}

