/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.scene;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.opengl.GLES20;
import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.rajawali3d.Object3D;
import org.rajawali3d.animation.Animation;
import org.rajawali3d.cameras.Camera;
import org.rajawali3d.lights.ALight;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.plugins.FogMaterialPlugin;
import org.rajawali3d.materials.plugins.ShadowMapMaterialPlugin;
import org.rajawali3d.materials.textures.ATexture;
import org.rajawali3d.materials.textures.CubeMapTexture;
import org.rajawali3d.materials.textures.Texture;
import org.rajawali3d.math.Matrix4;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.postprocessing.materials.ShadowMapMaterial;
import org.rajawali3d.primitives.Cube;
import org.rajawali3d.renderer.AFrameTask;
import org.rajawali3d.renderer.RenderTarget;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.renderer.plugins.IRendererPlugin;
import org.rajawali3d.renderer.plugins.Plugin;
import org.rajawali3d.scene.ASceneFrameCallback;
import org.rajawali3d.scenegraph.IGraphNode;
import org.rajawali3d.scenegraph.Octree;
import org.rajawali3d.util.ObjectColorPicker;
import org.rajawali3d.util.RajLog;
import org.rajawali3d.view.ISurface;

public class Scene {
    protected final int GL_COVERAGE_BUFFER_BIT_NV = 32768;
    protected double mEyeZ = 4.0;
    protected Renderer mRenderer;
    protected Matrix4 mVMatrix = new Matrix4();
    protected Matrix4 mPMatrix = new Matrix4();
    protected Matrix4 mVPMatrix = new Matrix4();
    protected Matrix4 mInvVPMatrix = new Matrix4();
    protected float mRed;
    protected float mBlue;
    protected float mGreen;
    protected float mAlpha;
    protected Cube mSkybox;
    protected FogMaterialPlugin.FogParams mFogParams;
    private Cube mNextSkybox;
    private final Object mNextSkyboxLock = new Object();
    protected ATexture mSkyboxTexture;
    private volatile boolean mLightsDirty;
    protected volatile ObjectColorPicker.ColorPickerInfo mPickerInfo;
    protected boolean mReloadPickerInfo;
    protected ISurface.ANTI_ALIASING_CONFIG mAntiAliasingConfig;
    protected boolean mEnableDepthBuffer = true;
    protected boolean mAlwaysClearColorBuffer = true;
    private ShadowMapMaterial mShadowMapMaterial;
    private final List<Object3D> mChildren;
    private final List<ASceneFrameCallback> mPreCallbacks;
    private final List<ASceneFrameCallback> mPreDrawCallbacks;
    private final List<ASceneFrameCallback> mPostCallbacks;
    private final List<Animation> mAnimations;
    private final List<IRendererPlugin> mPlugins;
    private final List<ALight> mLights;
    protected Camera mCamera;
    private final List<Camera> mCameras;
    private Camera mNextCamera;
    private final Object mNextCameraLock = new Object();
    private final LinkedList<AFrameTask> mFrameTaskQueue;
    protected boolean mDisplaySceneGraph = false;
    protected IGraphNode mSceneGraph;
    protected IGraphNode.GRAPH_TYPE mSceneGraphType = IGraphNode.GRAPH_TYPE.NONE;

    public Scene(Renderer renderer) {
        this.mRenderer = renderer;
        this.mAlpha = 0.0f;
        this.mAnimations = Collections.synchronizedList(new CopyOnWriteArrayList());
        this.mPreCallbacks = Collections.synchronizedList(new CopyOnWriteArrayList());
        this.mPreDrawCallbacks = Collections.synchronizedList(new CopyOnWriteArrayList());
        this.mPostCallbacks = Collections.synchronizedList(new CopyOnWriteArrayList());
        this.mChildren = Collections.synchronizedList(new CopyOnWriteArrayList());
        this.mPlugins = Collections.synchronizedList(new CopyOnWriteArrayList());
        this.mCameras = Collections.synchronizedList(new CopyOnWriteArrayList());
        this.mLights = Collections.synchronizedList(new CopyOnWriteArrayList());
        this.mFrameTaskQueue = new LinkedList();
        this.mCamera = new Camera();
        this.mCamera.setZ(this.mEyeZ);
        this.mCameras.add(this.mCamera);
        this.mAntiAliasingConfig = ISurface.ANTI_ALIASING_CONFIG.NONE;
    }

    public Scene(Renderer renderer, IGraphNode.GRAPH_TYPE type) {
        this(renderer);
        this.mSceneGraphType = type;
        this.initSceneGraph();
    }

    protected void initSceneGraph() {
        switch (this.mSceneGraphType) {
            case OCTREE: {
                this.mSceneGraph = new Octree();
                break;
            }
        }
    }

    public void initScene() {
    }

    public Vector3 getSceneMinBound() {
        if (this.mSceneGraph != null) {
            return this.mSceneGraph.getSceneMinBound();
        }
        return new Vector3(1.4E-45f, 1.4E-45f, 1.4E-45f);
    }

    public Vector3 getSceneMaxBound() {
        if (this.mSceneGraph != null) {
            return this.mSceneGraph.getSceneMaxBound();
        }
        return new Vector3(3.4028234663852886E38, 3.4028234663852886E38, 3.4028234663852886E38);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchCamera(Camera camera) {
        Object object = this.mNextCameraLock;
        synchronized (object) {
            this.mNextCamera = camera;
        }
    }

    public void switchCamera(int camera) {
        this.switchCamera(this.mCameras.get(camera));
    }

    public Camera getCamera() {
        return this.mCamera;
    }

    public Camera getCamera(int camera) {
        return this.mCameras.get(camera);
    }

    public boolean addCamera(final Camera camera) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Scene.this.mCameras.add(camera);
                if (Scene.this.mSceneGraph != null) {
                    // empty if block
                }
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean addCameras(final Collection<Camera> cameras) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Scene.this.mCameras.addAll(cameras);
                if (Scene.this.mSceneGraph != null) {
                    // empty if block
                }
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean removeCamera(final Camera camera) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Scene.this.mCameras.remove(camera);
                if (Scene.this.mSceneGraph != null) {
                    // empty if block
                }
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean clearCameras() {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Scene.this.mCameras.clear();
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean replaceCamera(final Camera camera, final int location) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Camera old = Scene.this.mCameras.set(location, camera);
                if (Scene.this.mSceneGraph != null) {
                    // empty if block
                }
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean replaceCamera(final Camera oldCamera, final Camera newCamera) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Scene.this.mCameras.set(Scene.this.mCameras.indexOf(oldCamera), newCamera);
                if (Scene.this.mSceneGraph != null) {
                    // empty if block
                }
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean addAndSwitchCamera(Camera camera) {
        boolean success = this.addCamera(camera);
        this.switchCamera(camera);
        return success;
    }

    public boolean replaceAndSwitchCamera(Camera camera, int location) {
        boolean success = this.replaceCamera(camera, location);
        this.switchCamera(camera);
        return success;
    }

    public boolean replaceAndSwitchCamera(Camera oldCamera, Camera newCamera) {
        boolean success = this.replaceCamera(oldCamera, newCamera);
        this.switchCamera(newCamera);
        return success;
    }

    public boolean replaceChild(final Object3D child, final int location) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Object3D old = Scene.this.mChildren.set(location, child);
                if (Scene.this.mSceneGraph != null) {
                    // empty if block
                }
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean replaceChild(final Object3D oldChild, final Object3D newChild) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Scene.this.mChildren.set(Scene.this.mChildren.indexOf(oldChild), newChild);
                if (Scene.this.mSceneGraph != null) {
                    // empty if block
                }
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean addChild(final Object3D child) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Scene.this.mChildren.add(child);
                if (Scene.this.mSceneGraph != null) {
                    // empty if block
                }
                Scene.this.addShadowMapMaterialPlugin(child, Scene.this.mShadowMapMaterial == null ? null : Scene.this.mShadowMapMaterial.getMaterialPlugin());
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean addChildAt(final Object3D child, final int index) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Scene.this.mChildren.add(index, child);
                if (Scene.this.mSceneGraph != null) {
                    // empty if block
                }
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean addChildren(final Collection<Object3D> children) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Scene.this.mChildren.addAll(children);
                if (Scene.this.mSceneGraph != null) {
                    // empty if block
                }
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean removeChild(final Object3D child) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Scene.this.mChildren.remove(child);
                if (Scene.this.mSceneGraph != null) {
                    // empty if block
                }
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean clearChildren() {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Scene.this.mChildren.clear();
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean addLight(final ALight light) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Scene.this.mLights.add(light);
                Scene.this.mLightsDirty = true;
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean removeLight(final ALight light) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Scene.this.mLights.remove(light);
                Scene.this.mLightsDirty = true;
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean clearLights() {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Scene.this.mLights.clear();
                Scene.this.mLightsDirty = true;
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean addPlugin(final Plugin plugin) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Scene.this.mPlugins.add(plugin);
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean addPlugins(final Collection<Plugin> plugins) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Scene.this.mPlugins.addAll(plugins);
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean removePlugin(final Plugin plugin) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Scene.this.mPlugins.add(plugin);
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean clearPlugins() {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Scene.this.mPlugins.clear();
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean registerAnimation(final Animation anim) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Scene.this.mAnimations.add(anim);
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean unregisterAnimation(final Animation anim) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Scene.this.mAnimations.remove(anim);
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean replaceAnimation(final Animation oldAnim, final Animation newAnim) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Scene.this.mAnimations.set(Scene.this.mAnimations.indexOf(oldAnim), newAnim);
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean registerAnimations(final Collection<Animation> anims) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Scene.this.mAnimations.addAll(anims);
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean clearAnimations() {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Scene.this.mAnimations.clear();
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean registerFrameCallback(final ASceneFrameCallback callback) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                if (callback.callPreFrame()) {
                    Scene.this.mPreCallbacks.add(callback);
                }
                if (callback.callPreDraw()) {
                    Scene.this.mPreDrawCallbacks.add(callback);
                }
                if (callback.callPostFrame()) {
                    Scene.this.mPostCallbacks.add(callback);
                }
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean unregisterFrameCallback(final ASceneFrameCallback callback) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                if (callback.callPreFrame()) {
                    Scene.this.mPreCallbacks.remove(callback);
                }
                if (callback.callPreDraw()) {
                    Scene.this.mPreDrawCallbacks.remove(callback);
                }
                if (callback.callPostFrame()) {
                    Scene.this.mPostCallbacks.remove(callback);
                }
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean clearFrameCallbacks() {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Scene.this.mPreCallbacks.clear();
                Scene.this.mPreDrawCallbacks.clear();
                Scene.this.mPostCallbacks.clear();
            }
        };
        return this.internalOfferTask(task);
    }

    public void setFog(FogMaterialPlugin.FogParams fogParams) {
        this.mFogParams = fogParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSkybox(int resourceId) throws ATexture.TextureException {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                int j = Scene.this.mCameras.size();
                for (int i = 0; i < j; ++i) {
                    ((Camera)Scene.this.mCameras.get(i)).setFarPlane(1000.0);
                }
            }
        };
        Object object = this.mNextSkyboxLock;
        synchronized (object) {
            this.mNextSkybox = new Cube(700.0f, true, false);
            this.mNextSkybox.setDoubleSided(true);
            this.mSkyboxTexture = new Texture("skybox", resourceId);
            Material material = new Material();
            material.setColorInfluence(0.0f);
            material.addTexture(this.mSkyboxTexture);
            this.mNextSkybox.setMaterial(material);
        }
        return this.internalOfferTask(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSkybox(int posx, int negx, int posy, int negy, int posz, int negz) throws ATexture.TextureException {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                int j = Scene.this.mCameras.size();
                for (int i = 0; i < j; ++i) {
                    ((Camera)Scene.this.mCameras.get(i)).setFarPlane(1000.0);
                }
            }
        };
        Object object = this.mNextSkyboxLock;
        synchronized (object) {
            this.mNextSkybox = new Cube(700.0f, true);
            int[] resourceIds = new int[]{posx, negx, posy, negy, posz, negz};
            this.mSkyboxTexture = new CubeMapTexture("skybox", resourceIds);
            ((CubeMapTexture)this.mSkyboxTexture).isSkyTexture(true);
            Material mat = new Material();
            mat.setColorInfluence(0.0f);
            mat.addTexture(this.mSkyboxTexture);
            this.mNextSkybox.setMaterial(mat);
        }
        return this.internalOfferTask(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSkybox(Bitmap[] bitmaps) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                int j = Scene.this.mCameras.size();
                for (int i = 0; i < j; ++i) {
                    ((Camera)Scene.this.mCameras.get(i)).setFarPlane(1000.0);
                }
            }
        };
        Cube skybox = new Cube(700.0f, true);
        CubeMapTexture texture = new CubeMapTexture("bitmap_skybox", bitmaps);
        texture.isSkyTexture(true);
        Material material = new Material();
        material.setColorInfluence(0.0f);
        try {
            material.addTexture(texture);
        }
        catch (ATexture.TextureException e) {
            RajLog.e(e.getMessage());
        }
        skybox.setMaterial(material);
        Object object = this.mNextCameraLock;
        synchronized (object) {
            this.mNextSkybox = skybox;
        }
        return this.internalOfferTask(task);
    }

    public void updateSkybox(int resourceId) throws Exception {
        if (this.mSkyboxTexture.getClass() != Texture.class) {
            throw new Exception("The skybox texture cannot be updated.");
        }
        Texture texture = (Texture)this.mSkyboxTexture;
        texture.setResourceId(resourceId);
        this.mRenderer.getTextureManager().replaceTexture(texture);
    }

    public void updateSkybox(int front, int right, int back, int left, int up, int down) throws Exception {
        if (this.mSkyboxTexture.getClass() != CubeMapTexture.class) {
            throw new Exception("The skybox texture cannot be updated. It is not a cube map texture.");
        }
        int[] resourceIds = new int[]{front, right, back, left, up, down};
        CubeMapTexture cubemap = (CubeMapTexture)this.mSkyboxTexture;
        cubemap.setResourceIds(resourceIds);
        this.mRenderer.getTextureManager().replaceTexture(cubemap);
    }

    public void updateSkybox(Bitmap[] bitmaps) throws Exception {
        if (this.mSkyboxTexture.getClass() != CubeMapTexture.class) {
            throw new Exception("The skybox texture cannot be updated. It is not a cube map texture.");
        }
        CubeMapTexture cubemap = (CubeMapTexture)this.mSkyboxTexture;
        cubemap.setBitmaps(bitmaps);
        this.mRenderer.getTextureManager().replaceTexture(cubemap);
    }

    public void requestColorPicking(@NonNull ObjectColorPicker.ColorPickerInfo pickerInfo) {
        this.mPickerInfo = pickerInfo;
    }

    public void reload() {
        this.reloadChildren();
        if (this.mSkybox != null) {
            this.mSkybox.reload();
        }
        this.reloadPlugins();
        this.mReloadPickerInfo = true;
    }

    public boolean hasPickerInfo() {
        return this.mPickerInfo != null;
    }

    public void resetGLState() {
        GLES20.glEnable((int)2884);
        GLES20.glCullFace((int)1029);
        GLES20.glFrontFace((int)2305);
        GLES20.glDisable((int)3042);
        GLES20.glEnable((int)2929);
    }

    public void render(long ellapsedTime, double deltaTime, RenderTarget renderTarget) {
        this.render(ellapsedTime, deltaTime, renderTarget, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(long ellapsedTime, double deltaTime, RenderTarget renderTarget, Material sceneMaterial) {
        int postCount;
        int j;
        int i;
        int i2;
        List<Object> list;
        int clearMask;
        if (this.mPickerInfo != null) {
            this.doColorPicking(this.mPickerInfo);
            this.mPickerInfo = null;
        }
        this.performFrameTasks();
        Object object = this.mFrameTaskQueue;
        synchronized (object) {
            if (this.mLightsDirty) {
                this.updateMaterialsWithLights();
                this.mLightsDirty = false;
            }
        }
        object = this.mNextSkyboxLock;
        synchronized (object) {
            if (this.mNextSkybox != null) {
                this.mSkybox = this.mNextSkybox;
                this.mNextSkybox = null;
            }
        }
        object = this.mNextCameraLock;
        synchronized (object) {
            if (this.mNextCamera != null) {
                this.mCamera = this.mNextCamera;
                this.mCamera.setProjectionMatrix(this.mRenderer.getViewportWidth(), this.mRenderer.getViewportHeight());
                this.mNextCamera = null;
            }
        }
        int n = clearMask = this.mAlwaysClearColorBuffer ? 16384 : 0;
        if (renderTarget != null) {
            renderTarget.bind();
            GLES20.glClearColor((float)this.mRed, (float)this.mGreen, (float)this.mBlue, (float)this.mAlpha);
        } else {
            GLES20.glClearColor((float)this.mRed, (float)this.mGreen, (float)this.mBlue, (float)this.mAlpha);
        }
        if (this.mEnableDepthBuffer) {
            clearMask |= 0x100;
            GLES20.glEnable((int)2929);
            GLES20.glDepthFunc((int)513);
            GLES20.glDepthMask((boolean)true);
            GLES20.glClearDepthf((float)1.0f);
        }
        if (this.mAntiAliasingConfig.equals((Object)ISurface.ANTI_ALIASING_CONFIG.COVERAGE)) {
            clearMask |= 0x8000;
        }
        GLES20.glClear((int)clearMask);
        int preCount = this.mPreCallbacks.size();
        if (preCount > 0) {
            list = this.mPreCallbacks;
            synchronized (list) {
                for (i2 = 0; i2 < preCount; ++i2) {
                    this.mPreCallbacks.get(i2).onPreFrame(ellapsedTime, deltaTime);
                }
            }
        }
        list = this.mAnimations;
        synchronized (list) {
            int j2 = this.mAnimations.size();
            for (i2 = 0; i2 < j2; ++i2) {
                Animation anim = this.mAnimations.get(i2);
                if (!anim.isPlaying()) continue;
                anim.update(deltaTime);
            }
        }
        this.mCamera.onRecalculateModelMatrix(null);
        this.mVMatrix = this.mCamera.getViewMatrix();
        this.mPMatrix = this.mCamera.getProjectionMatrix();
        this.mVPMatrix.setAll(this.mPMatrix).multiply(this.mVMatrix);
        this.mInvVPMatrix.setAll(this.mVPMatrix).inverse();
        this.mCamera.updateFrustum(this.mInvVPMatrix);
        list = this.mLights;
        synchronized (list) {
            int numLights = this.mLights.size();
            for (i = 0; i < numLights; ++i) {
                this.mLights.get(i).onRecalculateModelMatrix(null);
            }
        }
        int preDrawCount = this.mPreDrawCallbacks.size();
        if (preDrawCount > 0) {
            List<ASceneFrameCallback> numLights = this.mPreDrawCallbacks;
            synchronized (numLights) {
                for (i = 0; i < preDrawCount; ++i) {
                    this.mPreDrawCallbacks.get(i).onPreDraw(ellapsedTime, deltaTime);
                }
            }
        }
        if (this.mSkybox != null) {
            GLES20.glDisable((int)2929);
            GLES20.glDepthMask((boolean)false);
            this.mSkybox.setPosition(this.mCamera.getX(), this.mCamera.getY(), this.mCamera.getZ());
            this.mSkybox.render(this.mCamera, this.mVPMatrix, this.mPMatrix, this.mVMatrix, null);
            if (this.mEnableDepthBuffer) {
                GLES20.glEnable((int)2929);
                GLES20.glDepthMask((boolean)true);
            }
        }
        if (sceneMaterial != null) {
            sceneMaterial.useProgram();
            sceneMaterial.bindTextures();
        }
        List<Object> numLights = this.mChildren;
        synchronized (numLights) {
            j = this.mChildren.size();
            for (i = 0; i < j; ++i) {
                this.mChildren.get(i).render(this.mCamera, this.mVPMatrix, this.mPMatrix, this.mVMatrix, sceneMaterial);
            }
        }
        if (this.mDisplaySceneGraph) {
            this.mSceneGraph.displayGraph(this.mCamera, this.mVPMatrix, this.mPMatrix, this.mVMatrix);
        }
        if (sceneMaterial != null) {
            sceneMaterial.unbindTextures();
        }
        numLights = this.mPlugins;
        synchronized (numLights) {
            j = this.mPlugins.size();
            for (i = 0; i < j; ++i) {
                this.mPlugins.get(i).render();
            }
        }
        if (renderTarget != null) {
            renderTarget.unbind();
        }
        if ((postCount = this.mPostCallbacks.size()) > 0) {
            List<ASceneFrameCallback> list2 = this.mPostCallbacks;
            synchronized (list2) {
                for (int i3 = 0; i3 < postCount; ++i3) {
                    this.mPostCallbacks.get(i3).onPostFrame(ellapsedTime, deltaTime);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doColorPicking(ObjectColorPicker.ColorPickerInfo pickerInfo) {
        ObjectColorPicker picker = pickerInfo.getPicker();
        picker.getRenderTarget().bind();
        GLES20.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GLES20.glClear((int)16640);
        Material pickingMaterial = picker.getMaterial();
        GLES20.glDisable((int)3042);
        if (this.mSkybox != null && this.mSkybox.isPickingEnabled()) {
            GLES20.glDisable((int)2929);
            GLES20.glDepthMask((boolean)false);
            this.mSkybox.renderColorPicking(this.mCamera, pickingMaterial);
            GLES20.glEnable((int)2929);
            GLES20.glDepthMask((boolean)true);
        }
        List<Object3D> list = this.mChildren;
        synchronized (list) {
            int j = this.mChildren.size();
            for (int i = 0; i < j; ++i) {
                this.mChildren.get(i).renderColorPicking(this.mCamera, pickingMaterial);
            }
        }
        ObjectColorPicker.pickObject(pickerInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalOfferTask(AFrameTask task) {
        LinkedList<AFrameTask> linkedList = this.mFrameTaskQueue;
        synchronized (linkedList) {
            return this.mFrameTaskQueue.offer(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performFrameTasks() {
        LinkedList<AFrameTask> linkedList = this.mFrameTaskQueue;
        synchronized (linkedList) {
            AFrameTask task = this.mFrameTaskQueue.poll();
            while (task != null) {
                task.run();
                task = this.mFrameTaskQueue.poll();
            }
        }
    }

    public ArrayList<Camera> getCamerasCopy() {
        ArrayList<Camera> list = new ArrayList<Camera>();
        list.addAll(this.mCameras);
        return list;
    }

    public int getCameraCount() {
        return this.mCameras.size();
    }

    public List<ALight> getLights() {
        return this.mLights;
    }

    public ArrayList<ALight> getLightsCopy() {
        ArrayList<ALight> list = new ArrayList<ALight>();
        list.addAll(this.mLights);
        return list;
    }

    public int getNumLights() {
        return this.mLights.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markLightingDirty() {
        LinkedList<AFrameTask> linkedList = this.mFrameTaskQueue;
        synchronized (linkedList) {
            this.mLightsDirty = true;
        }
    }

    private void updateMaterialsWithLights() {
        for (Object3D child : this.mChildren) {
            this.updateChildMaterialWithLights(child);
        }
    }

    private void updateChildMaterialWithLights(Object3D child) {
        Material material = child.getMaterial();
        if (material != null && material.lightingEnabled()) {
            material.setLights(this.mLights);
        }
        if (material != null && this.mFogParams != null) {
            material.addPlugin(new FogMaterialPlugin(this.mFogParams));
        }
        int numChildren = child.getNumChildren();
        for (int i = 0; i < numChildren; ++i) {
            Object3D grandChild = child.getChildAt(i);
            this.updateChildMaterialWithLights(grandChild);
        }
    }

    public ArrayList<Object3D> getChildrenCopy() {
        ArrayList<Object3D> list = new ArrayList<Object3D>();
        list.addAll(this.mChildren);
        return list;
    }

    protected boolean hasChild(Object3D child) {
        return this.mChildren.contains(child);
    }

    public int getNumChildren() {
        return this.mChildren.size();
    }

    public ArrayList<IRendererPlugin> getPluginsCopy() {
        ArrayList<IRendererPlugin> list = new ArrayList<IRendererPlugin>();
        list.addAll(this.mPlugins);
        return list;
    }

    protected boolean hasPlugin(IRendererPlugin plugin) {
        return this.mPlugins.contains(plugin);
    }

    public int getNumPlugins() {
        return this.mPlugins.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadChildren() {
        List<Object3D> list = this.mChildren;
        synchronized (list) {
            int j = this.mChildren.size();
            for (int i = 0; i < j; ++i) {
                this.mChildren.get(i).reload();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadPlugins() {
        List<IRendererPlugin> list = this.mPlugins;
        synchronized (list) {
            int j = this.mPlugins.size();
            for (int i = 0; i < j; ++i) {
                this.mPlugins.get(i).reload();
            }
        }
    }

    public void destroyScene() {
        this.clearAnimations();
        this.clearCameras();
        this.clearLights();
        this.clearPlugins();
        this.clearChildren();
        this.clearFrameCallbacks();
    }

    public void setBackgroundColor(float red, float green, float blue, float alpha) {
        this.mRed = red;
        this.mGreen = green;
        this.mBlue = blue;
        this.mAlpha = alpha;
    }

    public void setBackgroundColor(int color) {
        this.setBackgroundColor((float)Color.red((int)color) / 255.0f, (float)Color.green((int)color) / 255.0f, (float)Color.blue((int)color) / 255.0f, (float)Color.alpha((int)color) / 255.0f);
    }

    public int getBackgroundColor() {
        return Color.argb((int)((int)(this.mAlpha * 255.0f)), (int)((int)(this.mRed * 255.0f)), (int)((int)(this.mGreen * 255.0f)), (int)((int)(this.mBlue * 255.0f)));
    }

    public void alwaysClearColorBuffer(boolean value) {
        this.mAlwaysClearColorBuffer = value;
    }

    public boolean alwaysClearColorBuffer() {
        return this.mAlwaysClearColorBuffer;
    }

    public void updateProjectionMatrix(int width, int height) {
        this.mCamera.setProjectionMatrix(width, height);
    }

    public void setAntiAliasingConfig(ISurface.ANTI_ALIASING_CONFIG config) {
        this.mAntiAliasingConfig = config;
    }

    public void setShadowMapMaterial(ShadowMapMaterial material) {
        this.mShadowMapMaterial = material;
    }

    private void addShadowMapMaterialPlugin(Object3D o, ShadowMapMaterialPlugin materialPlugin) {
        Material m = o.getMaterial();
        if (m != null && m.lightingEnabled()) {
            if (materialPlugin != null) {
                m.addPlugin(materialPlugin);
            } else if (this.mShadowMapMaterial != null) {
                m.removePlugin(this.mShadowMapMaterial.getMaterialPlugin());
            }
        }
        for (int i = 0; i < o.getNumChildren(); ++i) {
            this.addShadowMapMaterialPlugin(o.getChildAt(i), materialPlugin);
        }
    }

    public void displaySceneGraph(boolean display) {
        this.mDisplaySceneGraph = display;
    }

    public int getNumTriangles() {
        int triangleCount = 0;
        ArrayList<Object3D> children = this.getChildrenCopy();
        int j = children.size();
        for (int i = 0; i < j; ++i) {
            Object3D child = children.get(i);
            if (child.getGeometry() == null || child.getGeometry().getVertices() == null || !child.isVisible()) continue;
            if (child.getNumChildren() > 0) {
                triangleCount += child.getNumTriangles();
                continue;
            }
            triangleCount += child.getGeometry().getVertices().limit() / 9;
        }
        return triangleCount;
    }

    public int getNumObjects() {
        int objectCount = 0;
        ArrayList<Object3D> children = this.getChildrenCopy();
        int j = children.size();
        for (int i = 0; i < j; ++i) {
            Object3D child = children.get(i);
            if (child.getGeometry() == null || child.getGeometry().getVertices() == null || !child.isVisible()) continue;
            if (child.getNumChildren() > 0) {
                objectCount += child.getNumObjects() + 1;
                continue;
            }
            ++objectCount;
        }
        return objectCount;
    }
}

