/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.renderer.plugins;

import android.opengl.GLES20;
import org.rajawali3d.Geometry3D;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.renderer.plugins.IRendererPlugin;
import org.rajawali3d.util.RajLog;

public abstract class Plugin
implements IRendererPlugin {
    protected Geometry3D mGeometry = new Geometry3D();
    protected Renderer mRenderer;
    protected String mVertexShader;
    protected String mFragmentShader;
    protected int mVShaderHandle;
    protected int mFShaderHandle;
    protected int mProgram;
    protected boolean mProgramCreated = false;

    public Plugin(Renderer renderer) {
        this(renderer, true);
    }

    public Plugin(Renderer renderer, boolean createVBOs) {
        this.mRenderer = renderer;
        this.init(createVBOs);
    }

    protected int createProgram(String vertexShader, String fragmentShader) {
        this.mVShaderHandle = this.loadShader(35633, vertexShader);
        if (this.mVShaderHandle == 0) {
            return 0;
        }
        this.mFShaderHandle = this.loadShader(35632, fragmentShader);
        if (this.mFShaderHandle == 0) {
            return 0;
        }
        int program = GLES20.glCreateProgram();
        if (program != 0) {
            GLES20.glAttachShader((int)program, (int)this.mVShaderHandle);
            GLES20.glAttachShader((int)program, (int)this.mFShaderHandle);
            GLES20.glLinkProgram((int)program);
            int[] linkStatus = new int[1];
            GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
            if (linkStatus[0] != 1) {
                RajLog.e("Could not link program in " + this.getClass().getCanonicalName() + ": ");
                RajLog.e(GLES20.glGetProgramInfoLog((int)program));
                RajLog.d("-=-=-= VERTEX SHADER =-=-=-");
                RajLog.d(this.mVertexShader);
                RajLog.d("-=-=-= FRAGMENT SHADER =-=-=-");
                RajLog.d(this.mFragmentShader);
                GLES20.glDeleteProgram((int)program);
                program = 0;
            }
        }
        return program;
    }

    @Override
    public void destroy() {
        this.unload();
    }

    protected int getUniformLocation(String name) {
        return GLES20.glGetUniformLocation((int)this.mProgram, (String)name);
    }

    protected int getAttribLocation(String name) {
        return GLES20.glGetAttribLocation((int)this.mProgram, (String)name);
    }

    protected void init(boolean createVBOs) {
    }

    protected int loadShader(int shaderType, String source) {
        int shader = GLES20.glCreateShader((int)shaderType);
        if (shader != 0) {
            GLES20.glShaderSource((int)shader, (String)source);
            GLES20.glCompileShader((int)shader);
            int[] compiled = new int[1];
            GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
            if (compiled[0] == 0) {
                RajLog.e("[" + this.getClass().getName() + "] Could not compile " + (shaderType == 35632 ? "fragment" : "vertex") + " shader:");
                RajLog.e("Shader log: " + GLES20.glGetShaderInfoLog((int)shader));
                GLES20.glDeleteShader((int)shader);
                shader = 0;
            }
        }
        return shader;
    }

    @Override
    public void reload() {
        this.mGeometry.reload();
        this.setShaders(this.mVertexShader, this.mFragmentShader);
    }

    @Override
    public void render() {
        this.mGeometry.validateBuffers();
    }

    protected void setData(float[] vertices, float[] normals, float[] textureCoords, float[] colors, int[] indices, boolean createVBOs) {
        this.mGeometry.setData(vertices, normals, textureCoords, colors, indices, createVBOs);
    }

    protected void setShaders(String vertexShader, String fragmentShader) {
        this.mVertexShader = vertexShader;
        this.mFragmentShader = fragmentShader;
        this.mProgram = this.createProgram(vertexShader, fragmentShader);
        if (this.mProgram == 0) {
            RajLog.e("Failed to create program");
            return;
        }
        this.mProgramCreated = true;
    }

    public void unload() {
        GLES20.glDeleteShader((int)this.mVShaderHandle);
        GLES20.glDeleteShader((int)this.mFShaderHandle);
        GLES20.glDeleteProgram((int)this.mProgram);
    }

    protected void useProgram(int programHandle) {
        if (!this.mProgramCreated) {
            this.reload();
        }
        GLES20.glUseProgram((int)programHandle);
    }
}

