/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.renderer.plugins;

import android.opengl.GLES20;
import java.util.Stack;
import org.rajawali3d.cameras.Camera;
import org.rajawali3d.extras.LensFlare;
import org.rajawali3d.materials.textures.ASingleTexture;
import org.rajawali3d.math.Matrix4;
import org.rajawali3d.math.vector.Vector2;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.renderer.plugins.Plugin;

public final class LensFlarePlugin
extends Plugin {
    private static final String mVShaderVertexTexture = "precision highp float;\n\nuniform lowp int uRenderType;\nuniform vec3 uScreenPosition;\nuniform vec2 uScale;\nuniform float uRotation;\nuniform sampler2D uOcclusionMap;\n\nattribute vec2 aPosition;\nattribute vec2 aTextureCoord;\n\nvarying vec2 vTextureCoord;\nvarying float vVisibility;\n\nvoid main() {\n   vTextureCoord = aTextureCoord;\n\n   vec2 pos = aPosition;\n\n   if (uRenderType == 3) {\n      vec4 visibility = texture2D(uOcclusionMap, vec2(0.1, 0.1)) +\n                        texture2D(uOcclusionMap, vec2(0.5, 0.1)) +\n                        texture2D(uOcclusionMap, vec2(0.9, 0.1)) +\n                        texture2D(uOcclusionMap, vec2(0.1, 0.5)) +\n                        texture2D(uOcclusionMap, vec2(0.5, 0.5)) +\n                        texture2D(uOcclusionMap, vec2(0.9, 0.5)) +\n                        texture2D(uOcclusionMap, vec2(0.1, 0.9)) +\n                        texture2D(uOcclusionMap, vec2(0.5, 0.9)) +\n                        texture2D(uOcclusionMap, vec2(0.9, 0.9));\n\n      vVisibility = (visibility.r / 9.0) * (1.0 - visibility.g / 9.0) *\n                    (visibility.b / 9.0) * (visibility.a / 9.0);\n\n      pos.x = cos(uRotation) * aPosition.x - sin(uRotation) * aPosition.y;\n      pos.y = sin(uRotation) * aPosition.x + cos(uRotation) * aPosition.y;\n   }\n\n   gl_Position = vec4((pos * uScale + uScreenPosition.xy).xy, uScreenPosition.z, 1.0);\n}";
    private static final String mFShaderVertexTexture = "precision highp float;\n\nuniform lowp int uRenderType;\nuniform sampler2D uMap;\nuniform float uOpacity;\nuniform vec3 uColor;\nuniform lowp int uDebugMode;\n\nvarying vec2 vTextureCoord;\nvarying float vVisibility;\n\nvoid main() {\n   if (uRenderType == 1) {\n      gl_FragColor = vec4(1.0, 0.0, 1.0, 0.0);\n   } else if (uRenderType == 2) {\n      gl_FragColor = texture2D(uMap, vTextureCoord);\n   } else {\n      vec4 texture = texture2D(uMap, vTextureCoord);\n      if (uDebugMode == 1) {\n         texture.a = 1.0;\n      } else {\n         texture.a *= uOpacity * vVisibility;\n      }\n      gl_FragColor = texture;\n      gl_FragColor.rgb *= uColor;\n   }\n}";
    private static final String mVShaderNoVertexTexture = "precision highp float;\n\nuniform mediump int uRenderType;\nuniform vec3 uScreenPosition;\nuniform float uRotation;\nuniform vec2 uScale;\n\nattribute vec2 aPosition;\nattribute vec2 aTextureCoord;\n\nvarying vec2 vTextureCoord;\n\nvoid main() {\n   vTextureCoord = aTextureCoord;\n   vec2 pos = aPosition;\n   if (uRenderType == 3) {\n      pos.x = cos(uRotation) * aPosition.x - sin(uRotation) * aPosition.y;\n      pos.y = sin(uRotation) * aPosition.x + cos(uRotation) * aPosition.y;\n   }\n   gl_Position = vec4((pos * uScale + uScreenPosition.xy).xy, uScreenPosition.z, 1.0);\n}";
    private static final String mFShaderNoVertexTexture = "precision mediump float;\n\nuniform mediump int uRenderType;\nuniform lowp int uDebugMode;\nuniform mediump sampler2D uMap;\nuniform mediump sampler2D uOcclusionMap;\nuniform mediump sampler2D uFlareTexture;\nuniform float uOpacity;\nuniform vec3 uColor;\n\nvarying vec2 vTextureCoord;\n\nvoid main() {\n   if (uRenderType == 1) {\n      gl_FragColor = vec4(texture2D(uMap, vTextureCoord).rgb, 0.0);\n   } else if (uRenderType == 2) {\n      gl_FragColor = texture2D(uMap, vTextureCoord);\n   } else {\n      float finalVisibility = texture2D(uOcclusionMap, vec2(0.1, 0.1)).a +\n                              texture2D(uOcclusionMap, vec2(0.5, 0.1)).a +\n                              texture2D(uOcclusionMap, vec2(0.9, 0.1)).a +\n                              texture2D(uOcclusionMap, vec2(0.1, 0.5)).a +\n                              texture2D(uOcclusionMap, vec2(0.5, 0.5)).a +\n                              texture2D(uOcclusionMap, vec2(0.9, 0.5)).a +\n                              texture2D(uOcclusionMap, vec2(0.1, 0.9)).a +\n                              texture2D(uOcclusionMap, vec2(0.5, 0.9)).a +\n                              texture2D(uOcclusionMap, vec2(0.9, 0.9)).a;\n      finalVisibility = (1.0 - finalVisibility / 4.0);\n\n      vec4 texture = texture2D(uMap, vTextureCoord);\n      if (uDebugMode == 1) {\n         texture.a = 1.0;\n      } else {\n         texture.a *= uOpacity * finalVisibility;\n      }      gl_FragColor = texture;\n      gl_FragColor.rgb *= uColor;\n   }\n}";
    private Stack<LensFlare> mLensFlares;
    private boolean mVertexTextureSupported;
    private int maPositionHandle;
    private int maTextureCoordHandle;
    private int muRenderTypeHandle;
    private int muRotationHandle;
    private int muScreenPositionHandle;
    private int muOpacityHandle;
    private int muScaleHandle;
    private int muColorHandle;
    private int muMapTextureHandle;
    private int muOcclusionMapTextureHandle;
    private int muDebugModeHandle;
    private ASingleTexture mMapTexture;
    private ASingleTexture mOcclusionMapTexture;

    public LensFlarePlugin(Renderer renderer) {
        this(renderer, true);
    }

    public LensFlarePlugin(Renderer renderer, boolean createVBOs) {
        super(renderer, createVBOs);
    }

    @Override
    protected void init(boolean createVBOs) {
        this.mLensFlares = new Stack();
        int[] maxVertexTextureImageUnits = new int[1];
        GLES20.glGetIntegerv((int)35660, (int[])maxVertexTextureImageUnits, (int)0);
        this.mVertexTextureSupported = maxVertexTextureImageUnits[0] != 0;
        int i = 0;
        int j = 0;
        int numVertices = 8;
        float[] vertices = new float[numVertices];
        float[] textureCoords = new float[numVertices];
        float[] normals = new float[numVertices * 3];
        float[] colors = new float[numVertices * 4];
        int[] indices = new int[6];
        int vertexCount = 0;
        int texCoordCount = 0;
        vertices[vertexCount++] = -1.0f;
        vertices[vertexCount++] = -1.0f;
        vertices[vertexCount++] = 1.0f;
        vertices[vertexCount++] = -1.0f;
        vertices[vertexCount++] = 1.0f;
        vertices[vertexCount++] = 1.0f;
        vertices[vertexCount++] = -1.0f;
        vertices[vertexCount++] = 1.0f;
        for (j = 0; j < numVertices; j += 3) {
            normals[j] = 0.0f;
            normals[j + 1] = 1.0f;
            normals[j + 2] = 0.0f;
        }
        textureCoords[texCoordCount++] = 0.0f;
        textureCoords[texCoordCount++] = 0.0f;
        textureCoords[texCoordCount++] = 1.0f;
        textureCoords[texCoordCount++] = 0.0f;
        textureCoords[texCoordCount++] = 1.0f;
        textureCoords[texCoordCount++] = 1.0f;
        textureCoords[texCoordCount++] = 0.0f;
        textureCoords[texCoordCount++] = 1.0f;
        indices[i++] = 0;
        indices[i++] = 1;
        indices[i++] = 2;
        indices[i++] = 0;
        indices[i++] = 2;
        indices[i++] = 3;
        for (i = 0; i < colors.length; i += 4) {
            colors[i] = 1.0f;
            colors[i + 1] = 1.0f;
            colors[i + 2] = 0.0f;
            colors[i + 3] = 1.0f;
        }
        this.setData(vertices, normals, textureCoords, colors, indices, createVBOs);
        this.setShaders(mVShaderNoVertexTexture, mFShaderNoVertexTexture);
    }

    public void addLensFlare(LensFlare lensFlare) {
        this.mLensFlares.add(lensFlare);
    }

    public int getLensFlareCount() {
        return this.mLensFlares.size();
    }

    public boolean removeLensFlare(LensFlare lensFlare) {
        return this.mLensFlares.remove(lensFlare);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render() {
        super.render();
        int numLensFlares = this.mLensFlares.size();
        double viewportWidth = this.mRenderer.getViewportWidth();
        double viewportHeight = this.mRenderer.getDefaultViewportHeight();
        double invAspect = viewportHeight / viewportWidth;
        Vector2 scale = new Vector2();
        double halfViewportWidth = viewportWidth / 2.0;
        double halfViewportHeight = viewportHeight / 2.0;
        Vector3 screenPosition = new Vector3();
        Camera camera = this.mRenderer.getCurrentScene().getCamera();
        Matrix4 viewMatrix = camera.getViewMatrix().clone();
        Matrix4 projMatrix = camera.getProjectionMatrix().clone();
        this.useProgram(this.mProgram);
        GLES20.glBindBuffer((int)34962, (int)this.mGeometry.getVertexBufferInfo().bufferHandle);
        GLES20.glEnableVertexAttribArray((int)this.maPositionHandle);
        GLES20.glVertexAttribPointer((int)this.maPositionHandle, (int)2, (int)5126, (boolean)false, (int)0, (int)0);
        GLES20.glBindBuffer((int)34962, (int)0);
        GLES20.glBindBuffer((int)34962, (int)this.mGeometry.getTexCoordBufferInfo().bufferHandle);
        GLES20.glEnableVertexAttribArray((int)this.maTextureCoordHandle);
        GLES20.glVertexAttribPointer((int)this.maTextureCoordHandle, (int)2, (int)5126, (boolean)false, (int)0, (int)0);
        GLES20.glBindBuffer((int)34963, (int)this.mGeometry.getIndexBufferInfo().bufferHandle);
        GLES20.glUniform1i((int)this.muOcclusionMapTextureHandle, (int)0);
        GLES20.glUniform1i((int)this.muMapTextureHandle, (int)1);
        GLES20.glDisable((int)2884);
        GLES20.glDepthMask((boolean)false);
        Vector3 cameraPosition = camera.getPosition().clone();
        Vector3 cameraLookAt = camera.getLookAt() != null ? camera.getLookAt().clone() : new Vector3(0.0, 0.0, 1.0);
        Vector3 cameraDirection = cameraLookAt.clone().subtract(cameraPosition);
        cameraDirection.normalize();
        Stack<LensFlare> stack = this.mLensFlares;
        synchronized (stack) {
            for (int i = 0; i < numLensFlares; ++i) {
                double size = 16.0 / viewportHeight;
                scale.setX(size * invAspect);
                scale.setY(size);
                LensFlare lensFlare = (LensFlare)this.mLensFlares.get(i);
                screenPosition.setAll(lensFlare.getPosition().clone());
                screenPosition.multiply(viewMatrix);
                screenPosition.project(projMatrix);
                double screenPositionPixels_x = screenPosition.x * halfViewportWidth + halfViewportWidth;
                double screenPositionPixels_y = screenPosition.y * halfViewportHeight + halfViewportHeight;
                Vector3 lightToCamDirection = lensFlare.getPosition().clone().subtract(cameraPosition);
                lightToCamDirection.normalize();
                double angleLightCamera = lightToCamDirection.dot(cameraDirection);
                if (!this.mVertexTextureSupported && (!(angleLightCamera > 0.0) || !(screenPositionPixels_x > -64.0) || !(screenPositionPixels_x < viewportWidth + 64.0) || !(screenPositionPixels_y > -64.0) || !(screenPositionPixels_y < viewportHeight + 64.0))) continue;
                GLES20.glActiveTexture((int)33985);
                GLES20.glBindTexture((int)3553, (int)this.mMapTexture.getTextureId());
                GLES20.glCopyTexImage2D((int)3553, (int)0, (int)6407, (int)((int)screenPositionPixels_x - 8), (int)((int)screenPositionPixels_y - 8), (int)16, (int)16, (int)0);
                GLES20.glUniform1i((int)this.muRenderTypeHandle, (int)1);
                GLES20.glUniform2fv((int)this.muScaleHandle, (int)1, (float[])new float[]{(float)scale.getX(), (float)scale.getY()}, (int)0);
                GLES20.glUniform3fv((int)this.muScreenPositionHandle, (int)1, (float[])new float[]{(float)screenPosition.x, (float)screenPosition.y, (float)screenPosition.z}, (int)0);
                GLES20.glDisable((int)3042);
                GLES20.glEnable((int)2929);
                GLES20.glDrawElements((int)4, (int)6, (int)5125, (int)0);
                GLES20.glActiveTexture((int)33984);
                GLES20.glBindTexture((int)3553, (int)this.mOcclusionMapTexture.getTextureId());
                GLES20.glCopyTexImage2D((int)3553, (int)0, (int)6408, (int)((int)screenPositionPixels_x - 8), (int)((int)screenPositionPixels_y - 8), (int)16, (int)16, (int)0);
                GLES20.glUniform1i((int)this.muRenderTypeHandle, (int)2);
                GLES20.glDisable((int)2929);
                GLES20.glActiveTexture((int)33985);
                GLES20.glBindTexture((int)3553, (int)this.mMapTexture.getTextureId());
                GLES20.glDrawElements((int)4, (int)6, (int)5125, (int)0);
                lensFlare.setPositionScreen(screenPosition);
                lensFlare.updateLensFlares();
                GLES20.glUniform1i((int)this.muRenderTypeHandle, (int)3);
                GLES20.glEnable((int)3042);
                for (int f = 0; f < lensFlare.getLensFlares().size(); ++f) {
                    LensFlare.FlareInfo sprite = lensFlare.getLensFlares().get(f);
                    if (!(sprite.getOpacity() > 0.001) || !(sprite.getScale() > 0.001)) continue;
                    screenPosition.setAll(sprite.getScreenPosition());
                    size = (double)sprite.getSize() * sprite.getScale() / viewportHeight;
                    scale.setX(size * invAspect);
                    scale.setY(size);
                    GLES20.glUniform3fv((int)this.muScreenPositionHandle, (int)1, (float[])new float[]{(float)screenPosition.x, (float)screenPosition.y, (float)screenPosition.z}, (int)0);
                    GLES20.glUniform2fv((int)this.muScaleHandle, (int)1, (float[])new float[]{(float)scale.getX(), (float)scale.getY()}, (int)0);
                    GLES20.glUniform1f((int)this.muRotationHandle, (float)((float)sprite.getRotation()));
                    GLES20.glUniform1f((int)this.muOpacityHandle, (float)((float)sprite.getOpacity()));
                    GLES20.glUniform3fv((int)this.muColorHandle, (int)1, (float[])new float[]{(float)sprite.getColor().x, (float)sprite.getColor().y, (float)sprite.getColor().z}, (int)0);
                    GLES20.glActiveTexture((int)33985);
                    GLES20.glBindTexture((int)3553, (int)sprite.getTexture().getTextureId());
                    GLES20.glBlendFunc((int)770, (int)1);
                    GLES20.glDrawElements((int)4, (int)this.mGeometry.getNumIndices(), (int)5125, (int)0);
                    GLES20.glBindTexture((int)3553, (int)0);
                    GLES20.glBindBuffer((int)34962, (int)0);
                }
            }
        }
        GLES20.glBindBuffer((int)34963, (int)0);
        GLES20.glEnable((int)2884);
        GLES20.glEnable((int)2929);
        GLES20.glDepthMask((boolean)true);
    }

    @Override
    public void setShaders(String vertexShader, String fragmentShader) {
        super.setShaders(vertexShader, fragmentShader);
        this.maPositionHandle = this.getAttribLocation("aPosition");
        this.maTextureCoordHandle = this.getAttribLocation("aTextureCoord");
        this.muRenderTypeHandle = this.getUniformLocation("uRenderType");
        this.muScreenPositionHandle = this.getUniformLocation("uScreenPosition");
        this.muRotationHandle = this.getUniformLocation("uRotation");
        this.muScaleHandle = this.getUniformLocation("uScale");
        this.muOpacityHandle = this.getUniformLocation("uOpacity");
        this.muColorHandle = this.getUniformLocation("uColor");
        this.muMapTextureHandle = this.getUniformLocation("uMap");
        this.muOcclusionMapTextureHandle = this.getUniformLocation("uOcclusionMap");
        this.muDebugModeHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uDebugMode");
    }
}

