/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.renderer.pip;

import org.rajawali3d.Object3D;
import org.rajawali3d.cameras.Camera;
import org.rajawali3d.cameras.Camera2D;
import org.rajawali3d.materials.Material;
import org.rajawali3d.math.Matrix4;
import org.rajawali3d.postprocessing.passes.EffectPass;

public class WorkaroundScreenQuad
extends Object3D {
    private Camera2D mCamera;
    private Matrix4 mVPMatrix;
    private EffectPass mEffectPass;

    public WorkaroundScreenQuad() {
        this(true);
    }

    public WorkaroundScreenQuad(boolean createVBOs) {
        this.init(createVBOs);
    }

    private void init(boolean createVBOs) {
        this.mCamera = new Camera2D();
        this.mCamera.setProjectionMatrix(0, 0);
        this.mVPMatrix = new Matrix4();
        float[] vertices = new float[]{-0.5f, 0.5f, 0.0f, 0.5f, 0.5f, 0.0f, 0.5f, -0.5f, 0.0f, -0.5f, -0.5f, 0.0f};
        float[] textureCoords = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f};
        float[] normals = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
        int[] indices = new int[]{0, 2, 1, 0, 3, 2};
        this.setData(vertices, normals, textureCoords, null, indices, createVBOs);
        vertices = null;
        normals = null;
        textureCoords = null;
        indices = null;
        this.mEnableDepthTest = false;
        this.mEnableDepthMask = false;
    }

    @Override
    public void render(Camera camera, Matrix4 vpMatrix, Matrix4 projMatrix, Matrix4 vMatrix, Matrix4 parentMatrix, Material sceneMaterial) {
        Matrix4 pMatrix = this.mCamera.getProjectionMatrix();
        Matrix4 viewMatrix = this.mCamera.getViewMatrix();
        this.mVPMatrix.setAll(pMatrix).multiply(viewMatrix);
        super.render(this.mCamera, this.mVPMatrix, projMatrix, viewMatrix, null, sceneMaterial);
    }

    @Override
    protected void setShaderParams(Camera camera) {
        super.setShaderParams(camera);
        if (this.mEffectPass != null) {
            this.mEffectPass.setShaderParams();
        }
    }

    public void setEffectPass(EffectPass effectPass) {
        this.mEffectPass = effectPass;
    }
}

