/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.renderer;

import android.content.Context;
import android.opengl.GLES20;
import org.rajawali3d.cameras.Camera;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.textures.ATexture;
import org.rajawali3d.math.Quaternion;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.primitives.ScreenQuad;
import org.rajawali3d.renderer.RenderTarget;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.scene.Scene;

public abstract class SideBySideRenderer
extends Renderer {
    private Quaternion mCameraOrientation = new Quaternion();
    private Quaternion mScratchQuaternion1 = new Quaternion();
    private Quaternion mScratchQuaternion2 = new Quaternion();
    private final Object mCameraOrientationLock = new Object();
    private Camera mCameraLeft;
    private Camera mCameraRight;
    private int mViewportWidthHalf;
    private RenderTarget mLeftRenderTarget;
    private RenderTarget mRightRenderTarget;
    private Scene mUserScene;
    private Scene mSideBySideScene;
    private ScreenQuad mLeftQuad;
    private ScreenQuad mRightQuad;
    private Material mLeftQuadMaterial;
    private Material mRightQuadMaterial;
    private double mPupilDistance = 0.06;

    public SideBySideRenderer(Context context) {
        super(context);
    }

    public SideBySideRenderer(Context context, double pupilDistance) {
        this(context);
        this.mPupilDistance = pupilDistance;
    }

    @Override
    public void initScene() {
        this.mCameraLeft = new Camera();
        this.mCameraLeft.setNearPlane(0.01f);
        this.mCameraLeft.setFieldOfView(this.getCurrentCamera().getFieldOfView());
        this.mCameraLeft.setNearPlane(this.getCurrentCamera().getNearPlane());
        this.mCameraLeft.setFarPlane(this.getCurrentCamera().getFarPlane());
        this.mCameraRight = new Camera();
        this.mCameraRight.setNearPlane(0.01f);
        this.mCameraRight.setFieldOfView(this.getCurrentCamera().getFieldOfView());
        this.mCameraRight.setNearPlane(this.getCurrentCamera().getNearPlane());
        this.mCameraRight.setFarPlane(this.getCurrentCamera().getFarPlane());
        this.setPupilDistance(this.mPupilDistance);
        this.mLeftQuadMaterial = new Material();
        this.mLeftQuadMaterial.setColorInfluence(0.0f);
        this.mRightQuadMaterial = new Material();
        this.mRightQuadMaterial.setColorInfluence(0.0f);
        this.mSideBySideScene = new Scene(this);
        this.mLeftQuad = new ScreenQuad();
        this.mLeftQuad.setScaleX(0.5);
        this.mLeftQuad.setX(-0.25);
        this.mLeftQuad.setMaterial(this.mLeftQuadMaterial);
        this.mSideBySideScene.addChild(this.mLeftQuad);
        this.mRightQuad = new ScreenQuad();
        this.mRightQuad.setScaleX(0.5);
        this.mRightQuad.setX(0.25);
        this.mRightQuad.setMaterial(this.mRightQuadMaterial);
        this.mSideBySideScene.addChild(this.mRightQuad);
        this.addScene(this.mSideBySideScene);
        this.mViewportWidthHalf = (int)((float)this.mDefaultViewportWidth * 0.5f);
        this.mLeftRenderTarget = new RenderTarget("sbsLeftRT", this.mViewportWidthHalf, this.mDefaultViewportHeight);
        this.mLeftRenderTarget.setFullscreen(false);
        this.mRightRenderTarget = new RenderTarget("sbsRightRT", this.mViewportWidthHalf, this.mDefaultViewportHeight);
        this.mRightRenderTarget.setFullscreen(false);
        this.mCameraLeft.setProjectionMatrix(this.mViewportWidthHalf, this.mDefaultViewportHeight);
        this.mCameraRight.setProjectionMatrix(this.mViewportWidthHalf, this.mDefaultViewportHeight);
        this.addRenderTarget(this.mLeftRenderTarget);
        this.addRenderTarget(this.mRightRenderTarget);
        try {
            this.mLeftQuadMaterial.addTexture(this.mLeftRenderTarget.getTexture());
            this.mRightQuadMaterial.addTexture(this.mRightRenderTarget.getTexture());
        }
        catch (ATexture.TextureException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onRender(long ellapsedTime, double deltaTime) {
        this.mUserScene = this.getCurrentScene();
        this.setRenderTarget(this.mLeftRenderTarget);
        this.getCurrentScene().switchCamera(this.mCameraLeft);
        GLES20.glViewport((int)0, (int)0, (int)this.mViewportWidthHalf, (int)this.mDefaultViewportHeight);
        this.mCameraLeft.setProjectionMatrix(this.mViewportWidthHalf, this.mDefaultViewportHeight);
        this.mCameraLeft.setOrientation(this.mCameraOrientation);
        this.render(ellapsedTime, deltaTime);
        this.setRenderTarget(this.mRightRenderTarget);
        this.getCurrentScene().switchCamera(this.mCameraRight);
        this.mCameraRight.setProjectionMatrix(this.mViewportWidthHalf, this.mDefaultViewportHeight);
        this.mCameraRight.setOrientation(this.mCameraOrientation);
        this.render(ellapsedTime, deltaTime);
        this.switchSceneDirect(this.mSideBySideScene);
        GLES20.glViewport((int)0, (int)0, (int)this.mDefaultViewportWidth, (int)this.mDefaultViewportHeight);
        this.setRenderTarget(null);
        this.render(ellapsedTime, deltaTime);
        this.switchSceneDirect(this.mUserScene);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCameraOrientation(Quaternion cameraOrientation) {
        Object object = this.mCameraOrientationLock;
        synchronized (object) {
            this.mCameraOrientation.setAll(cameraOrientation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSensorOrientation(float[] quaternion) {
        Object object = this.mCameraOrientationLock;
        synchronized (object) {
            this.mCameraOrientation.x = quaternion[1];
            this.mCameraOrientation.y = quaternion[2];
            this.mCameraOrientation.z = quaternion[3];
            this.mCameraOrientation.w = quaternion[0];
            this.mScratchQuaternion1.fromAngleAxis(Vector3.Axis.X, -90.0);
            this.mScratchQuaternion1.multiply(this.mCameraOrientation);
            this.mScratchQuaternion2.fromAngleAxis(Vector3.Axis.Z, -90.0);
            this.mScratchQuaternion1.multiply(this.mScratchQuaternion2);
            this.mCameraOrientation.setAll(this.mScratchQuaternion1);
        }
    }

    public void setPupilDistance(double pupilDistance) {
        this.mPupilDistance = pupilDistance;
        if (this.mCameraLeft != null) {
            this.mCameraLeft.setX(pupilDistance * -0.5);
        }
        if (this.mCameraLeft != null) {
            this.mCameraRight.setX(pupilDistance * 0.5);
        }
    }

    public double getPupilDistance() {
        return this.mPupilDistance;
    }
}

