/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.renderer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.util.SparseArray;
import android.view.WindowManager;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.opengles.GL10;
import org.rajawali3d.cameras.Camera;
import org.rajawali3d.loader.ALoader;
import org.rajawali3d.loader.async.IAsyncLoaderCallback;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.MaterialManager;
import org.rajawali3d.materials.textures.ATexture;
import org.rajawali3d.materials.textures.RenderTargetTexture;
import org.rajawali3d.materials.textures.TextureManager;
import org.rajawali3d.math.Matrix;
import org.rajawali3d.math.Matrix4;
import org.rajawali3d.math.vector.Vector3;
import org.rajawali3d.renderer.AFrameTask;
import org.rajawali3d.renderer.ISurfaceRenderer;
import org.rajawali3d.renderer.RenderTarget;
import org.rajawali3d.scene.Scene;
import org.rajawali3d.util.Capabilities;
import org.rajawali3d.util.ObjectColorPicker;
import org.rajawali3d.util.OnFPSUpdateListener;
import org.rajawali3d.util.RajLog;
import org.rajawali3d.util.RawShaderLoader;
import org.rajawali3d.view.ISurface;

public abstract class Renderer
implements ISurfaceRenderer {
    protected static final int AVAILABLE_CORES = Runtime.getRuntime().availableProcessors();
    protected final Executor mLoaderExecutor = Executors.newFixedThreadPool(AVAILABLE_CORES == 1 ? 1 : AVAILABLE_CORES - 1);
    protected static boolean mFogEnabled;
    protected static int sMaxLights;
    protected Context mContext;
    protected ISurface mSurface;
    protected int mCurrentViewportWidth;
    protected int mCurrentViewportHeight;
    protected int mDefaultViewportWidth;
    protected int mDefaultViewportHeight;
    protected int mOverrideViewportWidth;
    protected int mOverrideViewportHeight;
    protected TextureManager mTextureManager;
    protected MaterialManager mMaterialManager;
    protected ScheduledExecutorService mTimer;
    protected double mFrameRate;
    protected int mFrameCount;
    protected double mLastMeasuredFPS;
    protected OnFPSUpdateListener mFPSUpdateListener;
    private long mStartTime = System.nanoTime();
    private long mLastRender;
    protected int mGLES_Major_Version = 2;
    protected int mGLES_Minor_Version = 0;
    private boolean mSceneCachingEnabled;
    protected boolean mSceneInitialized;
    protected boolean mEnableDepthBuffer = true;
    private RenderTarget mCurrentRenderTarget;
    private ISurface.ANTI_ALIASING_CONFIG mAntiAliasingConfig;
    protected final List<Scene> mScenes;
    protected final List<RenderTarget> mRenderTargets;
    private final Queue<AFrameTask> mFrameTaskQueue;
    private final SparseArray<ModelRunnable> mLoaderThreads;
    private final SparseArray<IAsyncLoaderCallback> mLoaderCallbacks;
    private Scene mCurrentScene;
    private Scene mNextScene;
    private final Object mNextSceneLock = new Object();
    private long mRenderStartTime;
    private AtomicInteger mLastLoaderId = new AtomicInteger();
    private final boolean mHaveRegisteredForResources;
    @SuppressLint(value={"HandlerLeak"})
    private final Handler mLoaderHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            int id = msg.arg2;
            ALoader loader = ((ModelRunnable)((Renderer)Renderer.this).mLoaderThreads.get((int)id)).mLoader;
            IAsyncLoaderCallback callback = (IAsyncLoaderCallback)Renderer.this.mLoaderCallbacks.get(id);
            Renderer.this.mLoaderThreads.remove(id);
            Renderer.this.mLoaderCallbacks.remove(id);
            switch (msg.arg1) {
                case 0: {
                    callback.onModelLoadFailed(loader);
                    break;
                }
                case 1: {
                    callback.onModelLoadComplete(loader);
                }
            }
        }
    };

    public static int getMaxLights() {
        return sMaxLights;
    }

    public static void setMaxLights(int maxLights) {
        sMaxLights = maxLights;
    }

    public static boolean hasGLContext() {
        EGL10 egl = (EGL10)EGLContext.getEGL();
        EGLContext eglContext = egl.eglGetCurrentContext();
        return eglContext != EGL10.EGL_NO_CONTEXT;
    }

    protected abstract void initScene();

    public Renderer(Context context) {
        this(context, false);
    }

    public Renderer(Context context, boolean registerForResources) {
        RajLog.i("Rajawali | Bombshell | v1.1.970 Release ");
        RajLog.i("This is a stable release.");
        this.mHaveRegisteredForResources = registerForResources;
        this.mContext = context;
        RawShaderLoader.mContext = new WeakReference<Context>(context);
        this.mFrameRate = this.getRefreshRate();
        this.mScenes = Collections.synchronizedList(new CopyOnWriteArrayList());
        this.mRenderTargets = Collections.synchronizedList(new CopyOnWriteArrayList());
        this.mFrameTaskQueue = new LinkedList<AFrameTask>();
        this.mSceneCachingEnabled = true;
        this.mSceneInitialized = false;
        this.mLoaderThreads = new SparseArray();
        this.mLoaderCallbacks = new SparseArray();
        Scene defaultScene = this.getNewDefaultScene();
        this.mScenes.add(defaultScene);
        this.mCurrentScene = defaultScene;
        this.clearOverrideViewportDimensions();
        this.mTextureManager = TextureManager.getInstance();
        this.mTextureManager.setContext(this.getContext());
        this.mMaterialManager = MaterialManager.getInstance();
        this.mMaterialManager.setContext(this.getContext());
        if (registerForResources) {
            this.mTextureManager.registerRenderer(this);
            this.mMaterialManager.registerRenderer(this);
        }
    }

    public Context getContext() {
        return this.mContext;
    }

    public TextureManager getTextureManager() {
        return this.mTextureManager;
    }

    @Override
    public double getFrameRate() {
        return this.mFrameRate;
    }

    @Override
    public void setFrameRate(int frameRate) {
        this.setFrameRate((double)frameRate);
    }

    @Override
    public void setFrameRate(double frameRate) {
        this.mFrameRate = frameRate;
        if (this.stopRendering()) {
            this.startRendering();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAntiAliasingMode(ISurface.ANTI_ALIASING_CONFIG config) {
        this.mAntiAliasingConfig = config;
        List<Scene> list = this.mScenes;
        synchronized (list) {
            int j = this.mScenes.size();
            for (int i = 0; i < j; ++i) {
                this.mScenes.get(i).setAntiAliasingConfig(config);
            }
        }
    }

    @Override
    public void onPause() {
        this.stopRendering();
    }

    @Override
    public void onResume() {
        if (this.mSceneInitialized) {
            this.getCurrentScene().resetGLState();
            this.startRendering();
        }
    }

    public void startRendering() {
        RajLog.d("startRendering()");
        if (!this.mSceneInitialized) {
            return;
        }
        this.mLastRender = this.mRenderStartTime = System.nanoTime();
        if (this.mTimer != null) {
            return;
        }
        this.mTimer = Executors.newScheduledThreadPool(1);
        this.mTimer.scheduleAtFixedRate(new RequestRenderTask(), 0L, (long)(1000.0 / this.mFrameRate), TimeUnit.MILLISECONDS);
    }

    public boolean stopRendering() {
        if (this.mTimer != null) {
            this.mTimer.shutdownNow();
            this.mTimer = null;
            return true;
        }
        return false;
    }

    public int getGLMajorVersion() {
        return this.mGLES_Major_Version;
    }

    public int getGLMinorVersion() {
        return this.mGLES_Minor_Version;
    }

    @Override
    public void setRenderSurface(ISurface surface) {
        this.mSurface = surface;
    }

    @Override
    public void onRenderSurfaceCreated(EGLConfig config, GL10 gl, int width, int height) {
        String[] versionParts;
        Capabilities.getInstance();
        String[] versionString = GLES20.glGetString((int)7938).split(" ");
        RajLog.d("Open GL ES Version String: " + GLES20.glGetString((int)7938));
        if (versionString.length >= 3 && (versionParts = versionString[2].split("\\.")).length >= 2) {
            this.mGLES_Major_Version = Integer.parseInt(versionParts[0]);
            versionParts[1] = versionParts[1].replaceAll("([^0-9].+)", "");
            this.mGLES_Minor_Version = Integer.parseInt(versionParts[1]);
        }
        RajLog.d(String.format(Locale.US, "Derived GL ES Version: %d.%d", this.mGLES_Major_Version, this.mGLES_Minor_Version));
        if (!this.mHaveRegisteredForResources) {
            this.mTextureManager.registerRenderer(this);
            this.mMaterialManager.registerRenderer(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRenderSurfaceDestroyed(SurfaceTexture surface) {
        this.stopRendering();
        List<Scene> list = this.mScenes;
        synchronized (list) {
            if (this.mTextureManager != null) {
                this.mTextureManager.unregisterRenderer(this);
                this.mTextureManager.taskReset(this);
            }
            if (this.mMaterialManager != null) {
                this.mMaterialManager.taskReset(this);
                this.mMaterialManager.unregisterRenderer(this);
            }
            int j = this.mScenes.size();
            for (int i = 0; i < j; ++i) {
                this.mScenes.get(i).destroyScene();
            }
        }
    }

    @Override
    public void onRenderSurfaceSizeChanged(GL10 gl, int width, int height) {
        this.mDefaultViewportWidth = width;
        this.mDefaultViewportHeight = height;
        int wViewport = this.mOverrideViewportWidth > -1 ? this.mOverrideViewportWidth : this.mDefaultViewportWidth;
        int hViewport = this.mOverrideViewportHeight > -1 ? this.mOverrideViewportHeight : this.mDefaultViewportHeight;
        this.setViewPort(wViewport, hViewport);
        if (!this.mSceneInitialized) {
            this.getCurrentScene().resetGLState();
            this.initScene();
            this.getCurrentScene().initScene();
        }
        if (!this.mSceneCachingEnabled) {
            this.mTextureManager.reset();
            this.mMaterialManager.reset();
            this.clearScenes();
        } else if (this.mSceneCachingEnabled && this.mSceneInitialized) {
            int j = this.mRenderTargets.size();
            for (int i = 0; i < j; ++i) {
                if (!this.mRenderTargets.get(i).getFullscreen()) continue;
                this.mRenderTargets.get(i).setWidth(this.mDefaultViewportWidth);
                this.mRenderTargets.get(i).setHeight(this.mDefaultViewportHeight);
            }
            this.mTextureManager.taskReload();
            this.mMaterialManager.taskReload();
            this.reloadScenes();
            this.reloadRenderTargets();
        }
        this.mSceneInitialized = true;
        this.startRendering();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRenderFrame(GL10 gl) {
        this.performFrameTasks();
        Object object = this.mNextSceneLock;
        synchronized (object) {
            if (this.mNextScene != null) {
                this.switchSceneDirect(this.mNextScene);
                this.mNextScene = null;
            }
        }
        long currentTime = System.nanoTime();
        long elapsedRenderTime = currentTime - this.mRenderStartTime;
        double deltaTime = (double)(currentTime - this.mLastRender) / 1.0E9;
        this.mLastRender = currentTime;
        this.onRender(elapsedRenderTime, deltaTime);
        ++this.mFrameCount;
        if (this.mFrameCount % 50 == 0) {
            long now = System.nanoTime();
            double elapsedS = (double)(now - this.mStartTime) / 1.0E9;
            double msPerFrame = 1000.0 * elapsedS / (double)this.mFrameCount;
            this.mLastMeasuredFPS = 1000.0 / msPerFrame;
            this.mFrameCount = 0;
            this.mStartTime = now;
            if (this.mFPSUpdateListener != null) {
                this.mFPSUpdateListener.onFPSUpdate(this.mLastMeasuredFPS);
            }
        }
    }

    protected void onRender(long ellapsedRealtime, double deltaTime) {
        this.render(ellapsedRealtime, deltaTime);
    }

    protected void render(long ellapsedRealtime, double deltaTime) {
        this.mCurrentScene.render(ellapsedRealtime, deltaTime, this.mCurrentRenderTarget);
    }

    public boolean getSceneInitialized() {
        return this.mSceneInitialized;
    }

    public void setSceneCachingEnabled(boolean enabled) {
        this.mSceneCachingEnabled = enabled;
    }

    public boolean getSceneCachingEnabled() {
        return this.mSceneCachingEnabled;
    }

    public Vector3 unProject(double x, double y, double z) {
        x = (double)this.mDefaultViewportWidth - x;
        y = (double)this.mDefaultViewportHeight - y;
        double[] in = new double[4];
        double[] out = new double[4];
        Matrix4 projectionMatrix = this.getCurrentCamera().getProjectionMatrix().clone();
        Matrix4 MVPMatrix = projectionMatrix.multiply(this.getCurrentCamera().getViewMatrix());
        MVPMatrix.inverse();
        in[0] = x / (double)this.mDefaultViewportWidth * 2.0 - 1.0;
        in[1] = y / (double)this.mDefaultViewportHeight * 2.0 - 1.0;
        in[2] = 2.0 * z - 1.0;
        in[3] = 1.0;
        Matrix.multiplyMV(out, 0, MVPMatrix.getDoubleValues(), 0, in, 0);
        if (out[3] == 0.0) {
            return null;
        }
        out[3] = 1.0 / out[3];
        return new Vector3(out[0] * out[3], out[1] * out[3], out[2] * out[3]);
    }

    public double getRefreshRate() {
        return ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getRefreshRate();
    }

    public void setFPSUpdateListener(OnFPSUpdateListener listener) {
        this.mFPSUpdateListener = listener;
    }

    public void setRenderTarget(RenderTarget renderTarget) {
        this.mCurrentRenderTarget = renderTarget;
    }

    public RenderTarget getRenderTarget() {
        return this.mCurrentRenderTarget;
    }

    public void setViewPort(int width, int height) {
        if (width != this.mCurrentViewportWidth || height != this.mCurrentViewportHeight) {
            this.mCurrentViewportWidth = width;
            this.mCurrentViewportHeight = height;
            this.mCurrentScene.updateProjectionMatrix(width, height);
            GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        }
    }

    public int getDefaultViewportWidth() {
        return this.mDefaultViewportWidth;
    }

    public int getDefaultViewportHeight() {
        return this.mDefaultViewportHeight;
    }

    public void clearOverrideViewportDimensions() {
        this.mOverrideViewportWidth = -1;
        this.mOverrideViewportHeight = -1;
        this.setViewPort(this.mDefaultViewportWidth, this.mDefaultViewportHeight);
    }

    public void setOverrideViewportDimensions(int width, int height) {
        this.mOverrideViewportWidth = width;
        this.mOverrideViewportHeight = height;
        this.setViewPort(this.mOverrideViewportWidth, this.mOverrideViewportHeight);
    }

    public int getOverrideViewportWidth() {
        return this.mOverrideViewportWidth;
    }

    public int getOverrideViewportHeight() {
        return this.mOverrideViewportHeight;
    }

    public int getViewportWidth() {
        return this.mCurrentViewportWidth;
    }

    public int getViewportHeight() {
        return this.mCurrentViewportHeight;
    }

    public ALoader loadModel(ALoader loader, IAsyncLoaderCallback callback, int tag) {
        loader.setTag(tag);
        try {
            int id = this.mLastLoaderId.getAndIncrement();
            ModelRunnable runnable = new ModelRunnable(loader, id);
            this.mLoaderThreads.put(id, (Object)runnable);
            this.mLoaderCallbacks.put(id, (Object)callback);
            this.mLoaderExecutor.execute(runnable);
        }
        catch (Exception e) {
            callback.onModelLoadFailed(loader);
        }
        return loader;
    }

    public ALoader loadModel(Class<? extends ALoader> loaderClass, IAsyncLoaderCallback callback, int resID) {
        return this.loadModel(loaderClass, callback, resID, resID);
    }

    public ALoader loadModel(Class<? extends ALoader> loaderClass, IAsyncLoaderCallback callback, int resID, int tag) {
        try {
            Constructor<? extends ALoader> constructor = loaderClass.getConstructor(Resources.class, TextureManager.class, Integer.TYPE);
            ALoader loader = constructor.newInstance(this.getContext().getResources(), this.getTextureManager(), resID);
            return this.loadModel(loader, callback, tag);
        }
        catch (Exception e) {
            callback.onModelLoadFailed(null);
            return null;
        }
    }

    public Camera getCurrentCamera() {
        return this.mCurrentScene.getCamera();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchScene(Scene scene) {
        Object object = this.mNextSceneLock;
        synchronized (object) {
            this.mNextScene = scene;
        }
    }

    public void switchSceneDirect(Scene nextScene) {
        this.mCurrentScene = nextScene;
        this.mCurrentScene.markLightingDirty();
        this.mCurrentScene.resetGLState();
        int wViewport = this.mOverrideViewportWidth > -1 ? this.mOverrideViewportWidth : this.mDefaultViewportWidth;
        int hViewport = this.mOverrideViewportHeight > -1 ? this.mOverrideViewportHeight : this.mDefaultViewportHeight;
        this.mCurrentScene.getCamera().setProjectionMatrix(wViewport, hViewport);
    }

    public void switchScene(int scene) {
        this.switchScene(this.mScenes.get(scene));
    }

    public Scene getCurrentScene() {
        return this.mCurrentScene;
    }

    public Scene getScene(int scene) {
        return this.mScenes.get(scene);
    }

    public boolean replaceScene(final Scene scene, final int location) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Renderer.this.mScenes.set(location, scene);
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean replaceScene(final Scene oldScene, final Scene newScene) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Renderer.this.mScenes.set(Renderer.this.mScenes.indexOf(oldScene), newScene);
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean addScene(final Scene scene) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Renderer.this.mScenes.add(scene);
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean addScenes(final Collection<Scene> scenes) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Renderer.this.mScenes.addAll(scenes);
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean removeScene(final Scene scene) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Renderer.this.mScenes.remove(scene);
            }
        };
        return this.internalOfferTask(task);
    }

    protected void clearScenes() {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Renderer.this.mScenes.clear();
            }
        };
        this.internalOfferTask(task);
    }

    public boolean addAndSwitchScene(Scene scene) {
        boolean success = this.addScene(scene);
        this.switchScene(scene);
        return success;
    }

    public boolean replaceAndSwitchScene(Scene scene, int location) {
        boolean success = this.replaceScene(scene, location);
        this.switchScene(scene);
        return success;
    }

    public boolean replaceAndSwitchScene(Scene oldScene, Scene newScene) {
        boolean success = this.replaceScene(oldScene, newScene);
        this.switchScene(newScene);
        return success;
    }

    public boolean addRenderTarget(final RenderTarget renderTarget) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                renderTarget.create();
                Renderer.this.mRenderTargets.add(renderTarget);
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean removeRenderTarget(final RenderTarget renderTarget) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Renderer.this.mRenderTargets.remove(renderTarget);
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean addTexture(final ATexture texture) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Renderer.this.mTextureManager.taskAdd(texture);
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean removeTexture(final ATexture texture) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Renderer.this.mTextureManager.taskRemove(texture);
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean replaceTexture(final ATexture texture) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Renderer.this.mTextureManager.taskReplace(texture);
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean reloadTextures() {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Renderer.this.mTextureManager.taskReload();
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean resetTextures() {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Renderer.this.mTextureManager.taskReset();
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean resizeRenderTarget(final @NonNull RenderTargetTexture renderTargetTexture) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Renderer.this.mTextureManager.taskResizeRenderTarget(renderTargetTexture);
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean addMaterial(final Material material) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Renderer.this.mMaterialManager.taskAdd(material);
                if (Renderer.this.mSceneInitialized) {
                    Renderer.this.getCurrentScene().markLightingDirty();
                }
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean removeMaterial(final Material material) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Renderer.this.mMaterialManager.taskRemove(material);
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean reloadMaterials() {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Renderer.this.mMaterialManager.taskReload();
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean resetMaterials() {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                Renderer.this.mMaterialManager.taskReset();
            }
        };
        return this.internalOfferTask(task);
    }

    public boolean initializeColorPicker(final ObjectColorPicker picker) {
        AFrameTask task = new AFrameTask(){

            @Override
            protected void doTask() {
                picker.initialize();
            }
        };
        return this.internalOfferTask(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reloadScenes() {
        List<Scene> list = this.mScenes;
        synchronized (list) {
            int j = this.mScenes.size();
            for (int i = 0; i < j; ++i) {
                this.mScenes.get(i).reload();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reloadRenderTargets() {
        List<RenderTarget> list = this.mRenderTargets;
        synchronized (list) {
            int j = this.mRenderTargets.size();
            for (int i = 0; i < j; ++i) {
                this.mRenderTargets.get(i).reload();
            }
        }
    }

    protected Scene getNewDefaultScene() {
        return new Scene(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalOfferTask(AFrameTask task) {
        Queue<AFrameTask> queue = this.mFrameTaskQueue;
        synchronized (queue) {
            return this.mFrameTaskQueue.offer(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performFrameTasks() {
        Queue<AFrameTask> queue = this.mFrameTaskQueue;
        synchronized (queue) {
            AFrameTask task = this.mFrameTaskQueue.poll();
            while (task != null) {
                task.run();
                task = this.mFrameTaskQueue.poll();
            }
        }
    }

    static {
        sMaxLights = 1;
    }

    private final class ModelRunnable
    implements Runnable {
        final int id;
        final ALoader mLoader;

        public ModelRunnable(ALoader loader, int id) {
            this.id = id;
            this.mLoader = loader;
        }

        @Override
        public void run() {
            Message msg = Message.obtain();
            msg.arg2 = this.id;
            try {
                this.mLoader.parse();
                msg.arg1 = 1;
            }
            catch (Exception e) {
                e.printStackTrace();
                msg.arg1 = 0;
            }
            Renderer.this.mLoaderHandler.sendMessage(msg);
        }
    }

    private class RequestRenderTask
    implements Runnable {
        private RequestRenderTask() {
        }

        @Override
        public void run() {
            if (Renderer.this.mSurface != null) {
                Renderer.this.mSurface.requestRenderUpdate();
            }
        }
    }
}

