/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.renderer;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLU;
import org.rajawali3d.materials.textures.ATexture;
import org.rajawali3d.materials.textures.RenderTargetTexture;
import org.rajawali3d.materials.textures.TextureManager;
import org.rajawali3d.util.RajLog;

public class RenderTarget {
    protected int mWidth;
    protected int mHeight;
    protected int mOffsetX;
    protected int mOffsetY;
    protected String mName;
    protected boolean mMipmaps;
    protected int mGLType;
    protected Bitmap.Config mBitmapConfig;
    protected ATexture.FilterType mFilterType;
    protected ATexture.WrapType mWrapType;
    protected boolean mStencilBuffer;
    protected boolean mFullscreen = true;
    protected int mFrameBufferHandle;
    protected int mDepthBufferHandle;
    protected int mStencilBufferHandle;
    protected RenderTargetTexture mTexture;

    public RenderTarget(String name, int width, int height, int offsetX, int offsetY, boolean stencilBuffer, boolean mipmaps, int glType, Bitmap.Config bitmapConfig, ATexture.FilterType filterType, ATexture.WrapType wrapType) {
        this.mName = name;
        this.mWidth = width;
        this.mHeight = height;
        this.mOffsetX = offsetX;
        this.mOffsetY = offsetY;
        this.mStencilBuffer = stencilBuffer;
        this.mMipmaps = mipmaps;
        this.mGLType = glType;
        this.mBitmapConfig = bitmapConfig;
        this.mFilterType = filterType;
        this.mWrapType = wrapType;
        this.mTexture = new RenderTargetTexture(this.mName + "FBTex", this.mWidth, this.mHeight);
        this.mTexture.setMipmap(this.mMipmaps);
        this.mTexture.setGLTextureType(this.mGLType);
        this.mTexture.setBitmapConfig(this.mBitmapConfig);
        this.mTexture.setFilterType(this.mFilterType);
        this.mTexture.setWrapType(this.mWrapType);
        TextureManager.getInstance().addTexture(this.mTexture);
    }

    public RenderTarget(String name, int width, int height) {
        this(name, width, height, 0, 0, false, false, 3553, Bitmap.Config.ARGB_8888, ATexture.FilterType.LINEAR, ATexture.WrapType.CLAMP);
    }

    public RenderTarget clone() {
        return new RenderTarget(this.mName, this.mWidth, this.mHeight, this.mOffsetX, this.mOffsetY, this.mStencilBuffer, this.mTexture.isMipmap(), this.mTexture.getGLTextureType(), this.mTexture.getBitmapConfig(), this.mTexture.getFilterType(), this.mTexture.getWrapType());
    }

    public boolean isStencilBufferEnabled() {
        return this.mStencilBuffer;
    }

    public void enableStencilBuffer(boolean stencilBuffer) {
        this.mStencilBuffer = stencilBuffer;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public void setHeight(int height) {
        this.mHeight = height;
        this.mTexture.setHeight(height);
    }

    public void resize(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        this.mTexture.resize(width, height);
    }

    public int getOffsetX() {
        return this.mOffsetX;
    }

    public void setOffsetX(int offsetX) {
        this.mOffsetX = offsetX;
    }

    public int getOffsetY() {
        return this.mOffsetY;
    }

    public void setOffsetY(int offsetY) {
        this.mOffsetY = offsetY;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public void setWidth(int width) {
        this.mWidth = width;
        this.mTexture.setWidth(width);
    }

    public void create() {
        int[] bufferHandles = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])bufferHandles, (int)0);
        this.mFrameBufferHandle = bufferHandles[0];
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBufferHandle);
        this.checkGLError("Could not create framebuffer: ");
        TextureManager.getInstance().taskAdd(this.mTexture);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mTexture.getTextureId(), (int)0);
        this.checkGLError("Could not create framebuffer 2: ");
        GLES20.glGenRenderbuffers((int)1, (int[])bufferHandles, (int)0);
        GLES20.glBindRenderbuffer((int)36161, (int)bufferHandles[0]);
        GLES20.glRenderbufferStorage((int)36161, (int)33189, (int)this.mWidth, (int)this.mHeight);
        GLES20.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)bufferHandles[0]);
        this.checkGLError("Could not create framebuffer 3: ");
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    public void bind() {
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBufferHandle);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mTexture.getTextureId(), (int)0);
        int status = GLES20.glCheckFramebufferStatus((int)36160);
        if (status != 36053) {
            GLES20.glBindFramebuffer((int)36160, (int)0);
            String errorString = "";
            switch (status) {
                case 36061: {
                    errorString = "GL_FRAMEBUFFER_UNSUPPORTED: returned if the combination of internal formats of the attached images violates an implementation-dependent set of restrictions.";
                    break;
                }
                case 36054: {
                    errorString = "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT: returned if any of the framebuffer attachment points are framebuffer incomplete.";
                    break;
                }
                case 36055: {
                    errorString = "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT: returned if the framebuffer does not have at least one image attached to it.";
                    break;
                }
                case 36057: {
                    errorString = "GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS: not all attached images have the same width and height.";
                    RajLog.i(this.mWidth + ", " + this.mHeight + " || " + this.mTexture.getWidth() + ", " + this.mTexture.getHeight());
                }
            }
            throw new RuntimeException(errorString);
        }
    }

    public void unbind() {
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    public void remove() {
        GLES20.glDeleteFramebuffers((int)36160, (int[])new int[]{this.mFrameBufferHandle}, (int)0);
    }

    public void reload() {
        this.create();
    }

    public void checkGLError(String ex) {
        int error = GLES20.glGetError();
        if (error != 0) {
            String description = GLU.gluErrorString((int)error);
            RajLog.e(ex + "[" + error + "]: " + description);
            throw new RuntimeException(ex + "[" + error + "]: " + description);
        }
    }

    public void setFullscreen(boolean fullscreen) {
        this.mFullscreen = fullscreen;
    }

    public boolean getFullscreen() {
        return this.mFullscreen;
    }

    public RenderTargetTexture getTexture() {
        return this.mTexture;
    }

    public int getFrameBufferHandle() {
        return this.mFrameBufferHandle;
    }

    public String getName() {
        return this.mName;
    }
}

