/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.renderer;

import android.content.Context;
import android.util.Log;
import android.view.MotionEvent;
import org.rajawali3d.materials.Material;
import org.rajawali3d.materials.textures.ATexture;
import org.rajawali3d.renderer.RenderTarget;
import org.rajawali3d.renderer.Renderer;
import org.rajawali3d.renderer.pip.SubRenderer;
import org.rajawali3d.renderer.pip.WorkaroundScreenQuad;
import org.rajawali3d.scene.Scene;

public class PipRenderer
extends Renderer {
    private static final String TAG = "PipRenderer";
    private RenderTarget mMainRenderTarget;
    private RenderTarget mMiniRenderTarget;
    private WorkaroundScreenQuad mMiniQuad;
    private WorkaroundScreenQuad mMainQuad;
    private Material mMiniQuadMaterial;
    private Material mMainQuadMaterial;
    private Scene mCompositeScene;
    private SubRenderer mMiniRenderer;
    private SubRenderer mMainRenderer;
    private final float mPipScale;
    private final float mPipMarginX;
    private final float mPipMarginY;
    private float mMiniXmin;
    private float mMiniXmax;
    private float mMiniYmin;
    private float mMiniYmax;

    public PipRenderer(Context context, float pipScale, float pipMarginX, float pipMarginY) {
        super(context);
        this.mPipScale = pipScale;
        this.mPipMarginX = pipMarginX;
        this.mPipMarginY = pipMarginY;
    }

    public void setMiniRenderer(SubRenderer miniRenderer) {
        this.mMiniRenderer = miniRenderer;
    }

    public void setMainRenderer(SubRenderer mainRenderer) {
        this.mMainRenderer = mainRenderer;
    }

    @Override
    public void initScene() {
        this.mMainQuadMaterial = new Material();
        this.mMainQuadMaterial.setColorInfluence(0.0f);
        this.mMiniQuadMaterial = new Material();
        this.mMiniQuadMaterial.setColorInfluence(0.0f);
        this.mMainQuad = new WorkaroundScreenQuad();
        this.mMainQuad.setMaterial(this.mMainQuadMaterial);
        this.mMainQuad.setTransparent(true);
        this.setupMiniTouchLimits();
        this.mMiniQuad = new WorkaroundScreenQuad();
        this.mMiniQuad.setScale(this.mPipScale);
        this.mMiniQuad.setX(0.5 - (double)this.mPipScale / 2.0 - (double)(this.mPipMarginX / (float)this.mDefaultViewportWidth));
        this.mMiniQuad.setY(0.5 - (double)this.mPipScale / 2.0 - (double)(this.mPipMarginY / (float)this.mDefaultViewportHeight));
        this.mMiniQuad.setMaterial(this.mMiniQuadMaterial);
        this.mMainRenderTarget = new RenderTarget("pipMainRT", this.mDefaultViewportWidth, this.mDefaultViewportHeight);
        this.mMainRenderTarget.setFullscreen(false);
        this.mMiniRenderTarget = new RenderTarget("pipMiniRT", this.mDefaultViewportWidth, this.mDefaultViewportHeight);
        this.mMiniRenderTarget.setFullscreen(false);
        this.addRenderTarget(this.mMainRenderTarget);
        this.addRenderTarget(this.mMiniRenderTarget);
        this.mCompositeScene = this.getCurrentScene();
        this.mCompositeScene.addChild(this.mMainQuad);
        this.mCompositeScene.addChild(this.mMiniQuad);
        try {
            this.mMiniQuadMaterial.addTexture(this.mMiniRenderTarget.getTexture());
            this.mMainQuadMaterial.addTexture(this.mMainRenderTarget.getTexture());
        }
        catch (ATexture.TextureException e) {
            e.printStackTrace();
        }
        this.mMainRenderer.initScene();
        this.mMiniRenderer.initScene();
    }

    @Override
    protected void onRender(long ellapsedTime, double deltaTime) {
        try {
            this.switchSceneDirect(this.mMiniRenderer.getCurrentScene());
            this.mMiniRenderer.doRender();
            this.setRenderTarget(this.mMiniRenderTarget);
            this.render(ellapsedTime, deltaTime);
            this.switchSceneDirect(this.mMainRenderer.getCurrentScene());
            this.mMainRenderer.doRender();
            this.setRenderTarget(this.mMainRenderTarget);
            this.render(ellapsedTime, deltaTime);
            this.switchSceneDirect(this.mCompositeScene);
            this.setRenderTarget(null);
            this.render(ellapsedTime, deltaTime);
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)"Exception in render loop.", (Throwable)t);
        }
    }

    private void setupMiniTouchLimits() {
        float minX = 1.0f - this.mPipScale - this.mPipMarginX / (float)this.mDefaultViewportWidth;
        float maxX = 1.0f - this.mPipMarginX / (float)this.mDefaultViewportWidth;
        float minY = 1.0f - this.mPipScale - this.mPipMarginX / (float)this.mDefaultViewportHeight;
        float maxY = 1.0f - this.mPipMarginX / (float)this.mDefaultViewportHeight;
        this.mMiniXmin = minX * (float)this.mDefaultViewportWidth;
        this.mMiniXmax = maxX * (float)this.mDefaultViewportWidth;
        this.mMiniYmin = (1.0f - maxY) * (float)this.mDefaultViewportHeight;
        this.mMiniYmax = (1.0f - minY) * (float)this.mDefaultViewportHeight;
    }

    @Override
    public void onOffsetsChanged(float xOffset, float yOffset, float xOffsetStep, float yOffsetStep, int xPixelOffset, int yPixelOffset) {
    }

    @Override
    public void onTouchEvent(MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        if (x > this.mMiniXmin && x < this.mMiniXmax && y > this.mMiniYmin && y < this.mMiniYmax) {
            this.mMiniRenderer.onTouchEvent(event);
        } else {
            this.mMainRenderer.onTouchEvent(event);
        }
    }
}

