/*
 * Decompiled with CFR 0.152.
 */
package org.rajawali3d.primitives;

import org.rajawali3d.Object3D;

public class Torus
extends Object3D {
    private final float PI = (float)Math.PI;
    private float mLargeRadius;
    private float mSmallRadius;
    private int mSegmentsL;
    private int mSegmentsS;
    private boolean mCreateTextureCoords;
    private boolean mCreateVertexColorBuffer;

    public Torus(float largeRadius, float smallRadius, int segmentsL, int segmentsS) {
        this(largeRadius, smallRadius, segmentsL, segmentsS, true, false, true);
    }

    public Torus(float largeRadius, float smallRadius, int segmentsL, int segmentsS, boolean createTextureCoordinates, boolean createVertexColorBuffer, boolean createVBOs) {
        this.mLargeRadius = largeRadius;
        this.mSmallRadius = smallRadius;
        this.mSegmentsL = segmentsL;
        this.mSegmentsS = segmentsS;
        this.mCreateTextureCoords = createTextureCoordinates;
        this.mCreateVertexColorBuffer = createVertexColorBuffer;
        this.init(createVBOs);
    }

    protected void init(boolean createVBOs) {
        int i;
        int j;
        int numVertices = (this.mSegmentsS + 1) * (this.mSegmentsL + 1);
        int numIndices = 2 * this.mSegmentsS * this.mSegmentsL * 3;
        float[] vertices = new float[numVertices * 3];
        float[] normals = new float[numVertices * 3];
        int[] indices = new int[numIndices];
        int vertIndex = 0;
        int index = 0;
        float normLen = 1.0f / this.mSmallRadius;
        for (j = 0; j <= this.mSegmentsL; ++j) {
            float largeRadiusAngle = (float)Math.PI * 2 * (float)j / (float)this.mSegmentsL;
            for (i = 0; i <= this.mSegmentsS; ++i) {
                float zNorm;
                float smallRadiusAngle = (float)Math.PI * 2 * (float)i / (float)this.mSegmentsS;
                float xNorm = this.mSmallRadius * (float)Math.sin(smallRadiusAngle) * (float)Math.sin(largeRadiusAngle);
                float x = (this.mLargeRadius + this.mSmallRadius * (float)Math.sin(smallRadiusAngle)) * (float)Math.sin(largeRadiusAngle);
                float yNorm = this.mSmallRadius * (float)Math.sin(smallRadiusAngle) * (float)Math.cos(largeRadiusAngle);
                float y = (this.mLargeRadius + this.mSmallRadius * (float)Math.sin(smallRadiusAngle)) * (float)Math.cos(largeRadiusAngle);
                float z = zNorm = this.mSmallRadius * (float)Math.cos(smallRadiusAngle);
                normals[vertIndex] = xNorm * normLen;
                vertices[vertIndex++] = x;
                normals[vertIndex] = yNorm * normLen;
                vertices[vertIndex++] = y;
                normals[vertIndex] = zNorm * normLen;
                vertices[vertIndex++] = z;
                if (i <= 0 || j <= 0) continue;
                int a = (this.mSegmentsS + 1) * j + i;
                int b = (this.mSegmentsS + 1) * j + i - 1;
                int c = (this.mSegmentsS + 1) * (j - 1) + i - 1;
                int d = (this.mSegmentsS + 1) * (j - 1) + i;
                indices[index++] = a;
                indices[index++] = c;
                indices[index++] = b;
                indices[index++] = a;
                indices[index++] = d;
                indices[index++] = c;
            }
        }
        float[] textureCoords = null;
        if (this.mCreateTextureCoords) {
            int numUvs = (this.mSegmentsL + 1) * (this.mSegmentsS + 1) * 2;
            textureCoords = new float[numUvs];
            numUvs = 0;
            for (j = 0; j <= this.mSegmentsL; ++j) {
                for (i = this.mSegmentsS; i >= 0; --i) {
                    textureCoords[numUvs++] = (float)i / (float)this.mSegmentsS;
                    textureCoords[numUvs++] = (float)j / (float)this.mSegmentsL;
                }
            }
        }
        float[] colors = null;
        if (this.mCreateVertexColorBuffer) {
            int numColors = numVertices * 4;
            colors = new float[numColors];
            for (j = 0; j < numColors; j += 4) {
                colors[j] = 1.0f;
                colors[j + 1] = 0.0f;
                colors[j + 2] = 0.0f;
                colors[j + 3] = 1.0f;
            }
        }
        this.setData(vertices, normals, textureCoords, colors, indices, createVBOs);
        vertices = null;
        normals = null;
        textureCoords = null;
        indices = null;
    }
}

